/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.MemberLotteryService;
import com.bizvane.appletserviceimpl.utils.UUIDUtils;
import com.bizvane.mktcenterservice.models.bo.MktActivityDetailAndPicture;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizeRecordPO;
import com.bizvane.mktcenterservice.models.vo.ActivityPrizeBO;
import com.bizvane.mktcenterservice.models.vo.ProbabilityVO;
import com.bizvane.mktcenterservice.rpc.ActivityEGServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import java.text.ParseException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberLottery"}, method={RequestMethod.POST})
public class MemberLotteryController {
    @Autowired
    private MemberLotteryService memberLotteryService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private ActivityEGServiceRpc activityEgServiceRpc;

    @RequestMapping(value={"/winningRecord"}, method={RequestMethod.POST})
    public ResponseData<MktActivityPrizeRecordPO> winningRecord(MktActivityPrizeRecordPO mktActivityPrizeRecordPo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        mktActivityPrizeRecordPo.setMemberCode(memberCode);
        return this.memberLotteryService.winningRecord(mktActivityPrizeRecordPo);
    }

    @RequestMapping(value={"/activityRules"}, method={RequestMethod.POST})
    public ResponseData<ActivityPrizeBO> activityRules(String activePriceCode, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.memberLotteryService.activityRules(activePriceCode);
    }

    @RequestMapping(value={"/rotation"}, method={RequestMethod.POST})
    public ResponseData<MktActivityPrizeRecordPO> rotation(MktActivityPrizeRecordPO mktActivityPrizeRecordPo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.memberLotteryService.rotation(mktActivityPrizeRecordPo);
    }

    @RequestMapping(value={"/theWayToAcquireIntegral"}, method={RequestMethod.POST})
    public ResponseData<ActivityPrizeBO> theWayToAcquireIntegral(String activePriceCode, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.memberLotteryService.theWayToAcquireIntegral(activePriceCode);
    }

    @RequestMapping(value={"/lotteryDoIng"}, method={RequestMethod.POST})
    public ResponseData lotteryDoIng(String activePriceCode, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.memberLotteryService.lotteryDoIng(activePriceCode, memberCode);
    }

    @RequestMapping(value={"/countIntegral"}, method={RequestMethod.POST})
    public ResponseData<ActivityPrizeBO> countIntegral(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.memberLotteryService.countIntegral(memberCode);
    }

    @RequestMapping(value={"/scanningLottery"}, method={RequestMethod.POST})
    public ResponseData<ActivityPrizeBO> scanningLottery(String activePriceCode, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.memberLotteryService.scanningLottery(memberCode, activePriceCode);
    }

    @RequestMapping(value={"/luckDraw"}, method={RequestMethod.POST})
    public ResponseData<ActivityPrizeBO> luckDraw(String activePriceCode, HttpServletRequest request) throws ParseException {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            ProbabilityVO probabilityVO = new ProbabilityVO();
            probabilityVO.setActivityCode(activePriceCode);
            MktActivityDetailAndPicture mktActivityDetailAndPicture = (MktActivityDetailAndPicture)this.activityEgServiceRpc.getMktActivityPOWithBLOBs(probabilityVO).getData();
            String uuid = UUIDUtils.getUUID();
            JSONObject jsonObject1 = new JSONObject();
            jsonObject1.put("activityType", (Object)mktActivityDetailAndPicture.getActivityType());
            jsonObject1.put("uuid", (Object)uuid);
            jsonObject1.put("mktTraceId", (Object)mktActivityDetailAndPicture.getMktTraceId());
            responseData.setData((Object)jsonObject1);
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.memberLotteryService.luckDraw(activePriceCode, memberCode);
    }

    @RequestMapping(value={"/addressLotteryRecord"}, method={RequestMethod.POST})
    public ResponseData addressLotteryRecord(MktActivityPrizeRecordPO mktActivityPrizeRecordPo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        this.memberLotteryService.addressLotteryRecord(mktActivityPrizeRecordPo);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }
}

