/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.common.HttpUtil;
import com.bizvane.appletservice.interfaces.ActivityService;
import com.bizvane.appletservice.interfaces.FitmentService;
import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.models.bo.AppletBrandMenberBo;
import com.bizvane.appletservice.models.bo.AppletByCodeBo;
import com.bizvane.appletservice.models.vo.ElectCardConfigVo;
import com.bizvane.appletservice.models.vo.WxMbrRegisteRequestVo;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.appletserviceimpl.utils.UUIDUtils;
import com.bizvane.centercontrolservice.rpc.DefProductServiceRpc;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysCompanyProductPo;
import com.bizvane.centerstageservice.models.vo.SysAccountVo;
import com.bizvane.centerstageservice.models.vo.SysBrandVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.CompanyProductServiceRpc;
import com.bizvane.centerstageservice.rpc.SystemServiceRpc;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.WxChannelInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MiniProgramOpenCardService;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.service.card.request.RequestOpenCardModel;
import com.bizvane.members.facade.service.card.response.ResponseOpenCardModel;
import com.bizvane.members.facade.service.electcard.ElectCardConfigApiService;
import com.bizvane.members.facade.service.electcard.MbrElectCardOpenErrorRpcService;
import com.bizvane.members.facade.service.qywxapi.QwChannelApiService;
import com.bizvane.members.facade.vo.MbrElectCardOpenErrorVo;
import com.bizvane.members.facade.vo.WxChannelAndMemberVo;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.mktcenterservice.models.bo.MktActivityDetailAndPicture;
import com.bizvane.mktcenterservice.models.vo.ProbabilityVO;
import com.bizvane.mktcenterservice.rpc.ActivityEGServiceRpc;
import com.bizvane.unifiedreg.rpc.AppletServiceFeign;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatenterprise.service.rpc.WxqyInteractHistoryServiceRpc;
import com.bizvane.wechatfacade.interfaces.UserAuthorizationFeign;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.bizvane.wechatfacade.models.vo.UserAuthorizationGetPhoneNumberRequestVO;
import com.bizvane.wechatfacade.models.vo.UserAuthorizationGetPhoneNumberResponseVO;
import com.bizvane.wechatfacade.models.vo.UserAuthorizationGetUserInfoRequestVO;
import com.bizvane.wechatfacade.models.vo.UserAuthorizationGetUserInfoResponseVO;
import feign.FeignException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u767b\u5f55\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/user"})
public class LoginController {
    @Autowired
    private LoginService loginService;
    @Autowired
    private UserAuthorizationFeign userAuthorizationFeign;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MiniProgramOpenCardService miniProgramOpenCardService;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private QwChannelApiService queryWxChannelInfoOnly;
    @Autowired
    private WxqyInteractHistoryServiceRpc wxqyInteractHistoryServiceRpc;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private FitmentService fitmentService;
    @Autowired
    private ActivityEGServiceRpc activityEgServiceRpc;
    @Autowired
    private ElectCardConfigApiService electCardConfigApiService;
    @Autowired
    private AppletServiceFeign appletServiceFeign;
    @Autowired
    private MbrElectCardOpenErrorRpcService mbrElectCardOpenErrorRpcService;
    @Value(value="#{'${electCardRegister.companyIdList}'.split(',')}")
    private List<Long> electCardRegisterCompanyIdList;
    @Autowired
    private CompanyProductServiceRpc companyProductServiceRpc;
    @Autowired
    private DefProductServiceRpc defProductServiceRpc;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    private static final String MEMEBER_ACTIVITY = "api/marketActivity/newMemberByActivity";
    @Value(value="${wxStore.baseUrl}")
    private String doMainName;
    @Autowired
    private SystemServiceRpc systemServiceRpc;
    @Autowired
    private Environment env;

    @RequestMapping(value={"/sendVerificationCode"})
    public ResponseData<Integer> sendVerificationCode(String areaCode, String phone, String sign, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("bizvaneSessionId\u6ca1\u6709");
            responseData.setCode(100);
            return responseData;
        }
        String sysBrandId = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "sysBrandId"));
        return this.loginService.sendVerificationCode(sign, "a4ad8ac4-4051-4659-9bb9-17f8ebc65f3d", phone, sysBrandId, areaCode);
    }

    @RequestMapping(value={"/byCode"})
    public ResponseData byCode(@RequestParam(value="code") String code, @RequestParam(value="appid") String appid) {
        String bizvanekey;
        ResponseData stringResponseData;
        ResponseData responseData = new ResponseData();
        logger.info("code={} , appid={}", (Object)code, (Object)appid);
        if (code == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("code\u4e3a\u7a7a");
            responseData.setCode(100);
            return responseData;
        }
        if (appid == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("appId\u4e3a\u7a7a");
            responseData.setCode(100);
            return responseData;
        }
        ResponseData wxPublicPoByAppId = this.wxPublicServiceFeign.getWxPublicPOByAppId(appid);
        Long sysBrandId = ((WxPublicPO)wxPublicPoByAppId.getData()).getSysBrandId();
        logger.info("ByCode sysBrandId={}", (Object)sysBrandId);
        ResponseData brandById = this.brandServiceRpc.getBrandByID(sysBrandId);
        SysBrandPo brandByIdData = (SysBrandPo)brandById.getData();
        String brandLogo = null;
        if (brandByIdData != null && StringUtils.isNotBlank((CharSequence)brandByIdData.getBrandLogo())) {
            brandLogo = QiNiuUtil.httpUrlCompatible((String)this.qiNiuConfig.getDomain(), (String)((SysBrandPo)brandById.getData()).getBrandLogo());
        }
        if ((stringResponseData = this.userAuthorizationFeign.byCode(code, appid)).getData() == null) {
            responseData.setMessage("bizvanekey\u672a\u83b7\u53d6");
            responseData.setCode(100);
            responseData.setData(null);
        }
        if (StringUtils.isNotBlank((CharSequence)(bizvanekey = (String)stringResponseData.getData()))) {
            this.redisTemplateService.stringSetValueAndExpireTime((Object)bizvanekey, (Object)bizvanekey, 7776000000L);
            AppletByCodeBo appletByCodeBo = new AppletByCodeBo();
            appletByCodeBo.setBizvanekey(bizvanekey);
            appletByCodeBo.setBrandLogo(brandLogo);
            appletByCodeBo.setQiniuUrl(this.qiNiuConfig.getDomain());
            logger.info("byCode\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)appletByCodeBo));
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)appletByCodeBo);
            return responseData;
        }
        responseData.setMessage("bizvanekey\u4e3a\u7a7a");
        responseData.setCode(100);
        return responseData;
    }

    @ApiOperation(value="byCodeNew\u65b0\u63a5\u53e3", notes="byCodeNew\u65b0\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="code", required=true), @ApiImplicitParam(name="appid", value="appid", required=true)})
    @GetMapping(value={"/getUserInfobyCode"})
    public ResponseData<AppletBrandMenberBo> getUserInfobyCode(@RequestParam(value="code") String code, @RequestParam(value="appid") String appid) {
        try {
            return this.loginService.getUserInfobyCode(code, appid);
        }
        catch (Exception exception) {
            return new ResponseData(100, exception.getMessage());
        }
    }

    @RequestMapping(value={"/getUserInfo"})
    public ResponseData getUserInfo(HttpServletRequest request, @RequestParam(value="userInfoData") String userInfoData, @RequestParam(value="appid") String appid) {
        ResponseData responseData = new ResponseData();
        UserAuthorizationGetUserInfoRequestVO userAuthorizationGetUserInfoRequestVo = new UserAuthorizationGetUserInfoRequestVO();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("bizvaneSessionId\u6ca1\u6709");
            responseData.setCode(100);
            return responseData;
        }
        String bizvanekey = (String)this.redisTemplateService.stringGetStringByKey((Object)bizvaneSessionId);
        logger.info("getUserInfo bizkey ={}    bizsessionId ={}", (Object)bizvanekey, (Object)bizvaneSessionId);
        if (!bizvaneSessionId.equals(bizvanekey)) {
            responseData.setMessage("bizvaneSessionId\u65e0\u6548");
            responseData.setCode(-100);
            return responseData;
        }
        userAuthorizationGetUserInfoRequestVo.setAppid(appid);
        userAuthorizationGetUserInfoRequestVo.setBizvaneSessionId(bizvaneSessionId);
        userAuthorizationGetUserInfoRequestVo.setUserInfoData(userInfoData);
        logger.info("userInfo\u5165\u53c2={}", (Object)JSON.toJSONString((Object)userAuthorizationGetUserInfoRequestVo));
        ResponseData userInfo = this.userAuthorizationFeign.getUserInfo(userAuthorizationGetUserInfoRequestVo);
        logger.info("\u6388\u6743\u8fd4\u56de\u7684\u7ed3\u679c={}", (Object)JSON.toJSONString((Object)userInfo.getData()));
        if (userInfo.getData() == null) {
            responseData.setMessage("\u6388\u6743\u83b7\u53d6\u4fe1\u606f\u5931\u8d25");
            responseData.setCode(100);
            return responseData;
        }
        String memberCode = ((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getMemberCode();
        AppletBrandMenberBo appletBrandMenberBo = new AppletBrandMenberBo();
        appletBrandMenberBo.setOpenId(((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getOpenId());
        appletBrandMenberBo.setUnionId(((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getUnionId());
        if (userInfo.getData() == null || ((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getSysBrandId() == null) {
            responseData.setCode(100);
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getOpenId" + bizvaneSessionId), (Object)((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getOpenId(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getUnionId" + bizvaneSessionId), (Object)((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getUnionId(), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getAppId" + bizvaneSessionId), (Object)appid, 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("sysBrandId" + bizvaneSessionId), (Object)String.valueOf(((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getSysBrandId()), 7776000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "sysBrandId"), (Object)String.valueOf(((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getSysBrandId()), 7776000000L);
        if (StringUtils.isNotBlank((CharSequence)memberCode)) {
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(memberCode);
            ResponseData model = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            if (model.getData() != null) {
                String phone = ((MemberInfoModel)model.getData()).getPhone();
                this.redisTemplateService.stringSetValueAndExpireTime((Object)("Phone:" + memberCode), (Object)phone, 7776000000L);
            }
            logger.info("getUserInfo memberCode={}  bizvaneSessionId={}", (Object)memberCode, (Object)bizvaneSessionId);
            this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "memberCode"), (Object)memberCode, 7776000000L);
            this.redisTemplateService.stringSetValueAndExpireTime((Object)(memberCode + "bizvaneSessionId"), (Object)bizvaneSessionId, 7776000000L);
            logger.info("memberCode\u6388\u6743\u5df2\u5f00\u5361={}", this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode")));
            appletBrandMenberBo.setOpenCard(true);
            appletBrandMenberBo.setSysBrandId(((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getSysBrandId());
            appletBrandMenberBo.setSysCompanyId(((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getSysCompanyId());
            responseData.setMessage("\u5df2\u5f00\u5361");
            responseData.setData((Object)appletBrandMenberBo);
            logger.info("openCard={}", (Object)JSON.toJSONString((Object)appletBrandMenberBo));
            return responseData;
        }
        appletBrandMenberBo.setSysCompanyId(((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getSysCompanyId());
        appletBrandMenberBo.setSysBrandId(((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getSysBrandId());
        appletBrandMenberBo.setOpenCard(false);
        responseData.setMessage("\u672a\u5f00\u5361");
        responseData.setData((Object)appletBrandMenberBo);
        logger.info("openCard={}", (Object)JSON.toJSONString((Object)appletBrandMenberBo));
        return responseData;
    }

    @RequestMapping(value={"/clearSessionCache"})
    public ResponseData clearSessionCache(String memberCode) {
        logger.info("\u6e05\u7a7abizvaneSessionId   memberCode={}", (Object)memberCode);
        ResponseData responseData = new ResponseData();
        String key = (String)this.redisTemplateService.stringGetStringByKey((Object)(memberCode + "bizvaneSessionId"));
        logger.info("\u5220\u9664\u7684key \uff1a{}", (Object)(key + "memberCode"));
        this.redisTemplateService.deleteFromRedis((Object)(key + "memberCode"));
        this.redisTemplateService.deleteFromRedis((Object)"memberCode");
        return responseData;
    }

    @RequestMapping(value={"/openCardMenbr"})
    public ResponseData openCardMenbr(AppletBrandMenberBo appletBrandMenberBo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        logger.info("\u5f00\u5361\u63a5\u53e3\u5165\u53c2={}", (Object)JSON.toJSONString((Object)appletBrandMenberBo));
        String mktTaskId = appletBrandMenberBo.getMktTaskId();
        if (appletBrandMenberBo.getPhone() == null) {
            responseData.setMessage("\u6ca1\u6709\u6536\u5230\u624b\u673a\u53f7");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u6536\u5230bizvaneSessionId");
            return responseData;
        }
        logger.info("oderMemberCode={}", (Object)appletBrandMenberBo.getOderMemberCode());
        RequestOpenCardModel requestOpenCardModel = new RequestOpenCardModel();
        requestOpenCardModel.setPhone(appletBrandMenberBo.getPhone());
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        String unionId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getUnionId" + bizvaneSessionId));
        String appid = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        UserAuthorizationGetPhoneNumberRequestVO userAuthorizationGetPhoneNumberRequestVO = new UserAuthorizationGetPhoneNumberRequestVO();
        userAuthorizationGetPhoneNumberRequestVO.setAppid(appid);
        userAuthorizationGetPhoneNumberRequestVO.setBizvaneSessionId(bizvaneSessionId);
        userAuthorizationGetPhoneNumberRequestVO.setPhoneNumberData(requestOpenCardModel.getPhone());
        logger.info("openId={} , unionId={} , appid={} , bizvaneSessionId={}", new Object[]{openId, unionId, appid, bizvaneSessionId});
        if (StringUtils.isBlank((CharSequence)openId) || StringUtils.isBlank((CharSequence)unionId) || StringUtils.isBlank((CharSequence)appid) || StringUtils.isBlank((CharSequence)bizvaneSessionId)) {
            responseData.setMessage("\u7f13\u5b58\u6307\u6807\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData phoneNumber = this.userAuthorizationFeign.getPhoneNumber(userAuthorizationGetPhoneNumberRequestVO);
        if (phoneNumber.getData() == null) {
            responseData.setMessage("\u89e3\u5bc6\u624b\u673a\u53f7\u63a5\u53e3\u5f02\u5e38");
            responseData.setCode(100);
            return responseData;
        }
        if (((UserAuthorizationGetPhoneNumberResponseVO)phoneNumber.getData()).getPurePhoneNumber() == null) {
            responseData.setMessage("\u89e3\u5bc6\u624b\u673a\u53f7\u5931\u8d25");
            responseData.setCode(100);
            return responseData;
        }
        requestOpenCardModel.setOpenId(openId);
        requestOpenCardModel.setUnionId(unionId);
        requestOpenCardModel.setAppId(appid);
        requestOpenCardModel.setPhone(((UserAuthorizationGetPhoneNumberResponseVO)phoneNumber.getData()).getPurePhoneNumber());
        requestOpenCardModel.setRecommendMemberCode(appletBrandMenberBo.getOderMemberCode());
        String uuid = request.getHeader("UUID");
        logger.info("UUID\u5f00\u5361={}", (Object)uuid);
        if (StringUtils.isNotBlank((CharSequence)uuid)) {
            String uuidJonString = (String)this.redisTemplateService.stringGetStringByKey((Object)uuid);
            logger.info("uuidJonString={}", (Object)uuidJonString);
            if (StringUtils.isNotBlank((CharSequence)uuidJonString)) {
                JSONObject jsonObject = JSONObject.parseObject((String)uuidJonString);
                String activityType = jsonObject.getString("activityType");
                String mktActivityId = jsonObject.getString("mktActivityId");
                ProbabilityVO vo = new ProbabilityVO();
                vo.setMktActivityId(Long.valueOf(mktActivityId));
                ResponseData mktActivityPoWithBlobs = this.activityEgServiceRpc.getMktActivityPOWithBLOBs(vo);
                activityType = String.valueOf(((MktActivityDetailAndPicture)mktActivityPoWithBlobs.getData()).getActivityType());
                logger.info("activityType={}", (Object)activityType);
                logger.info("mktActivityId={}", (Object)mktActivityId);
                requestOpenCardModel.setActivityId(Long.valueOf(mktActivityId));
                requestOpenCardModel.setActivityType(Integer.valueOf(activityType));
            }
        }
        ResponseOpenCardModel responseOpenCardModel = null;
        try {
            ResponseData responseOpenCardModelResponseData = this.miniProgramOpenCardService.openCardV(requestOpenCardModel);
            if (responseOpenCardModelResponseData == null) {
                responseData.setMessage("\u4f1a\u5458\u5f00\u5361\u5f02\u5e38");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                return responseData;
            }
            if (SysResponseEnum.SUCCESS.getCode() != responseOpenCardModelResponseData.getCode()) {
                responseData.setMessage(responseOpenCardModelResponseData.getMessage());
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                return responseData;
            }
            responseOpenCardModel = (ResponseOpenCardModel)responseOpenCardModelResponseData.getData();
            logger.info("open card result {}", (Object)JSON.toJSONString((Object)responseOpenCardModelResponseData));
        }
        catch (FeignException e1) {
            logger.info("openCardMenbr:{}", (Object)e1.getMessage());
            String errorMsg = e1.getMessage();
            int indexOf = errorMsg.indexOf("content:");
            if (indexOf >= 0) {
                String errorResponseData = errorMsg.substring(indexOf + 9);
                responseData = (ResponseData)JacksonUtil.json2Obj((String)errorResponseData, ResponseData.class);
            } else {
                responseData.setCode(-1);
                responseData.setMessage(errorMsg);
            }
            return responseData;
        }
        catch (RuntimeException r) {
            responseData.setMessage(r.getMessage());
            responseData.setCode(-1);
            return responseData;
        }
        if (responseOpenCardModel.getCode() == 9000) {
            responseData.setMessage(responseOpenCardModel.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        if (responseOpenCardModel.getMemberCode() != null) {
            this.redisTemplateService.stringSetValueAndExpireTime((Object)("Phone:" + responseOpenCardModel.getMemberCode()), (Object)((UserAuthorizationGetPhoneNumberResponseVO)phoneNumber.getData()).getPurePhoneNumber(), 7776000000L);
            Integer operateType = responseOpenCardModel.getOperateType();
            this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "memberCode"), (Object)responseOpenCardModel.getMemberCode(), 7776000000L);
            this.redisTemplateService.stringSetValueAndExpireTime((Object)(responseOpenCardModel.getMemberCode() + "bizvaneSessionId"), (Object)bizvaneSessionId, 7776000000L);
            ResponseData wxPublicPoByAppId = this.wxPublicServiceFeign.getWxPublicPOByAppId(appid);
            Long sysBrandId = ((WxPublicPO)wxPublicPoByAppId.getData()).getSysBrandId();
            Long sysCompanyId = ((WxPublicPO)wxPublicPoByAppId.getData()).getSysCompanyId();
            this.activityService.executeActivity(sysBrandId, responseOpenCardModel.getMemberCode(), operateType);
            if (StringUtils.isNotBlank((CharSequence)appletBrandMenberBo.getOderMemberCode())) {
                this.activityService.inviteOpenCoder(responseOpenCardModel.getMemberCode(), appletBrandMenberBo.getOderMemberCode(), mktTaskId);
            }
            WxChannelInfoVo wxChannelInfoVo = new WxChannelInfoVo();
            wxChannelInfoVo.setMemberCode(responseOpenCardModel.getMemberCode());
            wxChannelInfoVo.setMiniProgram(Integer.valueOf(1));
            ResponseData wxChannelInfoAndMemberInfo = this.wxChannelInfoApiService.getWxChannelInfoAndMemberInfo(wxChannelInfoVo);
            String wxOpenId = ((WxChannelAndMemberVo)wxChannelInfoAndMemberInfo.getData()).getWxChannelInfoVo().getWxOpenId();
            String wxAppId = ((WxChannelAndMemberVo)wxChannelInfoAndMemberInfo.getData()).getWxChannelInfoVo().getAppId();
            if (StringUtils.isNotBlank((CharSequence)wxOpenId) && StringUtils.isNotBlank((CharSequence)wxAppId) && StringUtils.isNotBlank((CharSequence)responseOpenCardModel.getMemberCode())) {
                this.activityService.changeFansToMember(wxOpenId, wxAppId, responseOpenCardModel.getMemberCode(), sysCompanyId, sysBrandId);
            }
            try {
                if (StringUtils.isNotBlank((CharSequence)appletBrandMenberBo.getActivityNo()) && StringUtils.isNotBlank((CharSequence)appletBrandMenberBo.getActivityOrdersNo())) {
                    String userNo = responseOpenCardModel.getMemberCode();
                    String url = this.doMainName + MEMEBER_ACTIVITY + "?activityNo" + appletBrandMenberBo.getActivityNo() + "&activityOrdersNo=" + appletBrandMenberBo.getActivityOrdersNo() + "&userNo" + userNo;
                    logger.info("\u5f00\u5361\u8c03\u7528\u5fae\u5546\u57ceURL={}", (Object)url);
                    String result = HttpUtil.get((String)url);
                    logger.info("\u5fae\u5546\u57ce\u8fd4\u56de\u6570\u636e={}", (Object)result);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            SysBrandVo sysBrandVo = new SysBrandVo();
            sysBrandVo.setSysBrandId(sysBrandId);
            ResponseData skipByBrandId = this.brandServiceRpc.getSkipByBrandId(sysBrandVo);
            String skipByBrandIdData = (String)skipByBrandId.getData();
            AppletBrandMenberBo menberBo = new AppletBrandMenberBo();
            menberBo.setSkipByBrandId(skipByBrandIdData);
            menberBo.setPhone(responseOpenCardModel.getPhone());
            WxChannelInfoModel wxChannelInfoModel = new WxChannelInfoModel();
            wxChannelInfoModel.setBrandId(sysBrandId);
            wxChannelInfoModel.setOpenId(openId);
            wxChannelInfoModel.setUnionId(unionId);
            logger.info("operateType={} , mktTaskId={} , sysBrandId={} , \u4f1a\u5458\u4fe1\u606f\u5b58\u50a8={}", new Object[]{operateType, mktTaskId, sysBrandId, this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"))});
            if (responseOpenCardModel.getOpenCardGuideId() != null) {
                menberBo.setMemberCode(responseOpenCardModel.getMemberCode());
            } else {
                menberBo.setMemberCode(null);
            }
            responseData.setMessage("\u5f00\u5361\u6210\u529f");
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)menberBo);
            return responseData;
        }
        responseData.setMessage("\u5f00\u5361\u5931\u8d25,\u672a\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f");
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        return responseData;
    }

    @ApiOperation(value="byCodeNew\u65b0\u63a5\u53e3", notes="byCodeNew\u65b0\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appid", value="appid", required=true), @ApiImplicitParam(name="code", value="code", required=true), @ApiImplicitParam(name="phone", value="phone", required=true), @ApiImplicitParam(name="userInfoData", value="userInfoData", required=true), @ApiImplicitParam(name="oderMemberCode", value="oderMemberCode", example="\u6ce8\u518c\u65f6\u6709\u63a8\u8350\u4eba\u65f6\u4f20\u5165"), @ApiImplicitParam(name="activityNo", value="activityNo", example="\u6d3b\u52a8\u5f00\u5361\u65f6\u4f20\u5165"), @ApiImplicitParam(name="mktTaskId", value="mktTaskId", example="\u9080\u8bf7\u5f00\u5361\u65f6\u4f20\u5165")})
    @PostMapping(value={"/getMbrAndOpenCard"})
    public ResponseData<AppletBrandMenberBo> getMbrAndOpenCard(HttpServletRequest request, WxMbrRegisteRequestVo wxMbrRegisteRequestVo) {
        try {
            if ("null".equalsIgnoreCase(wxMbrRegisteRequestVo.getOderMemberCode())) {
                wxMbrRegisteRequestVo.setOderMemberCode(null);
            }
            if ("null".equalsIgnoreCase(wxMbrRegisteRequestVo.getMktTaskId())) {
                wxMbrRegisteRequestVo.setMktTaskId(null);
            }
            if ("null".equalsIgnoreCase(wxMbrRegisteRequestVo.getActivityNo())) {
                wxMbrRegisteRequestVo.setActivityNo(null);
            }
            if ("null".equalsIgnoreCase(wxMbrRegisteRequestVo.getActivityOrdersNo())) {
                wxMbrRegisteRequestVo.setActivityOrdersNo(null);
            }
            return this.loginService.getMbrAndOpenCard(request, wxMbrRegisteRequestVo);
        }
        catch (Exception exception) {
            return new ResponseData(100, exception.getMessage());
        }
    }

    @ApiOperation(value="\u7535\u5b50\u4f1a\u5458\u5361\u5f00\u5361\u524d,\u89e3\u6790\u6388\u6743\u4fe1\u606f\u4ee5\u53ca\u8bb0\u5f55\u94fe\u8def", notes="\u7535\u5b50\u4f1a\u5458\u5361\u5f00\u5361\u524d,\u89e3\u6790\u6388\u6743\u4fe1\u606f\u4ee5\u53ca\u8bb0\u5f55\u94fe\u8def")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appid", value="appid", required=true), @ApiImplicitParam(name="code", value="code", required=true), @ApiImplicitParam(name="userInfoData", value="userInfoData", required=true)})
    @PostMapping(value={"/resolveAndRecord"})
    public ResponseData<AppletBrandMenberBo> resolveAndRecord(HttpServletRequest request, @RequestBody WxMbrRegisteRequestVo wxMbrRegisteRequestVo) {
        try {
            return this.loginService.resolveAndRecord(request, wxMbrRegisteRequestVo);
        }
        catch (Exception exception) {
            logger.info("loginService#resolveAndRecord,\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
            return new ResponseData(100, exception.getMessage());
        }
    }

    @ApiOperation(value="\u7535\u5b50\u4f1a\u5458\u5361\u5f00\u5361\u5b8c\u6210,\u5269\u4f59\u4e1a\u52a1\u5904\u7406", notes="\u7535\u5b50\u4f1a\u5458\u5361\u5f00\u5361\u5b8c\u6210,\u5269\u4f59\u4e1a\u52a1\u5904\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appid", value="appid", required=true), @ApiImplicitParam(name="unionId", value="unionId", required=true)})
    @PostMapping(value={"/businessAfterOpenCard"})
    public ResponseData<AppletBrandMenberBo> businessAfterOpenCard(HttpServletRequest request, @RequestBody WxMbrRegisteRequestVo wxMbrRegisteRequestVo) {
        try {
            wxMbrRegisteRequestVo.setElectCardFromWx(Integer.valueOf(1));
            return this.loginService.businessAfterOpenCard(request, wxMbrRegisteRequestVo);
        }
        catch (Exception exception) {
            logger.info("loginService#businessAfterOpenCard,\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
            this.updateMbrElectCardErroInfo(wxMbrRegisteRequestVo, exception);
            return new ResponseData(100, exception.getMessage());
        }
    }

    private void updateMbrElectCardErroInfo(WxMbrRegisteRequestVo wxMbrRegisteRequestVo, Exception exception) {
        if (wxMbrRegisteRequestVo.getElectCardOpenErrorId() != null) {
            MbrElectCardOpenErrorVo mbrElectCardOpenErrorVo = new MbrElectCardOpenErrorVo();
            mbrElectCardOpenErrorVo.setElectCardOpenErrorId(wxMbrRegisteRequestVo.getElectCardOpenErrorId());
            mbrElectCardOpenErrorVo.setErroInfo(exception.getMessage());
            logger.info("mbrElectCardOpenErrorRpcService#updateByVo,request:{}", (Object)JSONObject.toJSONString((Object)mbrElectCardOpenErrorVo));
            this.mbrElectCardOpenErrorRpcService.updateByVo(mbrElectCardOpenErrorVo);
        }
    }

    @RequestMapping(value={"/redisMan"})
    public ResponseData redisMan() {
        ResponseData responseData = new ResponseData();
        String uuid = UUIDUtils.getUUID();
        this.redisTemplateService.stringSetValueAndExpireTime((Object)uuid, (Object)"11111111", 7776000000L);
        String s = (String)this.redisTemplateService.stringGetStringByKey((Object)uuid);
        responseData.setData((Object)s);
        return responseData;
    }

    @RequestMapping(value={"/getBizSessionIdByMemberCode"})
    public ResponseData getBizSessionIdByMemverCode(String memberCode) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = "";
        String redisMmeberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(memberCode + "testLogin"));
        String avc = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (redisMmeberCode == null || redisMmeberCode == "") {
            bizvaneSessionId = UUIDUtils.getUUID();
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(memberCode);
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            MemberInfoModel member = (MemberInfoModel)singleMemberModel.getData();
            this.redisTemplateService.stringSetValueAndExpireTime((Object)("sysBrandId" + bizvaneSessionId), (Object)String.valueOf(member.getBrandId()), 7776000000L);
            this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "sysBrandId"), (Object)String.valueOf(member.getBrandId()), 7776000000L);
            this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "memberCode"), (Object)memberCode, 7776000000L);
            this.redisTemplateService.stringSetValueAndExpireTime((Object)(memberCode + "testLogin"), (Object)bizvaneSessionId, 7776000000L);
        } else {
            bizvaneSessionId = redisMmeberCode;
        }
        responseData.setData((Object)bizvaneSessionId);
        return responseData;
    }

    @RequestMapping(value={"/getBrandIdByAppId"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<Long> getBrandIdByAppId(String appId, HttpServletResponse response) {
        logger.info("getBrandIdByAppId appid:{}", (Object)appId);
        ResponseData responseData = new ResponseData();
        ResponseData wxPublicPoByAppId = this.wxPublicServiceFeign.getWxPublicPOByAppId(appId);
        if (wxPublicPoByAppId.getData() != null) {
            Long sysBrandId = ((WxPublicPO)wxPublicPoByAppId.getData()).getSysBrandId();
            logger.info("getBrandIdByAppId sysBrandId={}", (Object)sysBrandId);
            responseData.setData((Object)sysBrandId);
        } else {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        }
        return responseData;
    }

    @RequestMapping(value={"/getElectCardConfig"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<ElectCardConfigVo> getElectCardConfig(String appId) {
        ResponseData responseData = new ResponseData();
        ResponseData wxPublicPOResponseData = this.wxPublicServiceFeign.getWxPublicPOByAppId(appId);
        logger.info("wxPublicPOResponseData:{}", (Object)JSONObject.toJSONString((Object)wxPublicPOResponseData));
        if (wxPublicPOResponseData == null || wxPublicPOResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || wxPublicPOResponseData.getData() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        WxPublicPO wxPublicPO = (WxPublicPO)wxPublicPOResponseData.getData();
        String companyProductId = (String)this.redisTemplateService.stringGetStringByKey((Object)("wxElectCardProduct:" + wxPublicPO.getSysCompanyId()));
        if (StringUtils.isEmpty((CharSequence)companyProductId)) {
            Long electProductId = this.defProductServiceRpc.getProductIdByProductName("\u5fae\u4fe1\u7535\u5b50\u4f1a\u5458\u5361");
            ResponseData companyProduct = this.companyProductServiceRpc.getCompanyProduct(wxPublicPO.getSysCompanyId(), electProductId);
            if (companyProduct.getCode() == SysResponseEnum.SUCCESS.getCode() && companyProduct.getData() != null) {
                Long sysCompanyProductId = ((SysCompanyProductPo)companyProduct.getData()).getSysCompanyProductId();
                this.redisTemplateService.stringSetValueAndExpireTime((Object)("wxElectCardProduct:" + wxPublicPO.getSysCompanyId()), (Object)String.valueOf(sysCompanyProductId), 0x6DDD00L);
                logger.info("electCardRegister companyId={}, companyProductId={}", (Object)wxPublicPO.getSysCompanyId(), (Object)sysCompanyProductId);
            } else {
                logger.info("electCardRegister companyId={}, companyProductId={}", (Object)wxPublicPO.getSysCompanyId(), (Object)companyProductId);
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                return responseData;
            }
        }
        ResponseData electCardRes = this.appletServiceFeign.queryElectCardConfig(wxPublicPO.getSysCompanyId(), wxPublicPO.getSysBrandId());
        logger.info("electCardRes:{}", (Object)JSONObject.toJSONString((Object)electCardRes));
        if (electCardRes == null || electCardRes.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)electCardRes.getData()))) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        ResponseData publicPOResponseData = this.wxPublicServiceFeign.getWxPublicInfo(wxPublicPO.getSysCompanyId(), wxPublicPO.getSysBrandId(), "1", "00");
        logger.info("publicPOResponseData:{}", (Object)JSONObject.toJSONString((Object)publicPOResponseData));
        if (publicPOResponseData == null || publicPOResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        String cardUrl = (String)electCardRes.getData();
        URL url = null;
        try {
            url = new URL(cardUrl);
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        System.out.println(url.getQuery());
        List nameValuePairs = URLEncodedUtils.parse((String)url.getQuery(), (Charset)Charset.forName("utf-8"));
        Map<String, String> paramMap = nameValuePairs.stream().collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
        ElectCardConfigVo electCardConfigVo = new ElectCardConfigVo();
        electCardConfigVo.setCardId(paramMap.get("encrypt_card_id"));
        electCardConfigVo.setBiz(paramMap.get("biz"));
        electCardConfigVo.setOuterStr(paramMap.get("outer_str"));
        responseData.setData((Object)electCardConfigVo);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    @RequestMapping(value={"/isCustomPhoneAuth"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData<Boolean> isCustomPhoneAuth(String appId) {
        WxPublicPO wxPublicPO = (WxPublicPO)this.wxPublicServiceFeign.getWxPublicPOByAppId(appId).getData();
        logger.info("wxPublicPOResponseData:{}", (Object)JSONObject.toJSONString((Object)wxPublicPO));
        return new ResponseData((Object)this.isProductConfig(wxPublicPO.getSysBrandId()));
    }

    @RequestMapping(value={"/getVerificationCode"})
    public ResponseData<Map<String, String>> getVerificationCode() {
        return this.systemServiceRpc.getVerificationCode();
    }

    @RequestMapping(value={"/getVerifCode"})
    public ResponseData<Map<String, String>> getVerifCode(SysAccountVo vo, String appId) {
        Long sysBrandId = ((WxPublicPO)this.wxPublicServiceFeign.getWxPublicPOByAppId(appId).getData()).getSysBrandId();
        vo.setBrandId(sysBrandId);
        return this.systemServiceRpc.getVerifCode(vo);
    }

    private boolean isProductConfig(Long sysBrandId) {
        String config = this.env.getProperty("bsyy.customPhone");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)config) && config.indexOf(sysBrandId + ",") > -1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

