/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.models.vo.TraceRecordMiniVo;
import com.bizvane.centerstageservice.models.vo.WxqyLoginResponseVO;
import com.bizvane.core.facade.interfaces.CoreTraceFeign;
import com.bizvane.core.facade.models.po.TracePO;
import com.bizvane.core.facade.models.vo.TraceRecordVo;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatenterprise.service.entity.po.MiniProgramLoginParam;
import com.bizvane.wechatenterprise.service.rpc.SystemServiceRpc;
import com.bizvane.wechatfacade.interfaces.QRCodeServiceFeign;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/coreTrace"})
public class CoreTraceController {
    @Autowired
    private CoreTraceFeign coreTraceFeign;
    @Autowired
    private SystemServiceRpc systemServiceRpc;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private QRCodeServiceFeign qrCodeServiceFeign;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/saveTraceRecord"}, method={RequestMethod.POST})
    public ResponseData saveTraceRecord(@RequestBody TraceRecordVo vo) {
        logger.info("enter CoreTraceController saveTraceRecord method! ");
        return this.coreTraceFeign.saveTraceRecord(vo);
    }

    @RequestMapping(value={"/getTraceByParamId"}, method={RequestMethod.GET})
    public ResponseData getTraceByTraceId(@RequestParam(value="paramId") Long paramId) {
        logger.info("enter CoreTraceController getTraceByParamId method! ");
        ResponseData paramData = this.qrCodeServiceFeign.queryParam(paramId);
        if (paramData == null || SysResponseEnum.SUCCESS.getCode() != paramData.getCode() || StringUtils.isBlank((String)((String)paramData.getData()))) {
            return new ResponseData();
        }
        Long traceId = Long.parseLong((String)paramData.getData());
        ResponseData tracePOResponseData = this.coreTraceFeign.selectByTraceId(traceId);
        logger.info("coreTraceFeign#selectByTraceId,res:{}", (Object)JSONObject.toJSONString((Object)tracePOResponseData));
        return tracePOResponseData;
    }

    @RequestMapping(value={"/saveTraceRecordByMini"}, method={RequestMethod.POST})
    public ResponseData saveTraceRecordByMini(@RequestBody TraceRecordMiniVo vo) {
        ResponseData paramData;
        ResponseData responseData = new ResponseData();
        logger.info("enter CoreTraceController saveTraceRecordByMini method: {}", (Object)JacksonUtil.bean2Json((Object)vo));
        if (vo.getSysCompanyId() == null) {
            responseData.setCode(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode());
            responseData.setMessage("\u516c\u53f8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)vo.getUnionId())) {
            responseData.setCode(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode());
            responseData.setMessage("unionId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (vo.getParamId() == null) {
            responseData.setCode(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode());
            responseData.setMessage("\u5fae\u4fe1\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (vo.getParamId() != null && (paramData = this.qrCodeServiceFeign.queryParam(vo.getParamId())) != null && StringUtils.isNotEmpty((String)((String)paramData.getData()))) {
            Long traceId = Long.parseLong((String)paramData.getData());
            vo.setTraceId(traceId);
            responseData = this.coreTraceFeign.saveTraceRecord((TraceRecordVo)vo);
        }
        return responseData;
    }

    @RequestMapping(value={"/saveTraceByCode"}, method={RequestMethod.POST})
    public ResponseData saveTraceByCode(@RequestParam(value="code") String code, @RequestParam(value="appId") String appId, @RequestParam(value="sourceWay", required=false) String sourceWay) {
        logger.info("enter CoreTraceController saveTraceByCode method! ");
        ResponseData responseData = new ResponseData();
        ResponseData WxPublicPoResponseData = this.wxPublicServiceFeign.getWxPublicPOByAppId(appId);
        WxPublicPO wxPublicPo = (WxPublicPO)WxPublicPoResponseData.getData();
        if (SysResponseEnum.SUCCESS.getCode() != WxPublicPoResponseData.getCode() || WxPublicPoResponseData.getData() == null) {
            logger.info("\u6839\u636eappid \u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u54c1\u724c appid:{}", (Object)appId);
            responseData.setMessage("\u6839\u636eappid \u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u54c1\u724c");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        MiniProgramLoginParam param = new MiniProgramLoginParam();
        param.setCode(code);
        param.setType("member");
        param.setSysCompanyId(wxPublicPo.getSysCompanyId());
        param.setSysBrandId(wxPublicPo.getSysBrandId());
        ResponseData wxqyResponseData = this.systemServiceRpc.miniProgramLogin(param);
        WxqyLoginResponseVO wxqyLoginResponseVO = (WxqyLoginResponseVO)wxqyResponseData.getData();
        if (SysResponseEnum.SUCCESS.getCode() != wxqyResponseData.getCode() || wxqyResponseData.getData() == null) {
            logger.info("\u8c03\u4f01\u5fae\u67e5\u8be2\u5bfc\u8d2d\u95e8\u5e97\u4fe1\u606f\u5931\u8d25\uff0ccode:{}", (Object)code);
            responseData.setMessage("\u8c03\u4f01\u5fae\u67e5\u8be2\u5bfc\u8d2d\u95e8\u5e97\u4fe1\u606f\u5931\u8d25");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        String traceValue = "";
        traceValue = StringUtils.isNotEmpty((String)sourceWay) ? "{\"source_way\":\"" + sourceWay + "\",\"channel\":\"1\",\"sub_channel\":\"2\",\"guideId\":\"" + wxqyLoginResponseVO.getSysStaffId() + "\",\"storeId\":\"" + wxqyLoginResponseVO.getSysStoreId() + "\"}" : "{\"source_way\":\"wxqyGuide2friend\",\"channel\":\"1\",\"sub_channel\":\"2\",\"guideId\":\"" + wxqyLoginResponseVO.getSysStaffId() + "\",\"storeId\":\"" + wxqyLoginResponseVO.getSysStoreId() + "\"}";
        TracePO po = new TracePO();
        po.setTraceValue(traceValue);
        po.setCreateDate(new Date());
        po.setSysCompanyId(wxPublicPo.getSysCompanyId());
        po.setBrandId(wxPublicPo.getSysBrandId());
        return this.coreTraceFeign.insertTrace(po);
    }

    @RequestMapping(value={"/insertTrace"}, method={RequestMethod.POST})
    public ResponseData insertTrace(@RequestBody TracePO vo) {
        logger.info("enter CoreTraceController insertTrace method! vo:{}", (Object)JSONObject.toJSONString((Object)vo));
        return this.coreTraceFeign.insertTrace(vo);
    }

    @RequestMapping(value={"/getStoreGuideByCode"}, method={RequestMethod.POST})
    public ResponseData<WxqyLoginResponseVO> getStoreGuideByCode(@RequestParam(value="code") String code, @RequestParam(value="sysCompanyId") Long sysCompanyId, @RequestParam(value="sysBrandId") Long sysBrandId) {
        logger.info("CoreTraceController getStoreGuideByCode ");
        MiniProgramLoginParam param = new MiniProgramLoginParam();
        param.setCode(code);
        param.setType("member");
        param.setSysCompanyId(sysCompanyId);
        param.setSysBrandId(sysBrandId);
        return this.systemServiceRpc.miniProgramLogin(param);
    }
}

