/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.common.HttpUtil;
import com.bizvane.appletservice.interfaces.WxPayService;
import com.bizvane.appletservice.models.bo.AppletWxPayBo;
import com.bizvane.appletservice.models.vo.CreateRechargeVO;
import com.bizvane.appletservice.models.vo.WxpayCreateMpVO;
import com.bizvane.appletserviceimpl.utils.WxConfig;
import com.bizvane.centerstageservice.models.po.MbrRechargeRecordPo;
import com.bizvane.centerstageservice.models.po.WxPayConfigPo;
import com.bizvane.centerstageservice.rpc.MbrRechargeServiceRpc;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.qywxapi.WxMembersApiService;
import com.bizvane.members.facade.vo.qywx.MemberFriendsKeyQueryVo;
import com.bizvane.mktcenterservice.models.vo.MemberInfoModelVOActivity;
import com.bizvane.mktcenterservice.rpc.ActivityPayServiceRpc;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WxPayServiceImpl
implements WxPayService {
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private WxMembersApiService wxMembersApiService;
    @Autowired
    private ActivityPayServiceRpc activityPayServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    private static final String PLACE_ORDER = "https://api.mch.weixin.qq.com/pay/unifiedorder";
    private static final String CHARSET = "UTF-8";
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private MbrRechargeServiceRpc mbrRechargeServiceRpc;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private WxConfig wxConfig;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    public Map<String, String> createRecharge(CreateRechargeVO vo, WxPayConfigPo configPo) {
        String amount = vo.getMoney();
        String billNumber = new SimpleDateFormat("yyyyMMddkkmmssS").format(new Date());
        String remark = StringUtils.isBlank((CharSequence)vo.getRemake()) ? "\u5145\u503c" : vo.getRemake();
        String notifyUrl = this.wxConfig.getBaseUrl() + "/wxPay/callback";
        Map map = this.createMp(vo.getGiveMoney(), vo.getOpenid(), vo.getAppId(), billNumber, amount, remark, notifyUrl, configPo, vo.getMemberCode(), vo.getActivityId());
        return map;
    }

    public String callback(HttpServletRequest req, HttpServletResponse res) {
        try {
            String content = IOUtils.toString((InputStream)req.getInputStream(), (String)CHARSET);
            logger.info("\u63a5\u6536\u5230\u5fae\u4fe1\u901a\u77e5,\u5185\u5bb9={}", (Object)content);
            String out_trade_no = this.read(content, "out_trade_no");
            String transaction_id = this.read(content, "transaction_id");
            String time_end = this.read(content, "time_end");
            String cash_fee = this.read(content, "cash_fee");
            String return_code = this.read(content, "return_code");
            String appid = this.read(content, "appid");
            String openid = this.read(content, "openid");
            String attachStr = this.read(content, "attach");
            String total_fee = this.read(content, "total_fee");
            logger.info("\u63a5\u6536\u5230\u5fae\u4fe1\u901a\u77e5,\u5185\u5bb9={}", (Object)attachStr);
            JSONObject attach = JSONObject.parseObject((String)attachStr);
            String giveMoney = "";
            String memberCode = "";
            String activityId = "";
            if (attach != null) {
                giveMoney = String.valueOf(attach.get((Object)"giveMoney"));
                memberCode = String.valueOf(attach.get((Object)"memberCode"));
                activityId = String.valueOf(attach.get((Object)"activityId"));
            }
            logger.info("attach\u89e3\u6790\u7ed3\u675f");
            String stringByKey = (String)this.redisTemplateService.stringGetStringByKey((Object)(appid + out_trade_no + transaction_id));
            int codeRedis = 0;
            codeRedis = StringUtils.isNotBlank((CharSequence)stringByKey) ? Integer.valueOf(stringByKey) : 1;
            logger.info("\u6267\u884c\u5145\u503c\u8bb0\u5f55 codeRedis ={}", (Object)codeRedis);
            int code = 0;
            if ("SUCCESS".equals(return_code) && codeRedis != 0) {
                List<String> ids;
                AppletWxPayBo payBo = new AppletWxPayBo();
                payBo.setAppId(appid);
                payBo.setOpenId(openid);
                payBo.setMemberCode(memberCode);
                AppletWxPayBo wxPayBo = this.readSockt(payBo);
                Long aLong = Long.valueOf(time_end);
                String format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(aLong);
                SimpleDateFormat parse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = parse.parse(format);
                logger.info("PaymentDate={}", (Object)date);
                AppletWxPayBo appletWxPayBo = new AppletWxPayBo();
                appletWxPayBo.setMemberCode(wxPayBo.getMemberCode());
                appletWxPayBo.setMoney(Double.valueOf(Double.valueOf(total_fee) / (double)this.wxConfig.getMoneyCode().intValue()));
                String testBrand = this.wxConfig.getTestBrand();
                if (StringUtils.isNotEmpty((CharSequence)testBrand) && (ids = Arrays.asList(testBrand.split(","))).contains(appid)) {
                    appletWxPayBo.setMoney(Double.valueOf(appletWxPayBo.getMoney() * 100.0));
                }
                appletWxPayBo.setPaymentDate(date);
                appletWxPayBo.setSysBrandId(wxPayBo.getSysBrandId());
                appletWxPayBo.setGiveMoney(Double.valueOf(giveMoney));
                appletWxPayBo.setWxPayVoucherNo(transaction_id);
                logger.info("\u6267\u884c\u50a8\u503c\u6d3b\u52a8 ");
                if (StringUtils.isNotEmpty((CharSequence)activityId)) {
                    MemberInfoModel memberInfoModel = new MemberInfoModel();
                    memberInfoModel.setMemberCode(memberCode);
                    ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
                    MemberInfoModel member = (MemberInfoModel)singleMemberModel.getData();
                    MemberInfoModelVOActivity memberInfoVO = new MemberInfoModelVOActivity();
                    memberInfoVO.setMemberCode(memberCode);
                    memberInfoVO.setPayId(Integer.valueOf(activityId));
                    memberInfoVO.setLevelId(member.getLevelId());
                    BeanUtils.copyProperties((Object)member, (Object)memberInfoVO);
                    logger.info("\u8c03\u7528\u6267\u884c\u50a8\u503c\u6d3b\u52a8\u53c2\u6570={}", (Object)JSON.toJSONString((Object)memberInfoVO));
                    ResponseData result = this.activityPayServiceRpc.excuseActivityPay(memberInfoVO);
                    logger.info("\u8c03\u7528\u6267\u884c\u50a8\u503c\u6d3b\u52a8\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)result));
                }
                this.redisTemplateService.stringSetValueAndExpireTime((Object)(appid + out_trade_no + transaction_id), (Object)String.valueOf(code), 86400000L);
                this.addMbrRechargeRecord(appletWxPayBo);
            }
            logger.info("\u4e1a\u52a1\u8ba2\u5355={}, \u5fae\u4fe1\u8ba2\u5355={}, \u65f6\u95f4\u663e\u793a={}, \u652f\u4ed8\u91d1\u989d={} ,\u5145\u503c\u8bb0\u5f55 Code={},\u5145\u503c\u662f\u5426\u6210\u529f={},\u8d60\u9001\u91d1\u989d{}", new Object[]{out_trade_no, transaction_id, time_end, cash_fee, code, return_code, attach});
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn("\u5904\u7406\u5931\u8d25,\u5931\u8d25\u4fe1\u606f={}", (Object)e.getMessage());
            logger.debug("{}", (Throwable)e);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<xml>").append("<return_code><![CDATA[SUCCESS]]></return_code>").append("<return_msg><![CDATA[OK]]></return_msg>").append("</xml>");
        return buffer.toString();
    }

    private Map<String, String> createMp(String giveMoney, String openid, String appId, String billNumber, String amount, String remark, String notifyUrl, WxPayConfigPo configPo, String memberCode, String activityId) {
        List<String> ids;
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("appid", appId);
        paramMap.put("mch_id", configPo.getMerchantNumber());
        paramMap.put("nonce_str", UUID.randomUUID().toString().replaceAll("[-]", ""));
        paramMap.put("out_trade_no", billNumber);
        paramMap.put("body", remark);
        paramMap.put("total_fee", this.getCentAmount(amount));
        String testBrand = this.wxConfig.getTestBrand();
        if (StringUtils.isNotEmpty((CharSequence)testBrand) && (ids = Arrays.asList(testBrand.split(","))).contains(appId)) {
            paramMap.put("total_fee", this.getAmount(amount));
        }
        HashMap<String, String> attach = new HashMap<String, String>();
        attach.put("giveMoney", giveMoney);
        attach.put("memberCode", memberCode);
        attach.put("activityId", activityId);
        paramMap.put("attach", JSON.toJSONString(attach));
        paramMap.put("notify_url", notifyUrl);
        paramMap.put("trade_type", "JSAPI");
        paramMap.put("openid", openid);
        paramMap.put("spbill_create_ip", this.wxConfig.getServiceUrl());
        logger.info("paramMap={}", (Object)JSON.toJSONString(paramMap));
        String requestXml = this.getRequstXml(paramMap, configPo.getSecretKey());
        logger.info("requestXml={}", (Object)JSON.toJSONString((Object)requestXml));
        WxpayCreateMpVO vo = this.invoke(requestXml);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", appId);
        map.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        map.put("nonceStr", UUID.randomUUID().toString().replaceAll("[-]", ""));
        map.put("package", "prepay_id=" + vo.getPrepay_id());
        map.put("signType", "MD5");
        StringBuilder buffer = new StringBuilder();
        buffer.append("appId=").append((String)map.get("appId"));
        buffer.append("&nonceStr=").append((String)map.get("nonceStr"));
        buffer.append("&package=").append((String)map.get("package"));
        buffer.append("&signType=").append((String)map.get("signType"));
        buffer.append("&timeStamp=").append((String)map.get("timeStamp"));
        map.put("paySign", this.getSign(buffer.toString(), configPo.getSecretKey()));
        return map;
    }

    private WxpayCreateMpVO invoke(String requestXml) {
        try {
            String outStr = HttpUtil.post((String)PLACE_ORDER, (String)requestXml);
            String result = this.getResponseData(outStr);
            logger.info("outStr={}", (Object)JSON.toJSONString((Object)outStr));
            logger.info("result={}", (Object)JSON.toJSONString((Object)result));
            WxpayCreateMpVO obj = (WxpayCreateMpVO)JSON.parseObject((String)result, WxpayCreateMpVO.class);
            return obj;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getResponseData(String outStr) {
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(IOUtils.toInputStream((String)outStr, (String)CHARSET));
            Element root = document.getRootElement();
            List list = root.elements();
            HashMap<String, String> dataMap = new HashMap<String, String>();
            for (Element element : list) {
                String name = element.getName();
                String value = element.getText();
                dataMap.put(name, value);
            }
            return JSON.toJSONString(dataMap);
        }
        catch (Exception e) {
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790\u5fae\u4fe1\u8fd4\u56de\u62a5\u6587,\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458");
        }
    }

    private String getRequstXml(Map<String, Object> paramMap, String key) {
        String tab = "\t";
        String line = "\n";
        String cdataStart = "<![CDATA[";
        String cdataEnd = "]]>";
        StringBuffer buffer = new StringBuffer("<xml>");
        StringBuffer stringA = new StringBuffer();
        Set<Map.Entry<String, Object>> set = paramMap.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (null == value || "".equals(value)) continue;
            buffer.append(tab).append("<").append(name).append(">").append(cdataStart).append(value).append(cdataEnd).append("</").append(name).append(">").append(line);
            stringA.append(name).append("=").append(value).append("&");
        }
        stringA.deleteCharAt(stringA.lastIndexOf("&"));
        String sign = this.getSign(stringA.toString(), key);
        buffer.append(tab).append("<sign>").append(sign).append("</sign>").append(line);
        buffer.append("</xml>");
        return buffer.toString();
    }

    private String getSign(String data, String key) {
        String stringSignTemp = data + "&key=" + key;
        return DigestUtils.md5Hex((String)stringSignTemp).toUpperCase();
    }

    private String getCentAmount(String amount) {
        Integer integer = Integer.valueOf(amount);
        integer = integer * this.wxConfig.getMoneyCode();
        logger.info("integer={}", (Object)integer);
        String valueOf = String.valueOf(integer);
        logger.info("amount={}", (Object)valueOf);
        return valueOf;
    }

    private String getAmount(String amount) {
        Integer integer = Integer.valueOf(amount);
        integer = integer * 1;
        logger.info("integer={}", (Object)integer);
        String valueOf = String.valueOf(integer);
        logger.info("amount={}", (Object)valueOf);
        return valueOf;
    }

    private ResponseData addMbrRechargeRecord(AppletWxPayBo appletWxPayBo) {
        ResponseData memberInfoModelResponseData = this.memberCardProgramApiService.queryMemberIntegral(appletWxPayBo.getMemberCode());
        MemberInfoModel data = (MemberInfoModel)memberInfoModelResponseData.getData();
        MbrRechargeRecordPo mbrRechargeRecordPo = new MbrRechargeRecordPo();
        mbrRechargeRecordPo.setSysBrandId(appletWxPayBo.getSysBrandId());
        mbrRechargeRecordPo.setCardNo(data.getCardNo());
        mbrRechargeRecordPo.setName(data.getName());
        mbrRechargeRecordPo.setRechargeMoney(appletWxPayBo.getMoney());
        mbrRechargeRecordPo.setState(Long.valueOf(0L));
        mbrRechargeRecordPo.setGiveMoney((Double)ObjectUtils.defaultIfNull((Object)appletWxPayBo.getGiveMoney(), (Object)0.0));
        mbrRechargeRecordPo.setWxPayVoucherNo(appletWxPayBo.getWxPayVoucherNo());
        logger.info("\u5165\u53c2========mbrRechargeRecordBo========" + JSON.toJSONString((Object)mbrRechargeRecordPo));
        ResponseData responseData = this.mbrRechargeServiceRpc.addMbrRechargeRecord(mbrRechargeRecordPo);
        logger.info("addMbrRechargeRecord={}", (Object)JSON.toJSONString((Object)responseData));
        return responseData;
    }

    private String read(String content, String key) {
        String startStr = "<" + key + ">";
        String endStr = "</" + key + ">";
        int start = content.indexOf(startStr);
        int end = content.indexOf(endStr);
        if (start == -1 || end == -1) {
            return null;
        }
        if (start >= end) {
            return null;
        }
        String data = content.substring(start + startStr.length(), end);
        if (StringUtils.startsWith((CharSequence)data, (CharSequence)"<![CDATA[") && StringUtils.endsWith((CharSequence)data, (CharSequence)"]]>")) {
            return data.substring("<![CDATA[".length(), data.length() - "]]>".length());
        }
        return data;
    }

    private AppletWxPayBo readSockt(AppletWxPayBo wxPayBo) {
        AppletWxPayBo appletWxPayBo = new AppletWxPayBo();
        String appId = wxPayBo.getAppId();
        String openId = wxPayBo.getOpenId();
        ResponseData wxPublicPOByAppId = this.wxPublicServiceFeign.getWxPublicPOByAppId(appId);
        MemberFriendsKeyQueryVo memberFriendsKeyQueryVo = new MemberFriendsKeyQueryVo();
        memberFriendsKeyQueryVo.setMemberCode(wxPayBo.getMemberCode());
        ResponseData withMultiKeyWord = this.wxMembersApiService.getMemberFriendsWithMultiKeyWord(memberFriendsKeyQueryVo);
        if (StringUtils.isNotBlank((CharSequence)((MemberInfoModel)withMultiKeyWord.getData()).getMemberCode())) {
            appletWxPayBo.setSysBrandId(((WxPublicPO)wxPublicPOByAppId.getData()).getSysBrandId());
            appletWxPayBo.setMemberCode(((MemberInfoModel)withMultiKeyWord.getData()).getMemberCode());
        }
        return appletWxPayBo;
    }
}

