/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.common.HttpUtil;
import com.bizvane.appletservice.interfaces.IntegrationShopService;
import com.bizvane.appletservice.models.bo.MktConvertCouponRecordBo;
import com.bizvane.appletservice.models.vo.AllMerchandiseVo;
import com.bizvane.appletservice.models.vo.ChildsVo;
import com.bizvane.appletservice.models.vo.ConfirmGoodsVo;
import com.bizvane.appletservice.models.vo.GoodSkuSpecDetailsVo;
import com.bizvane.appletservice.models.vo.MainSpecVo;
import com.bizvane.appletservice.models.vo.OrderVo;
import com.bizvane.appletservice.models.vo.RefundLogisticsVo;
import com.bizvane.appletservice.models.vo.ReturnGoodsVo;
import com.bizvane.appletservice.models.vo.RotationChartVo;
import com.bizvane.appletservice.models.vo.ShopClassifyMapVo;
import com.bizvane.appletservice.models.vo.ShopHomePageVo;
import com.bizvane.appletservice.models.vo.ShopStoreSkuVo;
import com.bizvane.appletservice.models.vo.ShopStoreVo;
import com.bizvane.appletservice.models.vo.ShopVo;
import com.bizvane.appletservice.models.vo.UserAddressPutVo;
import com.bizvane.appletservice.models.vo.classifiedGoodsVo;
import com.bizvane.appletservice.models.vo.refundOrderVo;
import com.bizvane.appletserviceimpl.utils.LogicException;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.UUIDUtils;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.couponfacade.interfaces.CouponDefinitionServiceFeign;
import com.bizvane.couponfacade.interfaces.CouponQueryServiceFeign;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.WxChannelInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.vo.WxChannelRelationVo;
import com.bizvane.mktcenterservice.models.po.MktConvertCouponRecordPO;
import com.bizvane.mktcenterservice.models.vo.CouponRecordVO;
import com.bizvane.mktcenterservice.rpc.TaskServiceForWXRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatenterprise.service.entity.vo.StoreOrderInformVO;
import com.bizvane.wechatenterprise.service.rpc.InForMationServiceRpc;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
@RefreshScope
public class IntegrationShopServiceImpl
implements IntegrationShopService {
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private TaskServiceForWXRpc taskServiceForWXRpc;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private CouponQueryServiceFeign couponQueryServiceFeign;
    @Autowired
    private InForMationServiceRpc inForMationServiceRpc;
    @Autowired
    private CouponDefinitionServiceFeign couponDefinitionServiceFeign;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    private DecimalFormat df = new DecimalFormat("###,###.00");
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    @Value(value="${wxStore.baseUrl}")
    private String DOMAINNAME;
    private static final String ROTATIONCHART = "api/wx/homePage/getHomePage/";
    private static final String CLASSIFICATION = "api/wx/classify/getClassifyMap/";
    private static final String HOTCOMMODITY = "api/wx/goods/getHotGoods/";
    private static final String ALLMERCHANDISE = "api/wx/goods/getAllGoods?";
    private static final String COMMODITYDETAILS = "api/wx/goods/getGoodsDetail/";
    private static final String TAILCLASSIFIEDGOODS = "api/wx/goods/getGoodsByClassifyId?";
    private static final String INVENTORYSTATUS = "api/wx/goods/getSkuStock?skuId=";
    private static final String ORDERDETAILS = "api/wx/orders/getOrderById/";
    private static final String LOGISTICLIST = "api/logistics/companyList";
    private static final String DISPLAYLOGISTICS = "api/logistics/queryLogisticInfo?companyCode=";
    private static final String USERADDRESS = "api/integral/userAddress?userId=";
    private static final String ORDERLIST = "api/wx/orders/getOrderListByStatus/";
    private static final String INSTRUCTIONNS = "api/wx/refundOrder/getRejectedExplain?merchantId=";
    private static final String APPLICATIONSUBMISSION = "api/wx/refundOrder/submitReturnGoods";
    private static final String APPLICATIONSUBMISSIONWULIU = "api/wx/refundOrder/submitRefundLogistics";
    private static final String GENERATEORDEER = "api/wx/orders/confirmGoods";
    private static final String ADDUSERADDRESS = "api/integral/userAddress";
    private static final String PUTUSERADDRESS = "api/integral/userAddress";
    private static final String DELETESERADDRESS = "api/integral/userAddress";
    private static final String INTEGRALACQUISITIOON = "api/integral/gain/";
    private static final String GET_CONFIG = "api/integral/config/getConfig";
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ResponseData shopHomePage(String sysBrandId, String memberCode) {
        ResponseData responseData = new ResponseData();
        try {
            String rotationChart = HttpUtil.get((String)(this.DOMAINNAME + ROTATIONCHART + sysBrandId));
            String classification = HttpUtil.get((String)(this.DOMAINNAME + CLASSIFICATION + sysBrandId));
            String hotCommodity = HttpUtil.get((String)(this.DOMAINNAME + HOTCOMMODITY + sysBrandId));
            logger.info("rotationChart={}", (Object)JSON.toJSONString((Object)rotationChart));
            logger.info("classification={}", (Object)JSON.toJSONString((Object)classification));
            logger.info("hotCommodity={}", (Object)JSON.toJSONString((Object)hotCommodity));
            ShopHomePageVo shopHomePageVo = new ShopHomePageVo();
            HashMap<String, String> stringMap = new HashMap<String, String>();
            HashMap<String, String> attrMap = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)classification)) {
                JSONObject jsonClassification = JSON.parseObject((String)classification);
                JSONArray classifyList = jsonClassification.getJSONArray("ClassifyList");
                ArrayList<ShopClassifyMapVo> classify = new ArrayList<ShopClassifyMapVo>();
                for (int i = 0; i < classifyList.size(); ++i) {
                    ShopClassifyMapVo shopClassifyMapVo = new ShopClassifyMapVo();
                    JSONObject jsonObject = classifyList.getJSONObject(i);
                    String classifyHome = jsonObject.getString("classifyHome");
                    String classifyImg = jsonObject.getString("classifyImg");
                    String classifyIcon = jsonObject.getString("classifyIcon");
                    String className = jsonObject.getString("name");
                    String sort = jsonObject.getString("sort");
                    String classifyNo = jsonObject.getString("classifyNo");
                    String classifyListID = jsonObject.getString("id");
                    String classifyAttribute = jsonObject.getString("classifyAttribute");
                    stringMap.put(classifyListID, classifyImg);
                    shopClassifyMapVo.setClassID(classifyListID);
                    shopClassifyMapVo.setClassifyNo(classifyNo);
                    shopClassifyMapVo.setClassifyIcon(this.qiNiuConfig.getDomain() + classifyIcon);
                    shopClassifyMapVo.setClassifyImg(this.qiNiuConfig.getDomain() + classifyImg);
                    shopClassifyMapVo.setClassifyHome(this.qiNiuConfig.getDomain() + classifyHome);
                    shopClassifyMapVo.setClassifyName(className);
                    shopClassifyMapVo.setSort(sort);
                    shopClassifyMapVo.setClassifyAttribute(classifyAttribute);
                    classify.add(shopClassifyMapVo);
                    attrMap.put(classifyListID, classifyAttribute);
                }
                shopHomePageVo.setClassification(classify);
            } else {
                shopHomePageVo.setClassification(null);
            }
            if (StringUtils.isNotBlank((CharSequence)rotationChart)) {
                JSONObject jsonRotationChart = JSON.parseObject((String)rotationChart);
                String chartString = jsonRotationChart.getString("imgInfo");
                if (StringUtils.isBlank((CharSequence)chartString)) {
                    shopHomePageVo.setRotationChart(null);
                } else {
                    JSONArray imgInfo = jsonRotationChart.getJSONArray("imgInfo");
                    String imgInterval = jsonRotationChart.getString("imgInterval");
                    shopHomePageVo.setImgInterval(imgInterval);
                    ArrayList<RotationChartVo> rotationChartVos = new ArrayList<RotationChartVo>();
                    for (int i = 0; i < imgInfo.size(); ++i) {
                        RotationChartVo rotationChartVo = new RotationChartVo();
                        JSONObject jsonObject = imgInfo.getJSONObject(i);
                        String imgUrl = jsonObject.getString("imgUrl");
                        String classifyId = jsonObject.getString("classifyId");
                        String classifyImg = (String)stringMap.get(classifyId);
                        rotationChartVo.setClassifyAttribute((String)attrMap.get(classifyId));
                        rotationChartVo.setClassifyImg(this.qiNiuConfig.getDomain() + classifyImg);
                        rotationChartVo.setClassifyId(classifyId);
                        rotationChartVo.setImgUrl(this.qiNiuConfig.getDomain() + imgUrl);
                        rotationChartVos.add(rotationChartVo);
                        logger.info("i={},imgUrl={}", (Object)i, (Object)JSON.toJSONString((Object)hotCommodity));
                    }
                    shopHomePageVo.setRotationChart(rotationChartVos);
                }
            } else {
                shopHomePageVo.setRotationChart(null);
            }
            ArrayList<ShopStoreVo> shopStoreVos = new ArrayList<ShopStoreVo>();
            if (StringUtils.isNotBlank((CharSequence)hotCommodity)) {
                JSONArray jsonHotCommodity = JSON.parseArray((String)hotCommodity);
                for (int i = 0; i < jsonHotCommodity.size(); ++i) {
                    ShopStoreVo shopStoreVo = new ShopStoreVo();
                    JSONObject jsonObject = jsonHotCommodity.getJSONObject(i);
                    String id = jsonObject.getString("id");
                    String goodsNo = jsonObject.getString("goodsNo");
                    String goodsName = jsonObject.getString("goodsName");
                    String coverImg = jsonObject.getString("coverImg");
                    String price = jsonObject.getString("price");
                    shopStoreVo.setShopId(id);
                    shopStoreVo.setGoodsNo(goodsNo);
                    shopStoreVo.setGoodsName(goodsName);
                    shopStoreVo.setCoverImg(this.qiNiuConfig.getDomain() + coverImg);
                    shopStoreVo.setPrice(price);
                    shopStoreVos.add(shopStoreVo);
                }
                shopHomePageVo.setPopular(shopStoreVos);
            } else {
                shopHomePageVo.setPopular(null);
            }
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(memberCode);
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            MemberInfoModel memberModelData = (MemberInfoModel)singleMemberModel.getData();
            String name = memberModelData.getName();
            Integer countIntegral = memberModelData.getCountIntegral();
            logger.info("countIntegral={}", (Object)countIntegral);
            logger.info("countIntegral={}", (Object)countIntegral);
            WxChannelRelationVo wxChannelRelationVo = new WxChannelRelationVo();
            wxChannelRelationVo.setBrandId(Long.valueOf(sysBrandId));
            wxChannelRelationVo.setMemberCode(memberCode);
            ResponseData wxChannelInfoRelation = this.wxChannelInfoApiService.getWxChannelInfoRelation(wxChannelRelationVo);
            String wxNick = ((WxChannelInfoModel)wxChannelInfoRelation.getData()).getWxNick();
            String headPortraits = ((WxChannelInfoModel)wxChannelInfoRelation.getData()).getHeadPortraits();
            shopHomePageVo.setMemberCode(memberCode);
            shopHomePageVo.setMemberName(name);
            shopHomePageVo.setInterGerge(String.valueOf(countIntegral));
            shopHomePageVo.setWxNick(wxNick);
            shopHomePageVo.setWeChatHead(this.qiNiuConfig.getDomain() + headPortraits);
            responseData.setData((Object)shopHomePageVo);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        catch (Exception e) {
            logger.info("Exception={}", (Object)JSON.toJSONString((Object)e.getMessage()));
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData fullMerchandiseDisplay(AllMerchandiseVo allMerchandiseVo) {
        ResponseData responseData = new ResponseData();
        try {
            ArrayList<ShopStoreVo> storeVos = new ArrayList<ShopStoreVo>();
            String allMerchandise = HttpUtil.get((String)(this.DOMAINNAME + ALLMERCHANDISE + "merchantId=" + allMerchandiseVo.getSysBrandId() + "&sortType=" + allMerchandiseVo.getSortType() + "&orderBy=" + allMerchandiseVo.getOrderByAsc()));
            logger.info("allMerchandise={}", (Object)JSON.toJSONString((Object)allMerchandise));
            if (StringUtils.isNotBlank((CharSequence)allMerchandise)) {
                JSONArray merchandise = JSON.parseArray((String)allMerchandise);
                for (int i = 0; i < merchandise.size(); ++i) {
                    JSONObject jsonObject = merchandise.getJSONObject(i);
                    String goodsNo = jsonObject.getString("goodsNo");
                    String goodsName = jsonObject.getString("goodsName");
                    String coverImg = jsonObject.getString("coverImg");
                    String price = jsonObject.getString("price");
                    String upperShelfTime = jsonObject.getString("upperShelfTime");
                    String id = jsonObject.getString("id");
                    String actualSales = jsonObject.getString("actualSales");
                    ShopStoreVo shopStoreVo = new ShopStoreVo();
                    shopStoreVo.setShopId(id);
                    shopStoreVo.setGoodsNo(goodsNo);
                    shopStoreVo.setGoodsName(goodsName);
                    shopStoreVo.setCoverImg(this.qiNiuConfig.getDomain() + coverImg);
                    shopStoreVo.setPrice(price);
                    shopStoreVo.setUpperShelfTime(upperShelfTime);
                    shopStoreVo.setActualSales(actualSales);
                    storeVos.add(shopStoreVo);
                }
            } else {
                storeVos.add(null);
            }
            responseData.setData(storeVos);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        catch (Exception e) {
            logger.info("fullMerchandiseDisplay={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData commodityDetails(String hostID) {
        ResponseData responseData = new ResponseData();
        try {
            ShopStoreVo shopStoreVo = new ShopStoreVo();
            ShopVo shopVo = new ShopVo();
            String commodityDetails = HttpUtil.get((String)(this.DOMAINNAME + COMMODITYDETAILS + hostID));
            logger.info("commodityDetails={}", (Object)JSON.toJSONString((Object)commodityDetails));
            if (StringUtils.isNotBlank((CharSequence)commodityDetails)) {
                JSONObject commodityDetailsJson = JSON.parseObject((String)commodityDetails);
                String id = commodityDetailsJson.getString("id");
                String goodsNo = commodityDetailsJson.getString("goodsNo");
                String goodsName = commodityDetailsJson.getString("goodsName");
                String shelf = commodityDetailsJson.getString("shelf");
                String classifyId = commodityDetailsJson.getString("classifyId");
                String coverImg = commodityDetailsJson.getString("coverImg");
                String bannerImgPaths = commodityDetailsJson.getString("bannerImgPaths");
                String hot = commodityDetailsJson.getString("hot");
                String price = commodityDetailsJson.getString("price");
                String upperShelfTime = commodityDetailsJson.getString("upperShelfTime");
                String restrictedNum = commodityDetailsJson.getString("restrictedNum");
                String actualSales = commodityDetailsJson.getString("actualSales");
                String distributionMode = commodityDetailsJson.getString("distributionMode");
                String exchangeInstructions = commodityDetailsJson.getString("exchangeInstructions");
                String goodsDetails = commodityDetailsJson.getString("goodsDetails");
                shopStoreVo.setShopId(id);
                shopStoreVo.setGoodsNo(goodsNo);
                shopStoreVo.setGoodsName(goodsName);
                shopStoreVo.setShelf(shelf);
                shopStoreVo.setClassifyId(classifyId);
                shopStoreVo.setCoverImg(this.qiNiuConfig.getDomain() + coverImg);
                String[] split = bannerImgPaths.split(",");
                ArrayList<String> stringList = new ArrayList<String>();
                for (String splits : split) {
                    String splitsDome = this.qiNiuConfig.getDomain() + splits;
                    stringList.add(splitsDome);
                }
                shopStoreVo.setBannerImgPaths(stringList);
                shopStoreVo.setHot(hot);
                shopStoreVo.setPrice(price);
                shopStoreVo.setUpperShelfTime(upperShelfTime);
                shopStoreVo.setRestrictedNum(restrictedNum);
                shopStoreVo.setActualSales(actualSales);
                shopStoreVo.setDistributionMode(distributionMode);
                shopStoreVo.setExchangeInstructions(exchangeInstructions);
                shopStoreVo.setGoodsDetails(goodsDetails);
                String jsonString = commodityDetailsJson.getString("skus");
                if (StringUtils.isNotBlank((CharSequence)jsonString)) {
                    JSONArray skus = commodityDetailsJson.getJSONArray("skus");
                    ArrayList<ShopStoreSkuVo> shopStoreSkuVos = new ArrayList<ShopStoreSkuVo>();
                    ArrayList<ShopStoreSkuVo> shopSkuVo = new ArrayList<ShopStoreSkuVo>();
                    ArrayList<MainSpecVo> shopMainSpecVo = new ArrayList<MainSpecVo>();
                    ArrayList<ChildsVo> shopChildsVoList = new ArrayList<ChildsVo>();
                    for (int i = 0; i < skus.size(); ++i) {
                        ShopStoreSkuVo shopStoreSkuVo = new ShopStoreSkuVo();
                        ShopStoreSkuVo storeSkuVo = new ShopStoreSkuVo();
                        JSONObject skusJSONObject = skus.getJSONObject(i);
                        String skuId = skusJSONObject.getString("id");
                        String goodsId = skusJSONObject.getString("goodsId");
                        String specNames = skusJSONObject.getString("specNames");
                        String specIds = skusJSONObject.getString("specIds");
                        String skuNo = skusJSONObject.getString("skuNo");
                        String skuImg = skusJSONObject.getString("skuImg");
                        String price1 = skusJSONObject.getString("price");
                        String stock = skusJSONObject.getString("stock");
                        String enabled = skusJSONObject.getString("enabled");
                        shopStoreSkuVo.setSkuId(skuId);
                        shopStoreSkuVo.setGoodsId(goodsId);
                        shopStoreSkuVo.setSpecNames(specNames);
                        shopStoreSkuVo.setSpecIds(specIds);
                        shopStoreSkuVo.setSkuNo(skuNo);
                        shopStoreSkuVo.setSkuImg(this.qiNiuConfig.getDomain() + skuImg);
                        shopStoreSkuVo.setSkuPrice(price1);
                        shopStoreSkuVo.setStock(stock);
                        shopStoreSkuVo.setEnabled(enabled);
                        storeSkuVo.setSkuId(skuId);
                        storeSkuVo.setSpecNames(specNames);
                        storeSkuVo.setSkuImg(skuImg);
                        shopSkuVo.add(storeSkuVo);
                        JSONArray goodSkuSpecDetails = skusJSONObject.getJSONArray("goodSkuSpecDetails");
                        ArrayList<GoodSkuSpecDetailsVo> detailsVoList = new ArrayList<GoodSkuSpecDetailsVo>();
                        for (int k = 0; k < goodSkuSpecDetails.size(); ++k) {
                            String uuid = UUIDUtils.getUUID();
                            GoodSkuSpecDetailsVo goodSkuSpecDetailsVo = new GoodSkuSpecDetailsVo();
                            MainSpecVo mainSpecVo = new MainSpecVo();
                            JSONObject detailsJSONObject = goodSkuSpecDetails.getJSONObject(k);
                            JSONObject mainSpec = detailsJSONObject.getJSONObject("mainSpec");
                            String id2 = mainSpec.getString("id");
                            String pid = mainSpec.getString("pid");
                            String specName = mainSpec.getString("specName");
                            mainSpecVo.setMainSpecName(specName);
                            mainSpecVo.setMainSpecPid(pid);
                            mainSpecVo.setMainSpecId(id2);
                            shopMainSpecVo.add(mainSpecVo);
                            mainSpecVo.setGoodSkuSpecDetailsID(uuid);
                            mainSpecVo.setSkuId(skuId);
                            goodSkuSpecDetailsVo.setSkuId(skuId);
                            goodSkuSpecDetailsVo.setMainSpecVo(mainSpecVo);
                            goodSkuSpecDetailsVo.setGoodSkuSpecDetailsID(uuid);
                            JSONArray childs = detailsJSONObject.getJSONArray("childs");
                            ArrayList<ChildsVo> childsVoList = new ArrayList<ChildsVo>();
                            for (int o = 0; o < childs.size(); ++o) {
                                ChildsVo childsVo = new ChildsVo();
                                JSONObject jsonObject = childs.getJSONObject(o);
                                childsVo.setChildsId(jsonObject.getString("id"));
                                childsVo.setChildsSpecPid(jsonObject.getString("pid"));
                                childsVo.setChildsSpecName(jsonObject.getString("specName"));
                                shopChildsVoList.add(childsVo);
                                childsVo.setGoodSkuSpecDetailsID(uuid);
                                childsVo.setSkuId(skuId);
                                childsVoList.add(childsVo);
                            }
                            goodSkuSpecDetailsVo.setChildsVoList(childsVoList);
                            detailsVoList.add(goodSkuSpecDetailsVo);
                        }
                        shopStoreSkuVo.setGoodSkuSpecDetails(detailsVoList);
                        shopStoreSkuVos.add(shopStoreSkuVo);
                    }
                    shopStoreVo.setShopStoreSkuVos(shopStoreSkuVos);
                    shopVo.setShopSkuVo(shopSkuVo);
                    shopVo.setShopMainSpecVo(shopMainSpecVo);
                    shopVo.setShopChildsVoList(shopChildsVoList);
                    shopStoreVo.setShopVo(shopVo);
                } else {
                    shopStoreVo.setShopStoreSkuVos(null);
                }
                String classify = commodityDetailsJson.getString("classifyList");
                if (StringUtils.isNotBlank((CharSequence)classify)) {
                    JSONArray classifyList = commodityDetailsJson.getJSONArray("classifyList");
                    ArrayList<ShopClassifyMapVo> shopClassifyMapVos = new ArrayList<ShopClassifyMapVo>();
                    for (int i = 0; i < classifyList.size(); ++i) {
                        JSONObject classifyListJSONObject = classifyList.getJSONObject(i);
                        ShopClassifyMapVo shopClassifyMapVo = new ShopClassifyMapVo();
                        String id1 = classifyListJSONObject.getString("id");
                        String merchantId = classifyListJSONObject.getString("merchantId");
                        String name = classifyListJSONObject.getString("name");
                        String classifyNo = classifyListJSONObject.getString("classifyNo");
                        String sort = classifyListJSONObject.getString("sort");
                        String classifyDescribe = classifyListJSONObject.getString("classifyDescribe");
                        String classifyImg = classifyListJSONObject.getString("classifyImg");
                        String classifyHome = classifyListJSONObject.getString("classifyHome");
                        String classifyIcon = classifyListJSONObject.getString("classifyIcon");
                        shopClassifyMapVo.setClassID(id1);
                        shopClassifyMapVo.setClassID(merchantId);
                        shopClassifyMapVo.setClassID(name);
                        shopClassifyMapVo.setClassID(classifyNo);
                        shopClassifyMapVo.setClassID(classifyDescribe);
                        shopClassifyMapVo.setClassID(this.qiNiuConfig.getDomain() + classifyImg);
                        shopClassifyMapVo.setClassID(this.qiNiuConfig.getDomain() + classifyHome);
                        shopClassifyMapVo.setClassID(sort);
                        shopClassifyMapVo.setClassID(this.qiNiuConfig.getDomain() + classifyIcon);
                        shopClassifyMapVos.add(shopClassifyMapVo);
                    }
                    shopStoreVo.setClassifyMapVos(shopClassifyMapVos);
                } else {
                    shopStoreVo.setClassifyMapVos(null);
                }
                logger.info("commodityDetails={}", (Object)JSON.toJSONString((Object)shopStoreVo));
                responseData.setData((Object)shopStoreVo);
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
            responseData.setData((Object)commodityDetails);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        catch (Exception e) {
            logger.info("commodityDetails={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData classifiedGoods(classifiedGoodsVo classifiedGoodsVo2) {
        ResponseData responseData = new ResponseData();
        try {
            String classification = HttpUtil.get((String)(this.DOMAINNAME + CLASSIFICATION + classifiedGoodsVo2.getSysBrandId()));
            logger.info("classification={}", (Object)JSON.toJSONString((Object)classification));
            if (StringUtils.isNotBlank((CharSequence)classification)) {
                JSONObject classificationJson = JSON.parseObject((String)classification);
                ArrayList<ShopClassifyMapVo> list = new ArrayList<ShopClassifyMapVo>();
                JSONArray classifyList = classificationJson.getJSONArray("ClassifyList");
                for (int i = 0; i < classifyList.size(); ++i) {
                    ShopClassifyMapVo shopClassifyMapVo = new ShopClassifyMapVo();
                    JSONObject jsonObject = classifyList.getJSONObject(i);
                    String id = jsonObject.getString("id");
                    String name = jsonObject.getString("name");
                    String classifyNo = jsonObject.getString("classifyNo");
                    String sort = jsonObject.getString("sort");
                    String classifyDescribe = jsonObject.getString("classifyDescribe");
                    String classifyHome = jsonObject.getString("classifyHome");
                    String classifyImg = jsonObject.getString("classifyImg");
                    String classifyIcon = jsonObject.getString("classifyIcon");
                    String classifyAttribute = jsonObject.getString("classifyAttribute");
                    shopClassifyMapVo.setClassID(id);
                    shopClassifyMapVo.setClassifyName(name);
                    shopClassifyMapVo.setClassifyNo(classifyNo);
                    shopClassifyMapVo.setSort(sort);
                    shopClassifyMapVo.setClassifyDescribe(classifyDescribe);
                    shopClassifyMapVo.setClassifyHome(this.qiNiuConfig.getDomain() + classifyHome);
                    shopClassifyMapVo.setClassifyImg(this.qiNiuConfig.getDomain() + classifyImg);
                    shopClassifyMapVo.setClassifyIcon(this.qiNiuConfig.getDomain() + classifyIcon);
                    shopClassifyMapVo.setClassifyAttribute(classifyAttribute);
                    list.add(shopClassifyMapVo);
                }
                classifiedGoodsVo2.setClassifyList(list);
                responseData.setData((Object)classifiedGoodsVo2);
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
            responseData.setData((Object)classification);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        catch (Exception e) {
            logger.info("classifiedGoods={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData tailForClassifiedGoods(AllMerchandiseVo allMerchandiseVo) {
        ResponseData responseData = new ResponseData();
        try {
            String tailForClassifiedGoods = HttpUtil.get((String)(this.DOMAINNAME + TAILCLASSIFIEDGOODS + "classifyId=" + allMerchandiseVo.getClassifyId() + "&merchantId=" + allMerchandiseVo.getSysBrandId() + "&sortType=" + allMerchandiseVo.getSortType() + "&orderBy=" + allMerchandiseVo.getOrderByAsc()));
            logger.info("tailForClassifiedGoods={}", (Object)JSON.toJSONString((Object)tailForClassifiedGoods));
            if (StringUtils.isNotBlank((CharSequence)tailForClassifiedGoods)) {
                JSONArray objects = JSON.parseArray((String)tailForClassifiedGoods);
                ArrayList<ShopStoreVo> storeVos = new ArrayList<ShopStoreVo>();
                for (int i = 0; i < objects.size(); ++i) {
                    JSONObject jsonObject = objects.getJSONObject(i);
                    String goodsNo = jsonObject.getString("goodsNo");
                    String goodsName = jsonObject.getString("goodsName");
                    String coverImg = jsonObject.getString("coverImg");
                    String price = jsonObject.getString("price");
                    String upperShelfTime = jsonObject.getString("upperShelfTime");
                    String id = jsonObject.getString("id");
                    String actualSales = jsonObject.getString("actualSales");
                    ShopStoreVo shopStoreVo = new ShopStoreVo();
                    shopStoreVo.setShopId(id);
                    shopStoreVo.setGoodsNo(goodsNo);
                    shopStoreVo.setGoodsName(goodsName);
                    shopStoreVo.setCoverImg(this.qiNiuConfig.getDomain() + coverImg);
                    shopStoreVo.setPrice(price);
                    shopStoreVo.setUpperShelfTime(upperShelfTime);
                    shopStoreVo.setActualSales(actualSales);
                    storeVos.add(shopStoreVo);
                }
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                responseData.setData(storeVos);
                return responseData;
            }
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setData((Object)tailForClassifiedGoods);
            return responseData;
        }
        catch (Exception e) {
            logger.info("tailForClassifiedGoods={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData generateOrder(ConfirmGoodsVo confirmGoodsVo) {
        ResponseData responseData = new ResponseData();
        String memberCode = confirmGoodsVo.getMemberCode();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        String phone = ((MemberInfoModel)singleMemberModel.getData()).getPhone();
        String name = ((MemberInfoModel)singleMemberModel.getData()).getName();
        String cardNo = ((MemberInfoModel)singleMemberModel.getData()).getCardNo();
        Long brandId = ((MemberInfoModel)singleMemberModel.getData()).getBrandId();
        confirmGoodsVo.setMemberCode(memberCode);
        confirmGoodsVo.setMemberPhone(phone);
        confirmGoodsVo.setMemberName(name);
        confirmGoodsVo.setMemberCardNo(cardNo);
        confirmGoodsVo.setSysBrandId(String.valueOf(brandId));
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Content-Type", "application/json");
            HashMap<String, String> stringMap = new HashMap<String, String>();
            stringMap.put("merchantId", confirmGoodsVo.getSysBrandId());
            stringMap.put("memberCode", confirmGoodsVo.getMemberCode());
            stringMap.put("memberCardNo", confirmGoodsVo.getMemberCardNo());
            stringMap.put("memberName", confirmGoodsVo.getMemberName());
            stringMap.put("memberPhone", confirmGoodsVo.getMemberPhone());
            stringMap.put("goodId", confirmGoodsVo.getGoodId());
            stringMap.put("goodNo", confirmGoodsVo.getGoodNo());
            stringMap.put("shippingName", confirmGoodsVo.getShippingName());
            stringMap.put("shippingMobile", confirmGoodsVo.getShippingMobile());
            stringMap.put("shippingProvince", confirmGoodsVo.getShippingProvince());
            stringMap.put("shippingCity", confirmGoodsVo.getShippingCity());
            stringMap.put("shippingDistrict", confirmGoodsVo.getShippingDistrict());
            stringMap.put("shippingAddress", confirmGoodsVo.getShippingAddress());
            stringMap.put("userComments", confirmGoodsVo.getUserComments());
            stringMap.put("goodSkuNo", confirmGoodsVo.getGoodSkuNo());
            stringMap.put("goodSkuSpecNames", confirmGoodsVo.getGoodSkuSpecNames());
            stringMap.put("saleQuantity", confirmGoodsVo.getSaleQuantity());
            stringMap.put("orderType", confirmGoodsVo.getOrderType());
            String storeCode = "";
            if (StringUtils.isNotEmpty((CharSequence)confirmGoodsVo.getStoreId())) {
                ResponseData codeById = this.storeServiceRpc.getStoreCodeById(Long.valueOf(confirmGoodsVo.getStoreId()));
                storeCode = (String)codeById.getData();
            }
            stringMap.put("storeCode", storeCode);
            stringMap.put("storeName", confirmGoodsVo.getStoreName());
            stringMap.put("storeId", confirmGoodsVo.getStoreId());
            logger.info("generateOrder={}", (Object)JSON.toJSONString(stringMap));
            String generateOrder = HttpUtil.post((String)(this.DOMAINNAME + GENERATEORDEER), (String)JSON.toJSONString(stringMap), map);
            JSONObject jsonObject = JSON.parseObject((String)generateOrder);
            String code = jsonObject.getString("code");
            String msg = jsonObject.getString("msg");
            String orderNo = jsonObject.getString("data");
            logger.info("generateOrder={},msg={}", (Object)code, (Object)msg);
            if (code.equals("0")) {
                if (StringUtils.isNotEmpty((CharSequence)confirmGoodsVo.getStoreId())) {
                    StoreOrderInformVO soiVO = new StoreOrderInformVO();
                    soiVO.setMemberName(confirmGoodsVo.getMemberName());
                    soiVO.setMemberPhone(confirmGoodsVo.getMemberPhone());
                    soiVO.setOrderDate(this.sdf.format(new Date()));
                    soiVO.setOrderNo(orderNo);
                    soiVO.setStoreName(confirmGoodsVo.getStoreName());
                    soiVO.setSysBrandId(((MemberInfoModel)singleMemberModel.getData()).getBrandId());
                    soiVO.setSysCompanyId(((MemberInfoModel)singleMemberModel.getData()).getSysCompanyId());
                    soiVO.setSysStoreId(Long.valueOf(confirmGoodsVo.getStoreId()));
                    soiVO.setSysStoreOfflineCode(storeCode);
                    logger.info("memberInfoModel={}", (Object)((MemberInfoModel)singleMemberModel.getData()).getSysCompanyId());
                    logger.info("\u901a\u77e5\u4f01\u5fae\u63a5\u53e3\u5165\u53c2{}", (Object)JSON.toJSONString((Object)soiVO));
                    ResponseData inform = this.inForMationServiceRpc.storeOrderInform(soiVO);
                    logger.info("\u901a\u77e5\u7ed3\u679c\u8fd4\u56de{}", (Object)JSON.toJSONString((Object)inform));
                }
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                return responseData;
            }
            responseData.setMessage(msg);
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        catch (Exception e) {
            e.getStackTrace();
            logger.info("generateOrder={}", (Object)e.getMessage());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
    }

    public ResponseData inventoryStatus(ConfirmGoodsVo confirmGoodsVo) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)confirmGoodsVo.getGoodNo())) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u8bf7\u8f93\u5165\u5546\u54c1\u7f16\u53f7");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)confirmGoodsVo.getGoodSkuNo())) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u8bf7\u9009\u62e9\u89c4\u683c");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)confirmGoodsVo.getSaleQuantity())) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u8bf7\u8f93\u5165\u5151\u6362\u6570\u91cf");
            return responseData;
        }
        try {
            ShopStoreVo shopStoreVo = new ShopStoreVo();
            String commodityDetails = HttpUtil.get((String)(this.DOMAINNAME + COMMODITYDETAILS + confirmGoodsVo.getGoodId()));
            logger.info("commodityDetails={}", (Object)JSON.toJSONString((Object)commodityDetails));
            JSONObject commodityDetailsJson = JSON.parseObject((String)commodityDetails);
            String id = commodityDetailsJson.getString("id");
            String goodsNo = commodityDetailsJson.getString("goodsNo");
            String goodsName = commodityDetailsJson.getString("goodsName");
            String shelf = commodityDetailsJson.getString("shelf");
            String classifyId = commodityDetailsJson.getString("classifyId");
            String coverImg = commodityDetailsJson.getString("coverImg");
            String bannerImgPaths = commodityDetailsJson.getString("bannerImgPaths");
            String hot = commodityDetailsJson.getString("hot");
            String price = commodityDetailsJson.getString("price");
            String upperShelfTime = commodityDetailsJson.getString("upperShelfTime");
            String restrictedNum = commodityDetailsJson.getString("restrictedNum");
            String actualSales = commodityDetailsJson.getString("actualSales");
            String distributionMode = commodityDetailsJson.getString("distributionMode");
            String saleQuantity = confirmGoodsVo.getSaleQuantity();
            logger.info("saleQuantity={}", (Object)saleQuantity);
            logger.info("restrictedNum={}", (Object)restrictedNum);
            if (Integer.valueOf(saleQuantity) > Integer.valueOf(restrictedNum)) {
                responseData.setMessage("\u6bcf\u5355\u9650\u5151" + restrictedNum + "\u4ef6");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                return responseData;
            }
            shopStoreVo.setShopId(id);
            shopStoreVo.setGoodsNo(goodsNo);
            shopStoreVo.setGoodsName(goodsName);
            shopStoreVo.setShelf(shelf);
            shopStoreVo.setClassifyId(classifyId);
            shopStoreVo.setCoverImg(coverImg);
            String[] split = bannerImgPaths.split(",");
            ArrayList<String> stringList = new ArrayList<String>();
            for (String splits : split) {
                String splitsDome = this.qiNiuConfig.getDomain() + splits;
                stringList.add(splitsDome);
            }
            shopStoreVo.setBannerImgPaths(stringList);
            shopStoreVo.setHot(hot);
            shopStoreVo.setPrice(price);
            shopStoreVo.setUpperShelfTime(upperShelfTime);
            shopStoreVo.setRestrictedNum(restrictedNum);
            shopStoreVo.setActualSales(actualSales);
            shopStoreVo.setDistributionMode(distributionMode);
            String jsonString = commodityDetailsJson.getString("skus");
            if (StringUtils.isNotBlank((CharSequence)jsonString)) {
                JSONArray skus = commodityDetailsJson.getJSONArray("skus");
                ArrayList<ShopStoreSkuVo> shopStoreSkuVos = new ArrayList<ShopStoreSkuVo>();
                for (int i = 0; i < skus.size(); ++i) {
                    ShopStoreSkuVo shopStoreSkuVo = new ShopStoreSkuVo();
                    JSONObject skusJSONObject = skus.getJSONObject(i);
                    String skuId = skusJSONObject.getString("id");
                    String goodsId = skusJSONObject.getString("goodsId");
                    String specNames = skusJSONObject.getString("specNames");
                    String specIds = skusJSONObject.getString("specIds");
                    String skuNo = skusJSONObject.getString("skuNo");
                    String skuImg = skusJSONObject.getString("skuImg");
                    String price1 = skusJSONObject.getString("price");
                    String stock = skusJSONObject.getString("stock");
                    String enabled = skusJSONObject.getString("enabled");
                    String quantity = confirmGoodsVo.getSaleQuantity();
                    if (confirmGoodsVo.getGoodSkuId().equals(skuId) && Integer.valueOf(stock) < Integer.valueOf(quantity)) {
                        logger.info("stock={}", (Object)stock);
                        logger.info("quantity={}", (Object)quantity);
                        responseData.setMessage("\u5546\u54c1\u4ec5\u5269" + stock + "\u4ef6");
                        responseData.setCode(SysResponseEnum.FAILED.getCode());
                        return responseData;
                    }
                    shopStoreSkuVo.setSkuId(skuId);
                    shopStoreSkuVo.setGoodsId(goodsId);
                    shopStoreSkuVo.setSpecNames(specNames);
                    shopStoreSkuVo.setSpecIds(specIds);
                    shopStoreSkuVo.setSkuNo(skuNo);
                    shopStoreSkuVo.setSkuImg(skuImg);
                    shopStoreSkuVo.setSkuPrice(price1);
                    shopStoreSkuVo.setStock(stock);
                    shopStoreSkuVo.setEnabled(enabled);
                    JSONArray goodSkuSpecDetails = skusJSONObject.getJSONArray("goodSkuSpecDetails");
                    ArrayList<GoodSkuSpecDetailsVo> detailsVoList = new ArrayList<GoodSkuSpecDetailsVo>();
                    for (int k = 0; k < goodSkuSpecDetails.size(); ++k) {
                        String uuid = UUIDUtils.getUUID();
                        GoodSkuSpecDetailsVo goodSkuSpecDetailsVo = new GoodSkuSpecDetailsVo();
                        MainSpecVo mainSpecVo = new MainSpecVo();
                        JSONObject detailsJSONObject = goodSkuSpecDetails.getJSONObject(k);
                        JSONObject mainSpec = detailsJSONObject.getJSONObject("mainSpec");
                        String id2 = mainSpec.getString("id");
                        String pid = mainSpec.getString("pid");
                        String specName = mainSpec.getString("specName");
                        mainSpecVo.setMainSpecName(specName);
                        mainSpecVo.setMainSpecPid(pid);
                        mainSpecVo.setMainSpecId(id2);
                        mainSpecVo.setGoodSkuSpecDetailsID(uuid);
                        mainSpecVo.setSkuId(skuId);
                        goodSkuSpecDetailsVo.setSkuId(skuId);
                        goodSkuSpecDetailsVo.setMainSpecVo(mainSpecVo);
                        goodSkuSpecDetailsVo.setGoodSkuSpecDetailsID(uuid);
                        JSONArray childs = detailsJSONObject.getJSONArray("childs");
                        ArrayList<ChildsVo> childsVoList = new ArrayList<ChildsVo>();
                        for (int o = 0; o < childs.size(); ++o) {
                            ChildsVo childsVo = new ChildsVo();
                            JSONObject jsonObject = childs.getJSONObject(o);
                            childsVo.setChildsId(jsonObject.getString("id"));
                            childsVo.setChildsSpecPid(jsonObject.getString("pid"));
                            childsVo.setChildsSpecName(jsonObject.getString("specName"));
                            childsVo.setGoodSkuSpecDetailsID(uuid);
                            childsVo.setSkuId(skuId);
                            childsVoList.add(childsVo);
                        }
                        goodSkuSpecDetailsVo.setChildsVoList(childsVoList);
                        detailsVoList.add(goodSkuSpecDetailsVo);
                    }
                    shopStoreSkuVo.setGoodSkuSpecDetails(detailsVoList);
                    shopStoreSkuVos.add(shopStoreSkuVo);
                    shopStoreVo.setShopStoreSkuVos(shopStoreSkuVos);
                }
            } else {
                shopStoreVo.setShopStoreSkuVos(null);
            }
            String classify = commodityDetailsJson.getString("classifyList");
            if (StringUtils.isNotBlank((CharSequence)classify)) {
                JSONArray classifyList = commodityDetailsJson.getJSONArray("classifyList");
                ArrayList<ShopClassifyMapVo> shopClassifyMapVos = new ArrayList<ShopClassifyMapVo>();
                for (int i = 0; i < classifyList.size(); ++i) {
                    JSONObject classifyListJSONObject = classifyList.getJSONObject(i);
                    ShopClassifyMapVo shopClassifyMapVo = new ShopClassifyMapVo();
                    String id1 = classifyListJSONObject.getString("id");
                    String merchantId = classifyListJSONObject.getString("merchantId");
                    String name = classifyListJSONObject.getString("name");
                    String classifyNo = classifyListJSONObject.getString("classifyNo");
                    String sort = classifyListJSONObject.getString("sort");
                    String classifyDescribe = classifyListJSONObject.getString("classifyDescribe");
                    String classifyImg = classifyListJSONObject.getString("classifyImg");
                    String classifyHome = classifyListJSONObject.getString("classifyHome");
                    String classifyIcon = classifyListJSONObject.getString("classifyIcon");
                    shopClassifyMapVo.setClassID(id1);
                    shopClassifyMapVo.setClassID(merchantId);
                    shopClassifyMapVo.setClassID(name);
                    shopClassifyMapVo.setClassID(classifyNo);
                    shopClassifyMapVo.setClassID(classifyDescribe);
                    shopClassifyMapVo.setClassID(this.qiNiuConfig.getDomain() + classifyImg);
                    shopClassifyMapVo.setClassID(this.qiNiuConfig.getDomain() + classifyHome);
                    shopClassifyMapVo.setClassID(sort);
                    shopClassifyMapVo.setClassID(this.qiNiuConfig.getDomain() + classifyIcon);
                    shopClassifyMapVos.add(shopClassifyMapVo);
                }
                shopStoreVo.setClassifyMapVos(shopClassifyMapVos);
            } else {
                shopStoreVo.setClassifyMapVos(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData increaseReceivingAddress(UserAddressPutVo userAddressPutVo) {
        ResponseData responseData = new ResponseData();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(userAddressPutVo.getMemberCode());
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        Long mbrMemberId = ((MemberInfoModel)singleMemberModel.getData()).getMbrMemberId();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Content-Type", "application/json");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("address", (Object)userAddressPutVo.getAddress());
        jsonObject.put("city", (Object)userAddressPutVo.getCity());
        jsonObject.put("district", (Object)userAddressPutVo.getDistrict());
        jsonObject.put("isDefault", (Object)userAddressPutVo.getIsDefault());
        jsonObject.put("mobile", (Object)userAddressPutVo.getMobile());
        jsonObject.put("name", (Object)userAddressPutVo.getName());
        jsonObject.put("province", (Object)userAddressPutVo.getProvince());
        jsonObject.put("userId", (Object)mbrMemberId);
        logger.info("increaseReceivingAddress+userId={}", (Object)mbrMemberId);
        try {
            logger.info("increaseReceivingAddress={}", (Object)JSON.toJSONString((Object)jsonObject));
            String addUserAddress = HttpUtil.post((String)(this.DOMAINNAME + "api/integral/userAddress"), (String)jsonObject.toJSONString(), map);
            JSONObject jsonObject1 = JSON.parseObject((String)addUserAddress);
            String code = jsonObject1.getString("code");
            String msg = jsonObject1.getString("msg");
            if (code.equals("0")) {
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(msg);
            return responseData;
        }
        catch (Exception e) {
            logger.info("increaseReceivingAddress={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData editReceivingAddress(UserAddressPutVo userAddressPutVo) {
        ResponseData responseData = new ResponseData();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(userAddressPutVo.getMemberCode());
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        Long mbrMemberId = ((MemberInfoModel)singleMemberModel.getData()).getMbrMemberId();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Content-Type", "application/json");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("address", (Object)userAddressPutVo.getAddress());
        jsonObject.put("city", (Object)userAddressPutVo.getCity());
        jsonObject.put("district", (Object)userAddressPutVo.getDistrict());
        jsonObject.put("isDefault", (Object)userAddressPutVo.getIsDefault());
        jsonObject.put("mobile", (Object)userAddressPutVo.getMobile());
        jsonObject.put("name", (Object)userAddressPutVo.getName());
        jsonObject.put("province", (Object)userAddressPutVo.getProvince());
        jsonObject.put("userId", (Object)mbrMemberId);
        jsonObject.put("id", (Object)userAddressPutVo.getId());
        try {
            logger.info("editReceivingAddress={}", (Object)JSON.toJSONString((Object)jsonObject));
            String addUserAddress = HttpUtil.put((String)(this.DOMAINNAME + "api/integral/userAddress"), (String)jsonObject.toJSONString(), map);
            JSONObject jsonObject1 = JSON.parseObject((String)addUserAddress);
            String code = jsonObject1.getString("code");
            String msg = jsonObject1.getString("msg");
            if (code.equals("0")) {
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(msg);
            return responseData;
        }
        catch (Exception e) {
            logger.info("editReceivingAddress={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData eliminateReceivingAddress(UserAddressPutVo userAddressPutVo) {
        ResponseData responseData = new ResponseData();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Content-Type", "application/json");
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(userAddressPutVo.getMemberCode());
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        Long mbrMemberId = ((MemberInfoModel)singleMemberModel.getData()).getMbrMemberId();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)userAddressPutVo.getId());
        jsonObject.put("userId", (Object)mbrMemberId);
        try {
            logger.info("eliminateReceivingAddress={}", (Object)JSON.toJSONString(map));
            String addUserAddress = HttpUtil.delete((String)(this.DOMAINNAME + "api/integral/userAddress"), (String)jsonObject.toJSONString(), map);
            JSONObject jsonObject1 = JSON.parseObject((String)addUserAddress);
            String code = jsonObject1.getString("code");
            String msg = jsonObject1.getString("msg");
            if (code.equals("0")) {
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(msg);
            return responseData;
        }
        catch (Exception e) {
            logger.info("eliminateReceivingAddress={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData addressuery(String memberCode) {
        ResponseData responseData = new ResponseData();
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        Long mbrMemberId = ((MemberInfoModel)singleMemberModel.getData()).getMbrMemberId();
        logger.info("\u5730\u5740\u67e5\u8be2+mbrMemberId={}", (Object)mbrMemberId);
        try {
            String hotCommodity = HttpUtil.get((String)(this.DOMAINNAME + USERADDRESS + mbrMemberId));
            JSONArray commodityArray = JSON.parseArray((String)hotCommodity);
            JSONArray jsonArray = new JSONArray();
            for (int n = 0; n < commodityArray.size(); ++n) {
                JSONObject arrayJSONObject = commodityArray.getJSONObject(n);
                String aDefault = arrayJSONObject.getString("isDefault");
                if (!aDefault.equals("true")) continue;
                jsonArray.add(0, (Object)arrayJSONObject);
            }
            for (int i = 0; i < commodityArray.size(); ++i) {
                JSONObject jsonObject = commodityArray.getJSONObject(i);
                String isDefault = jsonObject.getString("isDefault");
                if (isDefault.equals("true")) continue;
                jsonArray.add((Object)jsonObject);
            }
            logger.info("hotCommodity={}", (Object)JSON.toJSONString((Object)hotCommodity));
            responseData.setData((Object)jsonArray);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        catch (Exception e) {
            logger.info("addressuery={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData fullOrderDisplay(String sysBrandId, String orderStatus, String memberCode) {
        ResponseData responseData = new ResponseData();
        try {
            ArrayList<OrderVo> orderVoList = new ArrayList<OrderVo>();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Content-Type", "application/x-www-form-urlencoded");
            String orderList = HttpUtil.get((String)(this.DOMAINNAME + ORDERLIST + sysBrandId + "/" + orderStatus + "/" + memberCode));
            logger.info("orderList={}", (Object)JSON.toJSONString((Object)orderList));
            if (StringUtils.isNotBlank((CharSequence)orderList)) {
                JSONArray parseArray = JSON.parseArray((String)orderList);
                for (int i = 0; i < parseArray.size(); ++i) {
                    OrderVo orderVo = new OrderVo();
                    JSONObject orderDetailsJson = parseArray.getJSONObject(i);
                    String id = orderDetailsJson.getString("id");
                    String orderNo = orderDetailsJson.getString("orderNo");
                    String orderIndex = orderDetailsJson.getString("orderStatus");
                    String orderTime = orderDetailsJson.getString("orderTime");
                    String goodId = orderDetailsJson.getString("goodId");
                    String goodsName = orderDetailsJson.getString("goodsName");
                    String goodSkuNo = orderDetailsJson.getString("goodSkuNo");
                    String goodsSkuSpecNames = orderDetailsJson.getString("goodsSkuSpecNames");
                    String saleQuantity = orderDetailsJson.getString("saleQuantity");
                    String saleIntegral = orderDetailsJson.getString("saleIntegral");
                    String coverImg = orderDetailsJson.getString("coverImg");
                    String detailsId = orderDetailsJson.getString("detailsId");
                    String courierCompanyCode = orderDetailsJson.getString("courierCompanyCode");
                    String courierNo = orderDetailsJson.getString("courierNo");
                    String shippingMobile = orderDetailsJson.getString("shippingMobile");
                    Date date = new Date(Long.valueOf(orderTime));
                    SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String format = sd.format(date);
                    orderVo.setId(id);
                    orderVo.setOrderNo(orderNo);
                    orderVo.setGoodId(goodId);
                    orderVo.setOrderTime(format);
                    orderVo.setOrderStatus(orderIndex);
                    orderVo.setSaleQuantity(saleQuantity);
                    orderVo.setSaleIntegral(saleIntegral);
                    orderVo.setGoodSkuNo(goodSkuNo);
                    orderVo.setGoodsName(goodsName);
                    orderVo.setCoverImg(this.qiNiuConfig.getDomain() + coverImg);
                    orderVo.setGoodsSkuSpecNames(goodsSkuSpecNames);
                    orderVo.setDetailsId(detailsId);
                    orderVo.setCourierCompanyCode(courierCompanyCode);
                    orderVo.setCourierNo(courierNo);
                    orderVo.setShippingMobile(shippingMobile);
                    orderVo.setMerchantId(orderDetailsJson.getString("merchantId"));
                    refundOrderVo refundOrderVo2 = new refundOrderVo();
                    String refundOrderString = orderDetailsJson.getString("refundOrder");
                    JSONObject refundOrder = orderDetailsJson.getJSONObject("refundOrder");
                    if (StringUtils.isNotBlank((CharSequence)refundOrderString)) {
                        String refundOrderId = refundOrder.getString("id");
                        String merchantId1 = refundOrder.getString("merchantId");
                        String orderNo1 = refundOrder.getString("orderNo");
                        String refundNo = refundOrder.getString("refundNo");
                        String orderDetailId = refundOrder.getString("orderDetailId");
                        String refundIntegral = refundOrder.getString("refundIntegral");
                        String refundQuantity = refundOrder.getString("refundQuantity");
                        String refundStatus = refundOrder.getString("refundStatus");
                        String refundType = refundOrder.getString("refundType");
                        String refundTime = refundOrder.getString("refundTime");
                        String refundReason = refundOrder.getString("refundReason");
                        String auditStatus = refundOrder.getString("auditStatus");
                        String auditReback = refundOrder.getString("auditReback");
                        refundOrderVo2.setId(refundOrderId);
                        refundOrderVo2.setMerchantId(merchantId1);
                        refundOrderVo2.setOrderNo(orderNo1);
                        refundOrderVo2.setRefundNo(refundNo);
                        refundOrderVo2.setOrderDetailId(orderDetailId);
                        refundOrderVo2.setRefundIntegral(refundIntegral);
                        refundOrderVo2.setRefundQuantity(refundQuantity);
                        refundOrderVo2.setRefundStatus(refundStatus);
                        refundOrderVo2.setRefundType(refundType);
                        refundOrderVo2.setRefundTime(refundTime);
                        refundOrderVo2.setRefundReason(refundReason);
                        refundOrderVo2.setAuditStatus(auditStatus);
                        refundOrderVo2.setAuditReback(auditReback);
                        orderVo.setRefundOrderVo(refundOrderVo2);
                    } else {
                        orderVo.setRefundOrderVo(null);
                    }
                    orderVoList.add(orderVo);
                }
                responseData.setData(orderVoList);
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
            responseData.setData((Object)orderList);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        catch (Exception e) {
            logger.info("fullOrderDisplay={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
            return responseData;
        }
    }

    public ResponseData fullCouponDisplay(CouponRecordVO couponRecordVO) {
        ResponseData responseData = new ResponseData();
        ResponseData convernConpouByMember = this.taskServiceForWXRpc.getConvernConpouByMember(couponRecordVO);
        PageInfo pageInfo = new PageInfo();
        ArrayList<MktConvertCouponRecordBo> couponRecordBos = new ArrayList<MktConvertCouponRecordBo>();
        logger.info("convernConpouByMember={}", (Object)JSON.toJSONString((Object)convernConpouByMember.getData()));
        for (MktConvertCouponRecordPO recordBo : ((PageInfo)convernConpouByMember.getData()).getList()) {
            MktConvertCouponRecordBo mktConvertCouponRecordBo = new MktConvertCouponRecordBo();
            Long couponEntityId = recordBo.getCouponEntityId();
            ResponseData byIdRpc = this.couponDefinitionServiceFeign.findByIdRpc(couponEntityId);
            BeanUtils.copyProperties((Object)recordBo, (Object)mktConvertCouponRecordBo);
            Byte preferentialType = ((CouponDefinitionPO)byIdRpc.getData()).getPreferentialType();
            BigDecimal money = ((CouponDefinitionPO)byIdRpc.getData()).getMoney();
            BigDecimal discount = ((CouponDefinitionPO)byIdRpc.getData()).getDiscount();
            mktConvertCouponRecordBo.setPreferentialType(String.valueOf(preferentialType));
            mktConvertCouponRecordBo.setMoney(String.valueOf(money));
            mktConvertCouponRecordBo.setDiscount(String.valueOf(discount));
            couponRecordBos.add(mktConvertCouponRecordBo);
        }
        pageInfo.setList(couponRecordBos);
        pageInfo.setSize(((PageInfo)convernConpouByMember.getData()).getSize());
        pageInfo.setPageSize(((PageInfo)convernConpouByMember.getData()).getPageSize());
        pageInfo.setPageNum(((PageInfo)convernConpouByMember.getData()).getPageNum());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData tailForFullCouponDisplay(Long convertCouponRecordId, String memberCode) {
        ResponseData responseData = new ResponseData();
        ResponseData convernConpouDetail = this.taskServiceForWXRpc.getConvernConpouDetail(convertCouponRecordId);
        MktConvertCouponRecordPO detailData = (MktConvertCouponRecordPO)convernConpouDetail.getData();
        MktConvertCouponRecordBo mktConvertCouponRecordBo = new MktConvertCouponRecordBo();
        BeanUtils.copyProperties((Object)detailData, (Object)mktConvertCouponRecordBo);
        Long couponEntityId = detailData.getCouponEntityId();
        logger.info("couponCodes={}", (Object)couponEntityId);
        ResponseData byIdRpc = this.couponDefinitionServiceFeign.findByIdRpc(couponEntityId);
        Byte preferentialType = ((CouponDefinitionPO)byIdRpc.getData()).getPreferentialType();
        BigDecimal money = ((CouponDefinitionPO)byIdRpc.getData()).getMoney();
        BigDecimal discount = ((CouponDefinitionPO)byIdRpc.getData()).getDiscount();
        mktConvertCouponRecordBo.setPreferentialType(String.valueOf(preferentialType));
        mktConvertCouponRecordBo.setMoney(String.valueOf(money));
        mktConvertCouponRecordBo.setDiscount(String.valueOf(discount));
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)mktConvertCouponRecordBo);
        return responseData;
    }

    public ResponseData viewOrder(String orderId) {
        ResponseData responseData = new ResponseData();
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Content-Type", "application/x-www-form-urlencoded");
            OrderVo orderVo = new OrderVo();
            String orderDetails = HttpUtil.get((String)(this.DOMAINNAME + ORDERDETAILS + orderId));
            logger.info("orderDetails={}", (Object)JSON.toJSONString((Object)orderDetails));
            if (StringUtils.isNotBlank((CharSequence)orderDetails)) {
                SimpleDateFormat sd;
                Date date;
                JSONObject orderDetailsJson = JSON.parseObject((String)orderDetails);
                String id = orderDetailsJson.getString("id");
                String orderNo = orderDetailsJson.getString("orderNo");
                String orderIndex = orderDetailsJson.getString("orderStatus");
                String orderTime = orderDetailsJson.getString("orderTime");
                String goodId = orderDetailsJson.getString("goodId");
                String goodNo = orderDetailsJson.getString("goodNo");
                String goodsName = orderDetailsJson.getString("goodsName");
                String goodSkuNo = orderDetailsJson.getString("goodSkuNo");
                String goodsSkuSpecNames = orderDetailsJson.getString("goodsSkuSpecNames");
                String detailsId = orderDetailsJson.getString("detailsId");
                String shippingName = orderDetailsJson.getString("shippingName");
                String shippingMobile = orderDetailsJson.getString("shippingMobile");
                String shippingProvince = orderDetailsJson.getString("shippingProvince");
                String shippingCity = orderDetailsJson.getString("shippingCity");
                String shippingDistrict = orderDetailsJson.getString("shippingDistrict");
                String shippingAddress = orderDetailsJson.getString("shippingAddress");
                String saleQuantity = orderDetailsJson.getString("saleQuantity");
                String saleIntegral = orderDetailsJson.getString("saleIntegral");
                String coverImg = orderDetailsJson.getString("coverImg");
                String distributionMode = orderDetailsJson.getString("distributionMode");
                String sendGoodTime = orderDetailsJson.getString("sendGoodTime");
                String courierCompanyName = orderDetailsJson.getString("courierCompanyName");
                String courierCompanyCode = orderDetailsJson.getString("courierCompanyCode");
                String courierNo = orderDetailsJson.getString("courierNo");
                String orderType = orderDetailsJson.getString("orderType");
                String signTime = orderDetailsJson.getString("gmtModified");
                String staffName = orderDetailsJson.getString("staffName");
                String storeName = orderDetailsJson.getString("storeName");
                String orderTimeDate = null;
                String sendGoodTimeDate = null;
                String signTimeDate = null;
                if (StringUtils.isNotBlank((CharSequence)orderTime)) {
                    date = new Date(Long.valueOf(orderTime));
                    sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    orderTimeDate = sd.format(date);
                    logger.info("orderTimeDate={}", (Object)orderTimeDate);
                }
                if (StringUtils.isNotBlank((CharSequence)sendGoodTime)) {
                    date = new Date(Long.valueOf(sendGoodTime));
                    sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    sendGoodTimeDate = sd.format(date);
                    logger.info("sendGoodTimeDate={}", (Object)sendGoodTimeDate);
                }
                if (StringUtils.isNotBlank((CharSequence)signTime)) {
                    date = new Date(Long.valueOf(signTime));
                    sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    signTimeDate = sd.format(date);
                    logger.info("signTimeDate={}", (Object)signTimeDate);
                }
                orderVo.setId(id);
                orderVo.setOrderNo(orderNo);
                orderVo.setOrderTime(orderTimeDate);
                orderVo.setShippingName(shippingName);
                orderVo.setShippingMobile(shippingMobile);
                orderVo.setShippingProvince(shippingProvince);
                orderVo.setShippingCity(shippingCity);
                orderVo.setShippingDistrict(shippingDistrict);
                orderVo.setShippingAddress(shippingAddress);
                orderVo.setOrderStatus(orderIndex);
                orderVo.setGoodId(goodId);
                orderVo.setGoodNo(goodNo);
                orderVo.setGoodsName(goodsName);
                orderVo.setGoodSkuNo(goodSkuNo);
                orderVo.setGoodsSkuSpecNames(goodsSkuSpecNames);
                orderVo.setCoverImg(this.qiNiuConfig.getDomain() + coverImg);
                orderVo.setDetailsId(detailsId);
                orderVo.setSaleQuantity(saleQuantity);
                orderVo.setSaleIntegral(saleIntegral);
                orderVo.setDistributionMode(orderType);
                orderVo.setSendGoodTime(sendGoodTimeDate);
                orderVo.setCourierCompanyName(courierCompanyName);
                orderVo.setCourierCompanyCode(courierCompanyCode);
                orderVo.setCourierNo(courierNo);
                orderVo.setOrderType(orderType);
                orderVo.setSignTime(signTimeDate);
                orderVo.setStoreName(storeName);
                orderVo.setStaffName(staffName);
                orderVo.setMerchantId(orderDetailsJson.getString("merchantId"));
                refundOrderVo refundOrderVo2 = new refundOrderVo();
                String detailsJsonString = orderDetailsJson.getString("refundOrder");
                if (StringUtils.isNotBlank((CharSequence)detailsJsonString)) {
                    SimpleDateFormat sd2;
                    Date date2;
                    JSONObject refundOrder = orderDetailsJson.getJSONObject("refundOrder");
                    String refundOrderId = refundOrder.getString("id");
                    String merchantId1 = refundOrder.getString("merchantId");
                    String orderNo1 = refundOrder.getString("orderNo");
                    String refundNo = refundOrder.getString("refundNo");
                    String orderDetailId = refundOrder.getString("orderDetailId");
                    String refundIntegral = refundOrder.getString("refundIntegral");
                    String refundQuantity = refundOrder.getString("refundQuantity");
                    String refundStatus = refundOrder.getString("refundStatus");
                    String refundType = refundOrder.getString("refundType");
                    String refundTime = refundOrder.getString("refundTime");
                    String refundReason = refundOrder.getString("refundReason");
                    String auditStatus = refundOrder.getString("auditStatus");
                    String auditReback = refundOrder.getString("auditReback");
                    String gmtCreate = refundOrder.getString("gmtCreate");
                    String refundTimeDate = null;
                    String gmtCreateDate = null;
                    if (StringUtils.isNotBlank((CharSequence)refundTime)) {
                        date2 = new Date(Long.valueOf(refundTime));
                        sd2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        refundTimeDate = sd2.format(date2);
                        logger.info("refundTimeDate={}", (Object)refundTimeDate);
                    }
                    if (StringUtils.isNotBlank((CharSequence)gmtCreate)) {
                        date2 = new Date(Long.valueOf(gmtCreate));
                        sd2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        gmtCreateDate = sd2.format(date2);
                        logger.info("gmtCreateDate={}", (Object)gmtCreate);
                    }
                    refundOrderVo2.setId(refundOrderId);
                    refundOrderVo2.setMerchantId(merchantId1);
                    refundOrderVo2.setOrderNo(orderNo1);
                    refundOrderVo2.setRefundNo(refundNo);
                    refundOrderVo2.setOrderDetailId(orderDetailId);
                    refundOrderVo2.setRefundIntegral(refundIntegral);
                    refundOrderVo2.setRefundQuantity(refundQuantity);
                    refundOrderVo2.setRefundStatus(refundStatus);
                    refundOrderVo2.setRefundType(refundType);
                    refundOrderVo2.setRefundTime(refundTimeDate);
                    refundOrderVo2.setRefundReason(refundReason);
                    refundOrderVo2.setAuditStatus(auditStatus);
                    refundOrderVo2.setAuditReback(auditReback);
                    refundOrderVo2.setGmtCreate(gmtCreateDate);
                    orderVo.setRefundOrderVo(refundOrderVo2);
                } else {
                    orderVo.setRefundOrderVo(null);
                }
                responseData.setData((Object)orderVo);
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                return responseData;
            }
            responseData.setData((Object)orderDetails);
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("viewOrder={}", (Object)e.getMessage());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
    }

    public ResponseData integralAcquisition(String sysBrandId) {
        ResponseData responseData = new ResponseData();
        try {
            String integralAcquisition = HttpUtil.get((String)(this.DOMAINNAME + INTEGRALACQUISITIOON + sysBrandId));
            responseData.setData((Object)integralAcquisition);
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        catch (Exception e) {
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData(null);
            return responseData;
        }
    }

    public ResponseData storeSelfMention() {
        return null;
    }

    public ResponseData logisticsCompanyGroup() {
        ResponseData responseData = new ResponseData();
        try {
            String companyList = HttpUtil.get((String)(this.DOMAINNAME + LOGISTICLIST));
            JSONObject parseObject = JSON.parseObject((String)companyList);
            JSONArray jsonArray = parseObject.getJSONArray("companyList");
            logger.info("companyList={}", (Object)jsonArray);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setData((Object)jsonArray);
            return responseData;
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
            return responseData;
        }
    }

    public ResponseData displayLogistics(String companyCode, String num, String phone) {
        ResponseData responseData = new ResponseData();
        try {
            String rotationChart = HttpUtil.get((String)(this.DOMAINNAME + DISPLAYLOGISTICS + companyCode + "&num=" + num + "&phone=" + phone));
            JSONArray parseArray = JSON.parseArray((String)rotationChart);
            responseData.setData((Object)parseArray);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
            return responseData;
        }
    }

    public ResponseData applyeturnSubmission(ReturnGoodsVo returnGoodsVo) {
        ResponseData responseData = new ResponseData();
        try {
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(returnGoodsVo.getMemberCode());
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            Long brandId = ((MemberInfoModel)singleMemberModel.getData()).getBrandId();
            String name = ((MemberInfoModel)singleMemberModel.getData()).getName();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Content-Type", "application/json");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("merchantId", (Object)brandId);
            jsonObject.put("orderNo", (Object)returnGoodsVo.getOrderNo());
            jsonObject.put("orderDetailId", (Object)returnGoodsVo.getOrderDetailId());
            jsonObject.put("refundType", (Object)returnGoodsVo.getRefundType());
            jsonObject.put("refundReason", (Object)returnGoodsVo.getRefundReason());
            jsonObject.put("auditor", (Object)name);
            logger.info("applyeturnSubmission={}", (Object)JSON.toJSONString((Object)jsonObject));
            String applyeturnSubmission = HttpUtil.post((String)(this.DOMAINNAME + APPLICATIONSUBMISSION), (String)jsonObject.toJSONString(), map);
            JSONObject jsonObject1 = JSON.parseObject((String)applyeturnSubmission);
            String code = jsonObject1.getString("code");
            String msg = jsonObject1.getString("msg");
            if (code.equals("0")) {
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(msg);
            return responseData;
        }
        catch (Exception e) {
            logger.info("applyeturnSubmission={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData applyeturnNotSubmitted(RefundLogisticsVo refundLogisticsVo) {
        ResponseData responseData = new ResponseData();
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Content-Type", "application/json");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("refundNo", (Object)refundLogisticsVo.getRefundNo());
            jsonObject.put("refundShippingCompany", (Object)refundLogisticsVo.getRefundShippingCompany());
            jsonObject.put("refundCompanyCode", (Object)refundLogisticsVo.getRefundCompanyCode());
            jsonObject.put("refundShippingNo", (Object)refundLogisticsVo.getRefundShippingNo());
            logger.info("applyeturnNotSubmitted={}", (Object)JSON.toJSONString((Object)jsonObject));
            String applyeturnSubmission = HttpUtil.post((String)(this.DOMAINNAME + APPLICATIONSUBMISSIONWULIU), (String)jsonObject.toJSONString(), map);
            JSONObject jsonObject1 = JSON.parseObject((String)applyeturnSubmission);
            String code = jsonObject1.getString("code");
            String msg = jsonObject1.getString("msg");
            if (code.equals("0")) {
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                return responseData;
            }
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(msg);
            return responseData;
        }
        catch (Exception e) {
            logger.info("applyeturnSubmission={}", (Object)e.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
    }

    public ResponseData instructions(String sysBrandId) {
        ResponseData responseData = new ResponseData();
        try {
            String instructions = HttpUtil.get((String)(this.DOMAINNAME + INSTRUCTIONNS + sysBrandId));
            responseData.setData((Object)instructions);
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        catch (Exception e) {
            logger.info("instructions={}", (Object)e.getMessage());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
    }

    public ResponseData getConfig(Integer merchantId) throws IOException {
        ResponseData data = new ResponseData();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String result = HttpUtil.get((String)(this.DOMAINNAME + GET_CONFIG + "?merchantId=" + merchantId));
        if (StringUtils.isEmpty((CharSequence)result)) {
            throw LogicException.error((Integer)-1, (String)"\u5546\u5bb6\u672a\u4fdd\u5b58\u57fa\u7840\u914d\u7f6e");
        }
        JSONObject json = JSONObject.parseObject((String)result);
        Boolean customerService = (Boolean)json.get((Object)"customerService");
        Boolean refundSingle = (Boolean)json.get((Object)"refundSingle");
        map.put("customerService", customerService);
        map.put("refundSingle", refundSingle);
        map.put("integralRule", json.getString("integralRule"));
        data.setData(map);
        return data;
    }
}

