/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.common.HttpUtil;
import com.bizvane.appletservice.models.bo.ObtainGraphicBo;
import com.bizvane.appletservice.rpc.GraphicTemplateServiceRpc;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class GraphicTemplateServiceRpcImpl
implements GraphicTemplateServiceRpc {
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    private static final String WXOBTAIN_FRAPHIC = "https://api.weixin.qq.com/cgi-bin/material/batchget_material?access_token=";
    private static final String WXOBTAIN_FRAPHIC_CONT = "https://api.weixin.qq.com/cgi-bin/material/get_materialcount?access_token=";
    private static final String GROUP_SENDING = "https://api.weixin.qq.com/cgi-bin/message/mass/send?access_token=";
    private static final String GROUP_SENDING_DOING = "https://api.weixin.qq.com/cgi-bin/message/mass/get?access_token=";

    public ResponseData<ObtainGraphicBo> obtainGraphicTemplate(@RequestBody ObtainGraphicBo obtainGraphicBo) {
        ResponseData responseData = new ResponseData();
        ResponseData wxPublicBySysBrandId = this.wxPublicServiceFeign.getWxPublicBySysBrandId(obtainGraphicBo.getBrandId());
        WxPublicPO bySysBrandIdData = (WxPublicPO)wxPublicBySysBrandId.getData();
        if (bySysBrandIdData != null) {
            String appid = bySysBrandIdData.getAppid();
            ResponseData accessTokenByAppId = this.wxPublicServiceFeign.getAccessTokenByAppId(appid);
            String token = (String)accessTokenByAppId.getData();
            try {
                String couns = HttpUtil.get((String)(WXOBTAIN_FRAPHIC_CONT + token));
                logger.info("\u83b7\u53d6\u56fe\u6587\u6a21\u677f\u603b\u6570={}", (Object)JSON.toJSONString((Object)couns));
                HashMap<String, String> stringMap = new HashMap<String, String>();
                stringMap.put("type", obtainGraphicBo.getType());
                stringMap.put("offset", obtainGraphicBo.getOffset());
                stringMap.put("count", obtainGraphicBo.getCount());
                logger.info("\u83b7\u53d6\u56fe\u6587\u6a21\u677f\u5217\u8868\u5165\u53c2={}", (Object)JSON.toJSONString(stringMap));
                String obtainGraphicString = HttpUtil.post((String)(WXOBTAIN_FRAPHIC + token), (String)JSON.toJSONString(stringMap));
                logger.info("\u83b7\u53d6\u56fe\u6587\u6a21\u677f\u5217\u8868={}", (Object)JSON.toJSONString((Object)obtainGraphicString));
                JSONObject jsonObject = JSONObject.parseObject((String)obtainGraphicString);
                JSONObject obtainGraphicJson = new JSONObject();
                String item = jsonObject.getString("item");
                String total_count = jsonObject.getString("total_count");
                String item_count = jsonObject.getString("item_count");
                JSONArray jsonArray = JSONArray.parseArray((String)item);
                JSONArray arrayToo = new JSONArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject object = jsonArray.getJSONObject(i);
                    JSONObject jobck = new JSONObject();
                    String content = object.getString("content");
                    String stringTime = object.getString("update_time");
                    String media_id = object.getString("media_id");
                    JSONObject jsonContent = JSONObject.parseObject((String)content);
                    JSONObject jsoncontents = new JSONObject();
                    String news_item = jsonContent.getString("news_item");
                    String create_time = jsonContent.getString("create_time");
                    String update_time = jsonContent.getString("update_time");
                    JSONArray jsonNewsItem = JSONArray.parseArray((String)news_item);
                    JSONArray jsonArray1 = new JSONArray();
                    for (int n = 0; n < jsonNewsItem.size(); ++n) {
                        JSONObject jsonNewsItemJSONObject = jsonNewsItem.getJSONObject(n);
                        JSONObject jsonObject1 = new JSONObject();
                        String thumbUrl = jsonNewsItemJSONObject.getString("thumb_url");
                        String title = jsonNewsItemJSONObject.getString("title");
                        String author = jsonNewsItemJSONObject.getString("author");
                        String digest = jsonNewsItemJSONObject.getString("digest");
                        String content1 = jsonNewsItemJSONObject.getString("content");
                        String content_source_url = jsonNewsItemJSONObject.getString("content_source_url");
                        String url = jsonNewsItemJSONObject.getString("url");
                        String need_open_comment = jsonNewsItemJSONObject.getString("need_open_comment");
                        String only_fans_can_comment = jsonNewsItemJSONObject.getString("only_fans_can_comment");
                        String uploadUrl = QiNiuUtil.uploadUrl((String)thumbUrl, null);
                        logger.info("uploadUrl={}", (Object)uploadUrl);
                        jsonObject1.put("title", (Object)title);
                        jsonObject1.put("content", (Object)content1);
                        jsonObject1.put("author", (Object)author);
                        jsonObject1.put("digest", (Object)digest);
                        jsonObject1.put("content_source_url", (Object)content_source_url);
                        jsonObject1.put("url", (Object)url);
                        jsonObject1.put("thumb_url", (Object)uploadUrl);
                        jsonObject1.put("need_open_comment", (Object)need_open_comment);
                        jsonObject1.put("only_fans_can_comment", (Object)only_fans_can_comment);
                        jsonArray1.set(n, (Object)jsonObject1);
                    }
                    jsoncontents.put("news_item", (Object)jsonArray1);
                    jsoncontents.put("update_time", (Object)update_time);
                    jsoncontents.put("create_time", (Object)create_time);
                    jobck.put("content", (Object)jsoncontents);
                    jobck.put("update_time", (Object)stringTime);
                    jobck.put("media_id", (Object)media_id);
                    arrayToo.set(i, (Object)jobck);
                }
                obtainGraphicJson.put("item", (Object)arrayToo);
                obtainGraphicJson.put("total_count", (Object)total_count);
                obtainGraphicJson.put("item_count", (Object)item_count);
                String obtainGraphic = obtainGraphicJson.toJSONString();
                ObtainGraphicBo graphicBo = new ObtainGraphicBo();
                graphicBo.setCounts(couns);
                graphicBo.setObtainGraphic(obtainGraphic);
                logger.info("\u6a21\u677f\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)graphicBo));
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                responseData.setData((Object)graphicBo);
                return responseData;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage("bySysBrandIdData\u4e3a\u7a7a");
        return responseData;
    }

    public ResponseData groupSending(@RequestBody ObtainGraphicBo obtainGraphicBo) {
        logger.info("groupSending\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)obtainGraphicBo));
        ResponseData responseData = new ResponseData();
        try {
            ResponseData wxPublicBySysBrandId = this.wxPublicServiceFeign.getWxPublicBySysBrandId(obtainGraphicBo.getBrandId());
            WxPublicPO bySysBrandIdData = (WxPublicPO)wxPublicBySysBrandId.getData();
            if (bySysBrandIdData != null) {
                String appid = bySysBrandIdData.getAppid();
                ResponseData wxPublicPOByAppId = this.wxPublicServiceFeign.getWxPublicPOByAppId(appid);
                WxPublicPO data = (WxPublicPO)wxPublicPOByAppId.getData();
                String dataAppid = data.getAppid();
                ResponseData accessTokenByAppId = this.wxPublicServiceFeign.getAccessTokenByAppId(dataAppid);
                String token = (String)accessTokenByAppId.getData();
                List openId = obtainGraphicBo.getOpenId();
                JSONArray array = new JSONArray();
                array.addAll((Collection)openId);
                String mediaId = obtainGraphicBo.getMediaId();
                JSONObject objectBig = new JSONObject();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("media_id", (Object)mediaId);
                String msgType = obtainGraphicBo.getMsgType();
                String sendIgnoreReprint = obtainGraphicBo.getSendIgnoreReprint();
                objectBig.put("touser", (Object)array);
                objectBig.put("mpnews", (Object)jsonObject);
                objectBig.put("msgtype", (Object)msgType);
                objectBig.put("send_ignore_reprint", (Object)"1");
                logger.info("token={}", (Object)token);
                logger.info("stringMap={}", (Object)JSON.toJSONString((Object)objectBig));
                String post = HttpUtil.post((String)(GROUP_SENDING + token), (String)objectBig.toString());
                logger.info("\u7fa4\u53d1\u56de\u6267={}", (Object)JSON.toJSONString((Object)post));
                JSONObject parseObject = JSONObject.parseObject((String)post);
                String errcode = parseObject.getString("errcode");
                String errmsg = parseObject.getString("errmsg");
                String msg_id = parseObject.getString("msg_id");
                String msg_data_id = parseObject.getString("msg_data_id");
                Integer integer = Integer.valueOf(errcode);
                responseData.setCode(integer.intValue());
                responseData.setMessage(errmsg);
                responseData.setData((Object)msg_id);
                return responseData;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        responseData.setCode(100);
        responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        return responseData;
    }

    public ResponseData groupSendingDoing(String msgId, Long brandId) {
        ResponseData responseData = new ResponseData();
        try {
            ResponseData wxPublicBySysBrandId = this.wxPublicServiceFeign.getWxPublicBySysBrandId(brandId);
            WxPublicPO bySysBrandIdData = (WxPublicPO)wxPublicBySysBrandId.getData();
            if (bySysBrandIdData != null) {
                String appid = bySysBrandIdData.getAppid();
                ResponseData accessTokenByAppId = this.wxPublicServiceFeign.getAccessTokenByAppId(appid);
                String token = (String)accessTokenByAppId.getData();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("msg_id", (Object)msgId);
                String post = HttpUtil.post((String)(GROUP_SENDING_DOING + token), (String)jsonObject.toJSONString());
                JSONObject parseObject = JSONObject.parseObject((String)post);
                String msg_id = parseObject.getString("msg_id");
                String msg_status = parseObject.getString("msg_status");
                logger.info("msg_status={}", (Object)msg_status);
                if ("SEND_SUCCESS".equals(msg_status)) {
                    responseData.setCode(0);
                    responseData.setMessage("\u6d88\u606f\u6210\u529f\u53d1\u9001");
                    return responseData;
                }
                if ("SENDING".equals(msg_status)) {
                    responseData.setCode(50);
                    responseData.setMessage("\u6d88\u606f\u53d1\u9001\u4e2d");
                    return responseData;
                }
                if ("SEND_FAIL".equals(msg_status)) {
                    responseData.setCode(100);
                    responseData.setMessage("\u6d88\u606f\u53d1\u9001\u5931\u8d25");
                    return responseData;
                }
                if ("DELETE".equals(msg_status)) {
                    responseData.setCode(200);
                    responseData.setMessage("\u6d88\u606f\u5df2\u7ecf\u5220\u9664");
                    return responseData;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return responseData;
    }
}

