/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.interfaces.MemberWeChatUserService;
import com.bizvane.appletservice.models.bo.AppletWeChatInfoBo;
import com.bizvane.centerstageservice.models.po.SysDimSkuPo;
import com.bizvane.centerstageservice.models.rpc.SysDimSkuRpc;
import com.bizvane.centerstageservice.models.vo.StoreStaffOfflineRelVo;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.centerstageservice.rpc.SysDimSkuServiceRpc;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatenterprise.service.entity.vo.StaffCardResponseVO;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberWeChatUser"})
public class MemberWeChatUserController {
    @Autowired
    private MemberWeChatUserService memberWeChatUserService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    @Autowired
    private SysDimSkuServiceRpc sysDimSkuServiceRpc;
    @Autowired
    private StoreServiceRpc storeServiceRpc;

    @RequestMapping(value={"/getAppletMemberInfo"})
    public ResponseData<Map<String, Object>> getAppletMemberInfo(AppletWeChatInfoBo bo, HttpServletRequest request) {
        logger.info("\u67e5\u8be2\u5fae\u4fe1\u7528\u6237\u4fe1\u606f={}", (Object)bo.toString());
        return this.memberWeChatUserService.getAppletMemberInfo(bo);
    }

    @RequestMapping(value={"/registerAppletMemberInfo"})
    public ResponseData<Map<String, Object>> registerAppletMemberInfo(AppletWeChatInfoBo bo) {
        logger.info("\u4f1a\u5458\u6ce8\u518c={}", (Object)bo.toString());
        return this.memberWeChatUserService.registerAppletMemberInfo(bo);
    }

    @RequestMapping(value={"/getStoreStaffInfo"}, method={RequestMethod.POST})
    ResponseData<StaffCardResponseVO> getStoreStaffInfo(@RequestParam(value="memberCode") String memberCode) {
        return this.memberWeChatUserService.getStoreStaffInfo(memberCode);
    }

    @RequestMapping(value={"/memberInfo"}, method={RequestMethod.GET})
    ResponseData<MemberInfoModel> getMemberInfo(@RequestParam String memberCode) {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        return singleMemberModel;
    }

    @PostMapping(value={"/getOfflineSkuInfo"})
    ResponseData<SysDimSkuRpc> getOfflineSkuInfo(@RequestBody List<SysDimSkuPo> po) {
        logger.info("\u67e5\u8be2\u7ebf\u4e0b\u5546\u54c1\u4fe1\u606f\u5165\u53c2:[{}]", JSON.toJSON(po));
        ResponseData offLineGoodsInfo = this.sysDimSkuServiceRpc.getOffLineGoodsInfo(po);
        logger.info("\u67e5\u8be2\u7ebf\u4e0b\u5546\u54c1\u4fe1\u606f\u8fd4\u53c2:[{}]", JSON.toJSON((Object)offLineGoodsInfo));
        return offLineGoodsInfo;
    }

    @RequestMapping(value={"/queryOfflineMemberInfo"}, method={RequestMethod.GET})
    ResponseData<MemberInfoModel> queryOfflineMemberInfo(@RequestParam(value="companyId") Long companyId, @RequestParam(value="brandId") Long brandId, @RequestParam(value="memberCode") String memberCode) {
        ResponseData storeStaff;
        MemberInfoModel memberInfoModel;
        logger.info("queryOfflineMemberInfo\u67e5\u8be2\u5165\u53c2:[{}]_[{}]_[{}]", new Object[]{companyId, brandId, memberCode});
        ResponseData memberInfoModelResponseData = this.memberInfoApiService.queryOfflineMemberInfo(companyId, brandId, memberCode);
        if (memberInfoModelResponseData != null && memberInfoModelResponseData.getCode() == 0 && (memberInfoModel = (MemberInfoModel)memberInfoModelResponseData.getData()) != null && memberInfoModel.getServiceStoreId() != null && memberInfoModel.getServiceGuideId() != null && (storeStaff = this.storeServiceRpc.getStoreStaffOfflineRelById(memberInfoModel.getServiceStoreId(), memberInfoModel.getServiceGuideId())) != null && storeStaff.getCode() == 0) {
            StoreStaffOfflineRelVo data = (StoreStaffOfflineRelVo)storeStaff.getData();
            logger.info("\u67e5\u8be2\u7ebf\u4e0b\u95e8\u5e97\u5bfc\u8d2d\u6570\u636e:[{}]", JSON.toJSON((Object)data));
            memberInfoModel.setServiceGuideCode(data.getStaffCode());
            memberInfoModel.setServiceGuideId(Long.valueOf(Long.parseLong(data.getStaffId())));
            memberInfoModel.setServiceStoreCode(data.getSysStoreOfflineCode());
            memberInfoModel.setServiceStoreId(Long.valueOf(Long.parseLong(data.getStoreId())));
        }
        logger.info("queryOfflineMemberInfo\u67e5\u8be2\u8fd4\u53c2:[{}]", JSON.toJSON((Object)memberInfoModelResponseData));
        return memberInfoModelResponseData;
    }
}

