/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.models.bo.AppletRefreshtoInterfaceBo;
import com.bizvane.appletservice.models.bo.AppletSysStoreBo;
import com.bizvane.appletservice.models.po.AppletResourcesPO;
import com.bizvane.appletservice.models.po.AppletResourcesPOExample;
import com.bizvane.appletserviceimpl.mappers.AppletResourcesPOMapper;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.centerstageservice.models.bo.SysStoreBo;
import com.bizvane.centerstageservice.models.po.SysStorePrivilegePo;
import com.bizvane.centerstageservice.models.vo.StaffVo;
import com.bizvane.centerstageservice.models.vo.SysStoreVo;
import com.bizvane.centerstageservice.rpc.StaffServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatenterprise.service.common.PageFormUtil;
import com.github.pagehelper.PageInfo;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberStore"})
public class MemberStoreController {
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private StaffServiceRpc staffServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private AppletResourcesPOMapper appletResourcesPOMapper;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    DecimalFormat df = new DecimalFormat("###.#");

    @RequestMapping(value={"/getBrandByIdSysStoreList"}, method={RequestMethod.POST})
    public ResponseData<List<SysStoreBo>> getBrandByIdSysStoreList(SysStoreBo bo, HttpServletRequest request) {
        logger.info("\u95e8\u5e97\u5bfc\u822a\u5165\u53c2={}", (Object)JSON.toJSONString((Object)bo));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        Long storeId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
        bo.setSysStoreId(storeId);
        if (bo.getSysBrandId() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u54c1\u724c id\u672a\u83b7\u53d6");
        }
        if (bo.getPageSize() == null || bo.getPageSize() == 0) {
            bo.setPageSize(Integer.valueOf(20));
        }
        if (bo.getPageNum() == null || bo.getPageNum() == 0) {
            bo.setPageNum(Integer.valueOf(1));
        }
        ResponseData storeListPage = this.storeServiceRpc.getBrandByIdSysStoreListPage(bo);
        List storeList = ((PageInfo)storeListPage.getData()).getList();
        ArrayList<AppletSysStoreBo> AppletSysStoreBos = new ArrayList<AppletSysStoreBo>();
        for (SysStoreBo sysStoreBo : storeList) {
            AppletSysStoreBo appletSysStoreBo = new AppletSysStoreBo();
            String distance = sysStoreBo.getDistance();
            if (distance == null) {
                sysStoreBo.setDistance(distance);
            } else {
                Double aDouble = Double.valueOf(distance);
                if (aDouble == null) {
                    sysStoreBo.setDistance(distance);
                }
                double lod = aDouble / 1000.0;
                String format = this.df.format(lod);
                sysStoreBo.setDistance(format);
            }
            BeanUtils.copyProperties((Object)sysStoreBo, (Object)appletSysStoreBo);
            if (appletSysStoreBo != null) {
                AppletSysStoreBos.add(appletSysStoreBo);
                continue;
            }
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        AppletResourcesPOExample appletResourcesPOExample = new AppletResourcesPOExample();
        appletResourcesPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andModularCodeEqualTo("M001").andSysBrandIdEqualTo(bo.getSysBrandId()).andModularTypeEqualTo("2");
        List resourcesPOS = this.appletResourcesPOMapper.selectByExample(appletResourcesPOExample);
        for (AppletResourcesPO appletResourcesPO : resourcesPOS) {
            appletResourcesPO.setModularContent(this.qiNiuConfig.getDomain() + appletResourcesPO.getModularContent());
        }
        AppletRefreshtoInterfaceBo appletRefreshtoInterfaceBo = new AppletRefreshtoInterfaceBo();
        ArrayList<AppletSysStoreBo> sysStoreBos = new ArrayList<AppletSysStoreBo>();
        ArrayList<AppletSysStoreBo> appletSysStoreBos = new ArrayList<AppletSysStoreBo>();
        ArrayList<AppletSysStoreBo> bos = new ArrayList<AppletSysStoreBo>();
        if (AppletSysStoreBos != null) {
            for (AppletSysStoreBo appletSysStoreBo : AppletSysStoreBos) {
                if (appletSysStoreBo.getDistance() == null && !"1".equals(appletSysStoreBo.getIsExclusive())) {
                    sysStoreBos.add(appletSysStoreBo);
                }
                if (appletSysStoreBo.getDistance() != null && !"1".equals(appletSysStoreBo.getIsExclusive())) {
                    appletSysStoreBos.add(appletSysStoreBo);
                }
                if (!"1".equals(appletSysStoreBo.getIsExclusive())) continue;
                bos.add(appletSysStoreBo);
            }
        }
        if (appletSysStoreBos != null) {
            Collections.sort(appletSysStoreBos, new /* Unavailable Anonymous Inner Class!! */);
        }
        ArrayList<AppletSysStoreBo> appletSysStoreBoList = new ArrayList<AppletSysStoreBo>();
        appletSysStoreBoList.addAll(bos);
        appletSysStoreBoList.addAll(appletSysStoreBos);
        appletSysStoreBoList.addAll(sysStoreBos);
        appletRefreshtoInterfaceBo.setAppletSysStoreBos(appletSysStoreBoList);
        appletRefreshtoInterfaceBo.setResourcesPOS(resourcesPOS);
        appletRefreshtoInterfaceBo.setTotal(Long.valueOf(((PageInfo)storeListPage.getData()).getTotal()));
        logger.info("\u95e8\u5e97\u5bfc\u822a\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)appletRefreshtoInterfaceBo));
        responseData.setData((Object)appletRefreshtoInterfaceBo);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    @RequestMapping(value={"/getStoreStaffList"}, method={RequestMethod.POST})
    public ResponseData<com.bizvane.utils.responseinfo.PageInfo<StaffVo>> getBrandByIdSysStoreList(Long sysStoreId, Long sysCompanyId, Long sysBrandId, PageFormUtil formUtil) {
        ResponseData responseData = new ResponseData();
        ResponseData sysStoreVoResponseData = this.storeServiceRpc.getSysStoreById(sysStoreId);
        SysStoreVo storeVo = (SysStoreVo)sysStoreVoResponseData.getData();
        ResponseData staffVOResult = this.staffServiceRpc.getStoreStaffList(storeVo.getSysStoreOfflineCode(), sysCompanyId, formUtil.getPageNumber(), formUtil.getPageSize());
        logger.info("\u67e5\u8be2\u5e97\u94fa\u4e0b\u7684\u5bfc\u8d2d={}", (Object)JSON.toJSONString((Object)staffVOResult));
        responseData.setData((Object)staffVOResult);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    @RequestMapping(value={"/getStorePrivilegeInfoById"}, method={RequestMethod.POST})
    public ResponseData<SysStorePrivilegePo> getStorePrivilegeInfoById(@RequestParam(value="sysStorePrivilegeId") Long sysStorePrivilegeId) {
        return this.storeServiceRpc.getStorePrivilegeInfoById(sysStorePrivilegeId);
    }

    @RequestMapping(value={"/getSysStoreById"}, method={RequestMethod.POST})
    public ResponseData<SysStoreVo> getSysStoreById(@RequestParam(value="sysStoreId") Long sysStoreId) {
        return this.storeServiceRpc.getSysStoreById(sysStoreId);
    }
}

