/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.bizvane.appletservice.interfaces.MemberWeChatUserService;
import com.bizvane.appletservice.models.bo.AppletWeChatInfoBo;
import com.bizvane.members.facade.service.api.MiniProgramFocusOnService;
import com.bizvane.members.facade.service.api.MiniProgramOpenCardService;
import com.bizvane.members.facade.service.card.request.FocusOnRequestModel;
import com.bizvane.members.facade.service.card.request.RequestOpenCardModel;
import com.bizvane.members.facade.service.card.response.FocusOnResponseModel;
import com.bizvane.members.facade.service.card.response.ResponseOpenCardModel;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.JWTUtil;
import com.bizvane.wechatenterprise.service.entity.vo.StaffCardResponseVO;
import com.bizvane.wechatenterprise.service.rpc.WeChatServiceRpc;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MemberWeChatUserServiceImpl
implements MemberWeChatUserService {
    @Autowired
    private MiniProgramFocusOnService miniProgramFocusOnService;
    @Autowired
    private MiniProgramOpenCardService miniProgramOpenCardService;
    @Autowired
    private WeChatServiceRpc weChatServiceRpc;

    public ResponseData<Map<String, Object>> getAppletMemberInfo(AppletWeChatInfoBo bo) {
        ResponseData responseData = new ResponseData();
        FocusOnRequestModel model = new FocusOnRequestModel();
        model.setAppId(bo.getAppId());
        model.setCity(bo.getCity());
        model.setCounty(bo.getCounty());
        model.setGender(bo.getGender());
        model.setHeadPortraits(bo.getHeadPortraits());
        model.setMiniProgram(bo.getMiniProgram());
        model.setOpenId(bo.getOpenId());
        model.setProvince(bo.getProvince());
        model.setReferrerOpenid(bo.getReferrerOpenid());
        model.setUnionId(bo.getUnionId());
        model.setWxNick(bo.getWxNick());
        FocusOnResponseModel focusOnResponseModel = this.miniProgramFocusOnService.focusByMiniProgram(model);
        if (focusOnResponseModel.getCardStatus() == 1) {
            responseData.setData((Object)focusOnResponseModel);
            return responseData;
        }
        String token = JWTUtil.sign((Object)focusOnResponseModel, (long)JWTUtil.TTLMILLIS.intValue());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("token", token);
        map.put("memberCardLevelModel", (String)focusOnResponseModel);
        responseData.setData(map);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<Map<String, Object>> registerAppletMemberInfo(AppletWeChatInfoBo bo) {
        ResponseData responseData = new ResponseData();
        RequestOpenCardModel model = new RequestOpenCardModel();
        model.setAppId(bo.getAppId());
        model.setOpenId(bo.getOpenId());
        model.setUnionId(bo.getUnionId());
        model.setPhone(bo.getPhone());
        ResponseOpenCardModel responseOpenCardModel = this.miniProgramOpenCardService.openCard(model);
        String token = JWTUtil.sign((Object)responseOpenCardModel, (long)JWTUtil.TTLMILLIS.intValue());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("token", token);
        map.put("memberCardLevelModel", (String)responseOpenCardModel);
        responseData.setData(map);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<StaffCardResponseVO> getStoreStaffInfo(String memberCode) {
        ResponseData responseVOResponseData = this.weChatServiceRpc.getStoreStaffInfo(memberCode);
        return responseVOResponseData;
    }
}

