/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.AppletSaveImgsService;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Decoder;

@Service
public class AppletSaveImgsServiceImpl
implements AppletSaveImgsService {
    public static final Logger logger = LoggerFactory.getLogger(AppletSaveImgsServiceImpl.class);

    public ResponseData<String> saveImgs(String strImg) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)strImg)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String type = ".png";
        String filename = uuid + type;
        String qiniuUrl = "";
        try {
            byte[] bytes = decoder.decodeBuffer(strImg);
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] >= 0) continue;
                int n = i;
                bytes[n] = (byte)(bytes[n] + 256);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(bytes);
            ByteArrayInputStream is = new ByteArrayInputStream(out.toByteArray());
            qiniuUrl = QiNiuUtil.upload((InputStream)is, (String)filename);
            logger.info("qiniuUrl={}", (Object)qiniuUrl);
            out.flush();
            out.close();
            ((InputStream)is).close();
            responseData.setData((Object)qiniuUrl);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        catch (Exception e) {
            logger.info("enter WechatServiceImpl saveImgs method! param:{}", (Object)JSONObject.toJSONString((Object)e));
            return responseData;
        }
    }
}

