/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.models.bo.CouponEntityAndDefinitionBo;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.couponfacade.interfaces.CouponQueryServiceFeign;
import com.bizvane.couponfacade.interfaces.CouponServiceFeign;
import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.couponfacade.models.vo.CouponEntityAndDefinitionVO;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.couponfacade.models.vo.CouponListByMemberCodeRequestVO;
import com.bizvane.couponfacade.models.vo.CouponOnlineUseRequestVO;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.mktcenterservice.models.vo.ActivityManualVO;
import com.bizvane.mktcenterservice.models.vo.ActivityVO;
import com.bizvane.mktcenterservice.models.vo.MktRedPortRecordVO;
import com.bizvane.mktcenterservice.rpc.ActivityManualServiceRpc;
import com.bizvane.mktcenterservice.rpc.ActivityRedPortServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.catalina.servlet4preview.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/activity"})
public class MenberCenterActivityController {
    @Autowired
    private ActivityManualServiceRpc activityManualServiceRpc;
    @Autowired
    private CouponQueryServiceFeign couponQueryServiceFeign;
    @Autowired
    private CouponServiceFeign couponServiceFeign;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private ActivityRedPortServiceRpc activityRedPortServiceRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/getActivityRecordPOList"}, method={RequestMethod.POST})
    public ResponseData<List<ActivityVO>> getActivityRecordPOList(ActivityManualVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        if (vo.getMemberInfoModel().getBrandId() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u54c1\u724cID");
            return responseData;
        }
        if (vo.getActivityCode() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u6d3b\u52a8\u7f16\u53f7");
            return responseData;
        }
        if (vo.getActivityType() == null) {
            responseData.setMessage("\u9886\u52b5\u7c7b\u522b\u672a\u8f93\u5165");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        Long openCardStoreId = (Long)this.wxAppletApiService.getOpenCardStoreId(memberCode).getData();
        Long serviceStoreId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
        logger.info("openCardStoreId={} , serviceStoreId={}", (Object)openCardStoreId, (Object)serviceStoreId);
        vo.getMemberInfoModel().setOpenCardStoreId(openCardStoreId);
        vo.getMemberInfoModel().setServiceStoreId(serviceStoreId);
        vo.getMemberInfoModel().setMemberCode(memberCode);
        logger.info("\u626b\u7801\u9886\u52b5\u5165\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)vo));
        ResponseData byQrcode = this.activityManualServiceRpc.getActivityByQrcode(vo);
        responseData.setData(byQrcode.getData());
        return responseData;
    }

    @RequestMapping(value={"/executeActivity"}, method={RequestMethod.POST})
    public ResponseData<ActivityManualVO> executeActivity(ActivityManualVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        vo.getMemberInfoModel().setMemberCode(memberCode);
        logger.info("\u626b\u7801\u9886\u53d6\u5165\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)vo));
        return this.activityManualServiceRpc.executeActivity(vo);
    }

    @RequestMapping(value={"/getActivityByMemberInfo"}, method={RequestMethod.POST})
    public ResponseData<List<ActivityVO>> getActivityByMemberInfo(ActivityManualVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        if (vo.getMemberInfoModel().getBrandId() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u54c1\u724cID");
            return responseData;
        }
        if (vo.getActivityType() == null) {
            responseData.setMessage("\u9886\u52b5\u7c7b\u522b\u672a\u8f93\u5165");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        vo.getMemberInfoModel().setMemberCode(memberCode);
        Long openCardStoreId = (Long)this.wxAppletApiService.getOpenCardStoreId(memberCode).getData();
        Long serviceStoreId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
        logger.info("openCardStoreId={} , serviceStoreId={}", (Object)openCardStoreId, (Object)serviceStoreId);
        vo.getMemberInfoModel().setOpenCardStoreId(openCardStoreId);
        vo.getMemberInfoModel().setServiceStoreId(serviceStoreId);
        logger.info("\u9886\u5238\u4e2d\u5fc3\u5217\u8868={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)vo));
        ResponseData brandByID = this.brandServiceRpc.getBrandByID(vo.getMemberInfoModel().getBrandId());
        Long sysCompanyId = ((SysBrandPo)brandByID.getData()).getSysCompanyId();
        String mktActivityId = (String)this.redisTemplateService.stringGetStringByKey((Object)(memberCode + vo.getMemberInfoModel().getBrandId() + 2));
        MktRedPortRecordVO mktRedPortRecordVO = new MktRedPortRecordVO();
        mktRedPortRecordVO.setType(Integer.valueOf(2));
        mktRedPortRecordVO.setMemberCode(memberCode);
        mktRedPortRecordVO.setSysCompanyId(sysCompanyId);
        mktRedPortRecordVO.setSysBrandId(vo.getMemberInfoModel().getBrandId());
        if (StringUtils.isNotBlank((CharSequence)mktActivityId)) {
            mktRedPortRecordVO.setMktActivityId(Long.valueOf(mktActivityId));
        }
        mktRedPortRecordVO.setServiceStoreId(serviceStoreId);
        logger.info("updateRedPort={}", (Object)JSON.toJSONString((Object)mktRedPortRecordVO));
        this.activityRedPortServiceRpc.updateRedPort(mktRedPortRecordVO);
        return this.activityManualServiceRpc.getActivityByMemberInfo(vo);
    }

    @RequestMapping(value={"/onlyexecuteActivity"}, method={RequestMethod.POST})
    public ResponseData<ActivityManualVO> onlyexecuteActivity(ActivityManualVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        vo.getMemberInfoModel().setMemberCode(memberCode);
        return this.activityManualServiceRpc.executeActivity(vo);
    }

    @RequestMapping(value={"/getCouponListByCondition"}, method={RequestMethod.POST})
    public ResponseData getCouponListByCondition(CouponListByMemberCodeRequestVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        if (vo.getCouponStatus() == null) {
            responseData.setMessage("\u52b5\u7c7b\u578b\u672a\u8f93\u5165");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        vo.setMemberCode(memberCode);
        logger.info("\u6211\u7684\u4f18\u60e0\u5238\u67e5\u8be2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)vo));
        ResponseData couponListByMemeberCode = this.couponQueryServiceFeign.getCouponListByMemeberCode(vo);
        PageInfo couponListByMemeberCodeData = (PageInfo)couponListByMemeberCode.getData();
        couponListByMemeberCode.getData();
        PageInfo boPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)couponListByMemeberCodeData, (Object)boPageInfo);
        ArrayList<CouponEntityAndDefinitionBo> entityAndDefinitionBoList = new ArrayList<CouponEntityAndDefinitionBo>();
        for (CouponEntityAndDefinitionVO couponEntityAndDefinitionVO : couponListByMemeberCodeData.getList()) {
            CouponEntityAndDefinitionBo couponEntityAndDefinitionBo = new CouponEntityAndDefinitionBo();
            BeanUtils.copyProperties((Object)couponEntityAndDefinitionVO, (Object)couponEntityAndDefinitionBo);
            if (couponEntityAndDefinitionVO.getTransfer() == null) {
                couponEntityAndDefinitionBo.setOldMemberCode(null);
            } else if (couponEntityAndDefinitionVO.getTransfer().booleanValue()) {
                couponEntityAndDefinitionBo.setOldMemberCode(memberCode);
            }
            entityAndDefinitionBoList.add(couponEntityAndDefinitionBo);
        }
        boPageInfo.setList(entityAndDefinitionBoList);
        logger.info("\u6211\u7684\u4f18\u60e0\u5238\u51fa\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)boPageInfo));
        responseData.setData((Object)boPageInfo);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    @RequestMapping(value={"/findCouponDetailByCouponId"}, method={RequestMethod.POST})
    public ResponseData<CouponDetailResponseVO> findCouponDetailByCouponId(Long couponEntityId) {
        ResponseData responseData = new ResponseData();
        if (couponEntityId == null) {
            responseData.setMessage(" \u672a\u8f93\u5165\u8868 id");
            return responseData;
        }
        logger.info("\u4f18\u60e0\u5238\u8be6\u60c5={}", (Object)couponEntityId);
        ResponseData couponDetail = this.couponQueryServiceFeign.getCouponDetail(couponEntityId);
        Date validDateStart = ((CouponDetailResponseVO)couponDetail.getData()).getCouponEntityPO().getValidDateStart();
        Date validDateEnd = ((CouponDetailResponseVO)couponDetail.getData()).getCouponEntityPO().getValidDateEnd();
        ((CouponDetailResponseVO)couponDetail.getData()).getCouponDefinitionPO().setValidDateStart(validDateStart);
        ((CouponDetailResponseVO)couponDetail.getData()).getCouponDefinitionPO().setValidDateEnd(validDateEnd);
        logger.info("\u4f18\u60e0\u5238\u8be6\u60c5\u51fa\u53c2={}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)couponDetail.getData()));
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData(couponDetail.getData());
        return responseData;
    }

    @RequestMapping(value={"/onlineUse"}, method={RequestMethod.POST})
    public ResponseData<Object> findCouponDetailByCouponId(CouponOnlineUseRequestVO vo) {
        ResponseData responseData = new ResponseData();
        if (vo.getCouponCode() == null) {
            responseData.setMessage("\u672a\u8f93\u5165\u52b5 code");
            return responseData;
        }
        return this.couponServiceFeign.onlineUse(vo);
    }

    @RequestMapping(value={"/lock"}, method={RequestMethod.POST})
    public ResponseData<Object> lock(CouponEntityVO vo) {
        ResponseData responseData = new ResponseData();
        if (vo.getCouponCode() == null) {
            responseData.setMessage("\u672a\u8f93\u5165\u52b5 code");
            return responseData;
        }
        return this.couponServiceFeign.lock(vo);
    }

    @RequestMapping(value={"/unlock"}, method={RequestMethod.POST})
    public ResponseData<Object> unlock(CouponEntityVO vo) {
        ResponseData responseData = new ResponseData();
        if (vo.getCouponCode() == null) {
            responseData.setMessage("\u672a\u8f93\u5165\u52b5 code");
            return responseData;
        }
        return this.couponServiceFeign.unlock(vo);
    }
}

