/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.ActivityService;
import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.models.bo.AppletRefreshtoInterfaceBo;
import com.bizvane.appletservice.models.bo.OpenCardeModels;
import com.bizvane.appletservice.models.po.MemberSysAccountPO;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysCompanyPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.CompanyServiceRpc;
import com.bizvane.couponfacade.interfaces.CouponQueryServiceFeign;
import com.bizvane.couponfacade.interfaces.CouponServiceFeign;
import com.bizvane.couponfacade.models.vo.CouponDetailResponseVO;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.couponfacade.models.vo.CouponListByMemberCodeRequestVO;
import com.bizvane.couponfacade.models.vo.CouponOnlineUseRequestVO;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.bo.GetMemberDeductionInfo;
import com.bizvane.members.facade.service.api.IntegralChangeApiService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.members.facade.service.api.MiniProgramFocusOnService;
import com.bizvane.members.facade.service.api.MiniProgramOpenCardService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.members.facade.service.card.request.FocusOnRequestModel;
import com.bizvane.members.facade.service.card.request.IntegralChangeRequestModel;
import com.bizvane.members.facade.service.card.request.RequestOpenCardModel;
import com.bizvane.members.facade.service.card.response.FocusOnResponseModel;
import com.bizvane.members.facade.service.card.response.IntegralChangeResponseModel;
import com.bizvane.members.facade.service.card.response.ResponseOpenCardModel;
import com.bizvane.members.facade.service.electcard.MemberElectCardOpenCardApiService;
import com.bizvane.members.facade.service.qywxapi.CompanyMemberApiService;
import com.bizvane.members.facade.vo.MemberElectCardRequestVo;
import com.bizvane.members.facade.vo.MemberElectCardResponseVo;
import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.vo.ActivityManualVO;
import com.bizvane.mktcenterservice.models.vo.ActivityVO;
import com.bizvane.mktcenterservice.models.vo.ProbabilityVO;
import com.bizvane.mktcenterservice.rpc.ActivityEGServiceRpc;
import com.bizvane.mktcenterservice.rpc.ActivityManualServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.JWTUtil;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberWxStoreInterfce"})
public class MemberWxStoreInterfceController {
    @Autowired
    private ActivityManualServiceRpc activityManualServiceRpc;
    @Autowired
    private CouponQueryServiceFeign couponQueryServiceFeign;
    @Autowired
    private CouponServiceFeign couponServiceFeign;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private LoginService loginService;
    @Autowired
    private MiniProgramOpenCardService miniProgramOpenCardService;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private MiniProgramFocusOnService focusByMiniProgram;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private MemberElectCardOpenCardApiService memberElectCardOpenCardApiService;
    @Autowired
    private ActivityEGServiceRpc activityEGServiceRpc;
    @Autowired
    private IntegralChangeApiService integralChangeApiService;
    @Autowired
    private CompanyServiceRpc companyServiceRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private MemberInfoApiService MemberInfoApiService;
    @Autowired
    private CompanyMemberApiService companyMemberApiService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/getToken"})
    public ResponseData getToken(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String stageToken = request.getHeader("stageToken");
        if (stageToken == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6 token");
            responseData.setData(null);
            return responseData;
        }
        SysAccountPO sysAccountPO = (SysAccountPO)JWTUtil.unsign((String)stageToken, SysAccountPO.class);
        ResponseData companyById = this.companyServiceRpc.getCompanyById(sysAccountPO.getSysCompanyId());
        ResponseData brandByID = this.brandServiceRpc.getBrandByID(sysAccountPO.getBrandId());
        String brandName = ((SysBrandPo)brandByID.getData()).getBrandName();
        String brandCode = ((SysBrandPo)brandByID.getData()).getBrandCode();
        SysCompanyPo companyByIdData = (SysCompanyPo)companyById.getData();
        String companyName = companyByIdData.getCompanyName();
        MemberSysAccountPO memberSysAccountPO = new MemberSysAccountPO();
        memberSysAccountPO.setCompanyName(companyName);
        memberSysAccountPO.setSysCompanyId(sysAccountPO.getSysCompanyId());
        memberSysAccountPO.setBrandId(sysAccountPO.getBrandId());
        memberSysAccountPO.setName(sysAccountPO.getName());
        memberSysAccountPO.setCompanyCode(companyByIdData.getCompanyCode());
        memberSysAccountPO.setBrandName(brandName);
        memberSysAccountPO.setBrandCode(brandCode);
        if (sysAccountPO != null) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u7528\u6237\u5df2\u6709\u6743\u9650");
            responseData.setData((Object)memberSysAccountPO);
            return responseData;
        }
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage("\u7528\u6237\u6ca1\u6709\u6743\u9650");
        responseData.setData(null);
        return responseData;
    }

    @RequestMapping(value={"/queryLevelModel"}, method={RequestMethod.POST})
    public ResponseData<MbrLevelModel> queryLevelModel(Long mbrLevelId) {
        ResponseData responseData = new ResponseData();
        if (mbrLevelId == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u7b49\u7ea7id");
            return responseData;
        }
        logger.info("\u5fae\u5546\u57ce\u4f1a\u5458\u4f53\u7cfb\u5b9a\u4e49={}", (Object)mbrLevelId);
        return this.memberLevelApiService.queryLevelModel(mbrLevelId);
    }

    @RequestMapping(value={"/getMemberModelInfo"}, method={RequestMethod.POST})
    public ResponseData<MemberInfoModel> getMemberModelInfo(MemberInfoModel memberInfoModel) {
        return this.memberInfoApiService.getMemberModel(memberInfoModel);
    }

    @RequestMapping(value={"/getActivityByMemberInfo"}, method={RequestMethod.POST})
    public ResponseData<List<ActivityVO>> getActivityByMemberInfo(ActivityManualVO vo) {
        ResponseData responseData = new ResponseData();
        if (vo.getMemberInfoModel().getBrandId() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u54c1\u724cID");
            return responseData;
        }
        if (vo.getMemberInfoModel().getMemberCode() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u4f1a\u5458\u7f16\u53f7");
            return responseData;
        }
        if (vo.getActivityType() == null) {
            responseData.setMessage("\u6d3b\u52a8\u7c7b\u522b\u672a\u8f93\u5165");
            return responseData;
        }
        Long openCardStoreId = (Long)this.wxAppletApiService.getOpenCardStoreId(vo.getMemberInfoModel().getMemberCode()).getData();
        Long serviceStoreId = (Long)this.wxAppletApiService.getServiceStoreId(vo.getMemberInfoModel().getMemberCode()).getData();
        logger.info("\u9886\u52b5openCardStoreId={} , \u9886\u52b5serviceStoreId={}", (Object)openCardStoreId, (Object)serviceStoreId);
        vo.getMemberInfoModel().setServiceStoreId(serviceStoreId);
        vo.getMemberInfoModel().setOpenCardStoreId(openCardStoreId);
        return this.activityManualServiceRpc.getActivityByMemberInfo(vo);
    }

    @RequestMapping(value={"/onlyexecuteActivity"}, method={RequestMethod.POST})
    public ResponseData onlyexecuteActivity(ActivityManualVO vo) {
        logger.info("\u9886\u5238\u4e2d\u5fc3\u9886\u53d6={}", (Object)JSON.toJSONString((Object)vo));
        return this.activityManualServiceRpc.executeActivity(vo);
    }

    @RequestMapping(value={"/getCouponListByCondition"}, method={RequestMethod.POST})
    public ResponseData getCouponListByCondition(CouponListByMemberCodeRequestVO vo) {
        ResponseData responseData = new ResponseData();
        if (vo.getMemberCode() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u4f1a\u5458\u7f16\u53f7");
            return responseData;
        }
        if (vo.getPageNumber() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u9875\u6570");
            return responseData;
        }
        if (vo.getPageSize() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u4e00\u9875\u6570");
            return responseData;
        }
        if (vo.getCouponStatus() == null) {
            responseData.setMessage("\u52b5\u7c7b\u578b\u672a\u8f93\u5165");
            return responseData;
        }
        logger.info("\u6211\u7684\u4f18\u60e0\u5238\u67e5\u8be2={}", (Object)JSON.toJSONString((Object)vo));
        return this.couponQueryServiceFeign.getCouponListByMemeberCode(vo);
    }

    @RequestMapping(value={"/findCouponDetailByCouponId"}, method={RequestMethod.POST})
    public ResponseData<CouponDetailResponseVO> findCouponDetailByCouponId(Long couponEntityId) {
        ResponseData responseData = new ResponseData();
        if (couponEntityId == null) {
            responseData.setMessage(" \u52b5id");
            return responseData;
        }
        logger.info("\u4f18\u60e0\u5238\u8be6\u60c5={}", (Object)couponEntityId);
        return this.couponQueryServiceFeign.getCouponDetail(couponEntityId);
    }

    @RequestMapping(value={"/onlineUse"}, method={RequestMethod.POST})
    public ResponseData<Object> findCouponDetailByCouponId(CouponOnlineUseRequestVO vo) {
        ResponseData responseData = new ResponseData();
        if (vo.getCouponCode() == null) {
            responseData.setMessage("\u672a\u8f93\u5165\u52b5 code");
            return responseData;
        }
        logger.info("\u7ebf\u4e0a\u52b5\u6838\u9500={}", (Object)JSON.toJSONString((Object)vo));
        return this.couponServiceFeign.onlineUse(vo);
    }

    @RequestMapping(value={"/lock"}, method={RequestMethod.POST})
    public ResponseData<Object> lock(CouponEntityVO vo) {
        ResponseData responseData = new ResponseData();
        if (vo.getCouponCode() == null) {
            responseData.setMessage("\u672a\u8f93\u5165\u52b5 code");
            return responseData;
        }
        return this.couponServiceFeign.lock(vo);
    }

    @RequestMapping(value={"/unlock"}, method={RequestMethod.POST})
    public ResponseData<Object> unlock(CouponEntityVO vo) {
        ResponseData responseData = new ResponseData();
        if (vo.getCouponCode() == null) {
            responseData.setMessage("\u672a\u8f93\u5165\u52b5 code");
            return responseData;
        }
        return this.couponServiceFeign.unlock(vo);
    }

    @RequestMapping(value={"/refreshtoInterface"})
    public ResponseData<AppletRefreshtoInterfaceBo> refreshtoInterface(String appId) {
        return this.loginService.refreshtoInterface(appId);
    }

    @RequestMapping(value={"/openCardMenbr"})
    public ResponseData openCardMenbr(@RequestBody OpenCardeModels openCardeModels) {
        logger.info("\u8fdb\u5165\u65b9\u6cd5openCardMenbr={}", (Object)System.currentTimeMillis());
        ResponseData responseData = new ResponseData();
        logger.info("phone={} , appId={} , name={} , openId={} , unionId={},birthday={}", new Object[]{openCardeModels.getPhone(), openCardeModels.getAppId(), openCardeModels.getName(), openCardeModels.getOpenId(), openCardeModels.getUnionId(), openCardeModels.getBirthday()});
        RequestOpenCardModel requestOpenCardModel = new RequestOpenCardModel();
        requestOpenCardModel.setPhone(openCardeModels.getPhone());
        requestOpenCardModel.setOpenId(openCardeModels.getOpenId());
        requestOpenCardModel.setUnionId(openCardeModels.getUnionId());
        requestOpenCardModel.setAppId(openCardeModels.getAppId());
        requestOpenCardModel.setName(openCardeModels.getName());
        requestOpenCardModel.setBirthday(openCardeModels.getBirthday());
        FocusOnRequestModel focusOnRequestModel = new FocusOnRequestModel();
        focusOnRequestModel.setAppId(openCardeModels.getAppId());
        focusOnRequestModel.setOpenId(openCardeModels.getOpenId());
        focusOnRequestModel.setUnionId(openCardeModels.getUnionId());
        focusOnRequestModel.setWxNick(openCardeModels.getName());
        focusOnRequestModel.setMiniProgram(Integer.valueOf(2));
        logger.info("\u5173\u6ce8\u5165\u53c2={}", (Object)focusOnRequestModel.toString());
        FocusOnResponseModel focus = this.focusByMiniProgram.focusByMiniProgram(focusOnRequestModel);
        if (focus == null) {
            responseData.setMessage("\u5173\u6ce8\u5931\u8d25");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        logger.info("\u8c03\u7528\u5f00\u5361={}", (Object)System.currentTimeMillis());
        ResponseOpenCardModel responseOpenCardModel = this.miniProgramOpenCardService.openCard(requestOpenCardModel);
        logger.info("\u8c03\u7528miniProgramOpenCardService\u8fd4\u56de\u65f6\u95f4={}", (Object)System.currentTimeMillis());
        logger.info("\u5f00\u5361\u8fd4\u56de={}", (Object)responseOpenCardModel.toString());
        if (responseOpenCardModel != null) {
            Integer operateType = responseOpenCardModel.getOperateType();
            ResponseData wxPublicPOByAppId = this.wxPublicServiceFeign.getWxPublicPOByAppId(openCardeModels.getAppId());
            Long sysBrandId = ((WxPublicPO)wxPublicPOByAppId.getData()).getSysBrandId();
            logger.info("sysBrandId=======" + sysBrandId);
            this.activityService.executeActivity(sysBrandId, responseOpenCardModel.getMemberCode(), operateType);
            logger.info("\u8c03\u7528\u6d3b\u52a8\u5f00\u5361\u7ed3\u675f={}", (Object)System.currentTimeMillis());
            responseData.setMessage("\u5f00\u5361\u6210\u529f");
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)responseOpenCardModel.getPhone());
            logger.info("\u5f00\u5361\u6210\u529f\u8fd4\u56de={}", (Object)System.currentTimeMillis());
            return responseData;
        }
        responseData.setMessage("\u5f00\u5361\u5931\u8d25");
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        return responseData;
    }

    @RequestMapping(value={"/electronicMembershipCardOpenCard"})
    public ResponseData<MemberElectCardResponseVo> electronicMembershipCardOpenCard(MemberElectCardRequestVo memberElectCardRequestVo) {
        logger.info("memberElectCardRequestVo={}", (Object)JSON.toJSONString((Object)memberElectCardRequestVo));
        return this.memberElectCardOpenCardApiService.openCard(memberElectCardRequestVo);
    }

    @RequestMapping(value={"/searchActivityId"})
    public ResponseData<MktActivityPOWithBLOBs> searchActivityId(ProbabilityVO probabilityVO) {
        logger.info("searchActivityId={}", (Object)JSON.toJSONString((Object)probabilityVO));
        return this.activityEGServiceRpc.getActivityId(probabilityVO);
    }

    @RequestMapping(value={"/integralChangeOperate"})
    public ResponseData<IntegralChangeRequestModel> integralChangeOperate(IntegralChangeRequestModel integralChangeRequestModel) {
        ResponseData responseData = new ResponseData();
        logger.info("integralChangeOperate={}", (Object)JSON.toJSONString((Object)integralChangeRequestModel));
        String memberCode = integralChangeRequestModel.getMemberCode();
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u6ca1\u6709\u4f1a\u5458 Code");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        logger.info("============singleMemberModel=======:{}", (Object)JSON.toJSONString((Object)singleMemberModel));
        if (singleMemberModel.getData() == null) {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        Long brandId = ((MemberInfoModel)singleMemberModel.getData()).getBrandId();
        Long sysCompanyId = ((MemberInfoModel)singleMemberModel.getData()).getSysCompanyId();
        Integer countIntegral = ((MemberInfoModel)singleMemberModel.getData()).getCountIntegral();
        if (countIntegral == null || brandId == null || sysCompanyId == null) {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        logger.info("\u53d8\u66f4\u79ef\u5206:{}", (Object)integralChangeRequestModel.getChangeIntegral());
        logger.info("\u4f1a\u5458\u603b\u79ef\u5206:{}", (Object)countIntegral);
        if ("1".equals(integralChangeRequestModel.getChangeType()) && integralChangeRequestModel.getChangeIntegral() != null && integralChangeRequestModel.getChangeIntegral().compareTo(countIntegral) == 1) {
            responseData.setMessage("\u60a8\u7684\u79ef\u5206\u597d\u50cf\u4e0d\u591f\u4e86\u54e6");
            responseData.setCode(101);
            return responseData;
        }
        logger.info("brand={} ,sysCompanyId={}", (Object)brandId, (Object)sysCompanyId);
        integralChangeRequestModel.setBrandId(brandId);
        integralChangeRequestModel.setSysCompanyId(sysCompanyId);
        if ("1".equals(integralChangeRequestModel.getChangeType())) {
            integralChangeRequestModel.setBusinessType("30");
        } else if ("2".equals(integralChangeRequestModel.getChangeType())) {
            integralChangeRequestModel.setBusinessType("31");
        } else {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        IntegralChangeResponseModel integralChangeResponseModel = this.integralChangeApiService.integralChangeOperate(integralChangeRequestModel);
        Integer code = integralChangeResponseModel.getCode();
        String message = integralChangeResponseModel.getMessage();
        responseData.setCode(code.intValue());
        responseData.setMessage(message);
        logger.info("integralChangeResponseModel={}", (Object)code, (Object)message);
        return responseData;
    }

    @GetMapping(value={"/getMallBySysBrandId"})
    public ResponseData<String> getMallBySysBrandId(@RequestParam(value="sysBrandId") Long sysBrandId) {
        ResponseData result = new ResponseData();
        ResponseData data = this.wxPublicServiceFeign.getMallBySysBrandId(sysBrandId);
        WxPublicPO po = (WxPublicPO)data.getData();
        if (po != null) {
            result.setCode(SysResponseEnum.SUCCESS.getCode());
            result.setData((Object)po.getAppid());
            result.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return result;
        }
        result.setCode(SysResponseEnum.FAILED.getCode());
        result.setMessage("\u6ca1\u6709\u67e5\u5230\u8be5\u54c1\u724c\u7684\u5fae\u5546\u57ce\u6570\u636e");
        return result;
    }

    @GetMapping(value={"/getMemberDeductionInfo"})
    public ResponseData getMemberDeductionInfo(String memberCode) {
        ResponseData data = new ResponseData();
        HashMap<String, Number> map = new HashMap<String, Number>();
        ResponseData dataInfo = this.MemberInfoApiService.getMemberDeductionInfo(memberCode);
        GetMemberDeductionInfo info = (GetMemberDeductionInfo)dataInfo.getData();
        logger.info("\u4f1a\u5458\u4f59\u989d{},\u53ef\u7528\u79ef\u5206{},\u79ef\u5206\u62b5\u6263\u6bd4\u4f8b{}", new Object[]{info.getBalance(), info.getCountIntegral(), info.getDiscountRatio()});
        if (info != null) {
            map.put("balance", info.getBalance());
            map.put("countIntegral", info.getCountIntegral());
            map.put("discountRatio", info.getDiscountRatio());
            data.setData(map);
            data.setCode(SysResponseEnum.SUCCESS.getCode());
            data.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return data;
        }
        data.setCode(SysResponseEnum.FAILED.getCode());
        data.setMessage(SysResponseEnum.FAILED.getMessage());
        return data;
    }

    @PostMapping(value={"/updateMemberBalanceAndIntegral"})
    public ResponseData updateMemberBalanceAndIntegral(GetMemberDeductionInfo memberDeductionInfo) {
        logger.info("\u64cd\u4f5c\u4f1a\u5458\u79ef\u5206\u7684\u5165\u53c2:[{}]", JSON.toJSON((Object)memberDeductionInfo));
        ResponseData data = new ResponseData();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyymmddHHmmssSSS");
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberDeductionInfo.getMemberCode());
        MemberInfoModel singleMemberModel = (MemberInfoModel)this.memberInfoApiService.getSingleMemberModel(memberInfoModel).getData();
        if (singleMemberModel == null) {
            data.setCode(SysResponseEnum.FAILED.getCode());
            data.setMessage("\u4f1a\u5458\u4e0d\u5b58\u5728");
            return data;
        }
        BigDecimal balance = (BigDecimal)this.companyMemberApiService.queryMemberBalanceByMemberCode(memberDeductionInfo.getMemberCode()).getData();
        logger.info("\u53d8\u66f4\u79ef\u5206{},\u4f1a\u5458\u53ef\u7528\u79ef\u5206{}", (Object)memberDeductionInfo.getChangeIntegral(), (Object)singleMemberModel.getCountIntegral());
        logger.info("\u53d8\u66f4\u4f59\u989d{},\u4f1a\u5458\u53ef\u7528\u4f59\u989d{}", (Object)memberDeductionInfo.getBalance(), (Object)balance);
        if (memberDeductionInfo.getChangeType().equals("1")) {
            if (memberDeductionInfo.getChangeIntegral() != null && memberDeductionInfo.getChangeIntegral().compareTo(singleMemberModel.getCountIntegral()) == 1) {
                data.setMessage("\u60a8\u7684\u79ef\u5206\u597d\u50cf\u4e0d\u591f\u4e86\u54e6");
                data.setCode(101);
                return data;
            }
            if (memberDeductionInfo.getBalance() != null && memberDeductionInfo.getBalance().compareTo(balance) == 1) {
                data.setMessage("\u60a8\u7684\u4f59\u989d\u597d\u50cf\u4e0d\u591f\u4e86\u54e6");
                data.setCode(101);
                return data;
            }
        }
        memberDeductionInfo.setBrandId(singleMemberModel.getBrandId());
        memberDeductionInfo.setSysCompanyId(singleMemberModel.getSysCompanyId());
        memberDeductionInfo.setCardNo(singleMemberModel.getCardNo());
        memberDeductionInfo.setBusinessType("30");
        memberDeductionInfo.setChangeBills(sdf.format(new Date()) + (int)((Math.random() * 9.0 + 1.0) * 1000.0));
        memberDeductionInfo.setBrandCode(singleMemberModel.getOfflineBrandCode());
        logger.info("\u8bf7\u6c42\u53c2\u6570{}", (Object)memberDeductionInfo.toString());
        ResponseData result = this.MemberInfoApiService.updateMemberBalanceAndIntegral(memberDeductionInfo);
        data.setCode(result.getCode());
        data.setMessage(result.getMessage());
        return data;
    }
}

