/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.bizvane.appletservice.interfaces.IncreaseByTransferringService;
import com.bizvane.appletservice.models.bo.CouponDetailResponseBo;
import com.bizvane.couponfacade.interfaces.CouponServiceFeign;
import com.bizvane.couponfacade.models.vo.CouponEntityVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.catalina.servlet4preview.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/increaseByTransferring"}, method={RequestMethod.POST})
public class IncreaseByTransferringController {
    @Autowired
    private IncreaseByTransferringService increaseByTransferringService;
    @Autowired
    private CouponServiceFeign couponServiceFeign;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/increaseInSecurities"}, method={RequestMethod.POST})
    public ResponseData increaseInSecurities(String couponCode) {
        return this.couponServiceFeign.couponGiving(couponCode);
    }

    @RequestMapping(value={"/getIncreaseByTransferring"}, method={RequestMethod.POST})
    public ResponseData<CouponDetailResponseBo> increaseByTransferring(String couponCode, String transferMemberCode, HttpServletRequest request) {
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        return this.increaseByTransferringService.increaseByTransferring(couponCode, transferMemberCode, bizvaneSessionId);
    }

    @RequestMapping(value={"/transfer"}, method={RequestMethod.POST})
    public ResponseData transfer(CouponEntityVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        logger.info("transfer\u5165\u53c2=====" + vo.getOldMemberCode());
        if (vo.getCouponCode() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8bf7\u8f93\u5165\u52b5\u7f16\u53f7");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        vo.setNewMemberCode(memberCode);
        if (vo.getOldMemberCode() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8bf7\u8f93\u5165\u8001\u4f1a\u5458code");
            return responseData;
        }
        ResponseData coupon = this.couponServiceFeign.givenCoupon(vo);
        int couponCode = coupon.getCode();
        if (couponCode == 0) {
            Date newTimes = new Date();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            this.redisTemplateService.stringSetString((Object)(memberCode + vo.getCouponCode()), (Object)df.format(newTimes));
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u9886\u53d6\u6210\u529f");
            responseData.setData((Object)memberCode);
            return responseData;
        }
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage("\u975e\u5e38\u62b1\u6b49\u6b64\u5238\u5df2\u88ab\u4eba\u9886\u53d6");
        return responseData;
    }
}

