/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.SmashingGoldenEggsService;
import com.bizvane.appletservice.models.vo.SmashEggsVo;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.mktcenterservice.models.bo.ActivityGoldenStatisticsBo;
import com.bizvane.mktcenterservice.models.bo.MktActivityDetailAndPicture;
import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizeRecordPO;
import com.bizvane.mktcenterservice.models.vo.ProbabilityVO;
import com.bizvane.mktcenterservice.rpc.ActivityEGServiceRpc;
import com.bizvane.mktcenterservice.rpc.ActivityGoldenStatisticsServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SmashingGoldenEggsServiceImpl
implements SmashingGoldenEggsService {
    @Autowired
    private ActivityEGServiceRpc activityEGServiceRpc;
    @Autowired
    private ActivityGoldenStatisticsServiceRpc activityGoldenStatisticsServiceRpc;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Value(value="${qiniu.domain}")
    private String DOMAINNAME;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    public ResponseData<List<MktActivityPrizeRecordPO>> wheelPlanting(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        return this.getEGPrizeRecordList(mktActivityPrizeRecordPO);
    }

    public ResponseData records(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        return this.getEGPrizeRecordList(mktActivityPrizeRecordPO);
    }

    public ResponseData<MktActivityPOWithBLOBs> details(ProbabilityVO probabilityVO) {
        ResponseData responseData = new ResponseData();
        logger.info("activityEGServiceRpc.getMktActivityPOWithBLOBs\u5165\u53c2={}", (Object)JSON.toJSONString((Object)probabilityVO));
        ResponseData mktActivityPOWithBLOBs = this.activityEGServiceRpc.getMktActivityPOWithBLOBs(probabilityVO);
        MktActivityDetailAndPicture activityPOWithBLOBsData = (MktActivityDetailAndPicture)mktActivityPOWithBLOBs.getData();
        logger.info("activityPOWithBLOBsData={}", (Object)JSON.toJSONString((Object)activityPOWithBLOBsData));
        activityPOWithBLOBsData.setActivityDetailImg(this.judHttp(activityPOWithBLOBsData.getActivityDetailImg()));
        activityPOWithBLOBsData.setPageBackground(this.judHttp(activityPOWithBLOBsData.getPageBackground()));
        activityPOWithBLOBsData.setActivityGameTitile(this.judHttp(activityPOWithBLOBsData.getActivityGameTitile()));
        activityPOWithBLOBsData.setActivityGameBackground(this.judHttp(activityPOWithBLOBsData.getActivityGameBackground()));
        activityPOWithBLOBsData.setButtonGameBackground(this.judHttp(activityPOWithBLOBsData.getButtonGameBackground()));
        logger.info("triesLimit={}", (Object)activityPOWithBLOBsData.getTriesLimit());
        Integer triesLimit = activityPOWithBLOBsData.getTriesLimit();
        probabilityVO.setShareNum(activityPOWithBLOBsData.getShareNum());
        probabilityVO.setTriesLimit(triesLimit);
        try {
            logger.info("activityEGServiceRpc.residueMemberNumber\u5165\u53c2={}", (Object)JSON.toJSONString((Object)probabilityVO));
            ResponseData integerResponseData = this.activityEGServiceRpc.residueMemberNumber(probabilityVO);
            Map dataMap = (Map)integerResponseData.getData();
            logger.info("integerResponseData={}", integerResponseData.getData());
            activityPOWithBLOBsData.setTriesLimit((Integer)dataMap.get("triesLimit"));
            activityPOWithBLOBsData.setShareNum((Integer)dataMap.get("shareNum"));
        }
        catch (ParseException e) {
            logger.info("ParseException={}", (Object)JSON.toJSONString((Object)e));
        }
        responseData.setData((Object)activityPOWithBLOBsData);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public String judHttp(String url) {
        if (url != null && url.indexOf("https") == -1) {
            url = this.DOMAINNAME + url;
        }
        return url;
    }

    public ResponseData smashEggs(ProbabilityVO probabilityVO) throws ParseException, IOException {
        ResponseData responseData = new ResponseData();
        logger.info("smashEggs={}", (Object)JSON.toJSONString((Object)probabilityVO));
        if (probabilityVO.getActivityType() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("activityType\u4e3a\u7a7a");
            responseData.setCode(100);
            return responseData;
        }
        ResponseData stringResponseData = this.activityEGServiceRpc.doEggFrenzy(probabilityVO);
        logger.info("stringResponseData={}", (Object)JSON.toJSONString((Object)stringResponseData));
        if (stringResponseData.getCode() == 107) {
            return stringResponseData;
        }
        if (((String)stringResponseData.getData()).equals("106")) {
            JSONObject parseObject = JSON.parseObject((String)stringResponseData.getMessage());
            String imageUrl = parseObject.getString("imageUrl");
            String mktActivityPrizeRecordId = parseObject.getString("mktActivityPrizeRecordId");
            String awadType = parseObject.getString("awadType");
            SmashEggsVo smashEggsVo = new SmashEggsVo();
            URL url = new URL(this.qiNiuConfig.getDomain() + imageUrl);
            InputStream is = url.openConnection().getInputStream();
            String newKey = QiNiuUtil.upload((InputStream)is, (String)(UUID.randomUUID().toString().replace("-", "") + ".png"));
            logger.info("\u4e03\u725b\u8fd4\u56de\u5730\u5740:{}", (Object)newKey);
            smashEggsVo.setImageUrl(newKey);
            smashEggsVo.setMktActivityPrizeRecordId(mktActivityPrizeRecordId);
            smashEggsVo.setAwadType((String)ObjectUtils.defaultIfNull((Object)awadType, (Object)"0"));
            responseData.setData((Object)smashEggsVo);
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(Integer.valueOf((String)stringResponseData.getData()).intValue());
        } else {
            responseData.setData((Object)stringResponseData.getMessage());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(Integer.valueOf((String)stringResponseData.getData()).intValue());
        }
        return responseData;
    }

    public ResponseData<Map<String, Integer>> share(ProbabilityVO probabilityVO) throws ParseException {
        logger.info("share={}", (Object)JSON.toJSONString((Object)probabilityVO));
        return this.activityEGServiceRpc.addMemberNumber(probabilityVO);
    }

    public ResponseData<Integer> openShare(ActivityGoldenStatisticsBo goldenStatisticsBo) {
        logger.info("openShare={}", (Object)JSON.toJSONString((Object)goldenStatisticsBo));
        return this.activityGoldenStatisticsServiceRpc.goldenStatisticsData(goldenStatisticsBo);
    }

    private ResponseData<List<MktActivityPrizeRecordPO>> getEGPrizeRecordList(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        logger.info("mktActivityPrizeRecordPO={}", (Object)JSON.toJSONString((Object)mktActivityPrizeRecordPO));
        ResponseData recordList = this.activityEGServiceRpc.getEGPrizeRecordList(mktActivityPrizeRecordPO);
        List data = (List)recordList.getData();
        if (CollectionUtils.isEmpty((Collection)data)) {
            return recordList;
        }
        List collect = data.parallelStream().limit(20L).collect(Collectors.toList());
        recordList.setData(collect);
        return recordList;
    }
}

