/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.interfaces.MemberLotteryService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizePO;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizeRecordPO;
import com.bizvane.mktcenterservice.models.vo.ActivityPrizeBO;
import com.bizvane.mktcenterservice.models.vo.JudgeMemberVO;
import com.bizvane.mktcenterservice.rpc.ActivityCommonServiceRpc;
import com.bizvane.mktcenterservice.rpc.ActivityPrizeServiceRpc;
import com.bizvane.mktcenterservice.rpc.ActivityServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MemberLotteryServiceImpl
implements MemberLotteryService {
    @Autowired
    private ActivityPrizeServiceRpc activityPrizeServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private ActivityServiceRpc activityServiceRpc;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private ActivityCommonServiceRpc activityCommonServiceRpc;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    public ResponseData<MktActivityPrizeRecordPO> winningRecord(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        return this.record(mktActivityPrizeRecordPO);
    }

    public ResponseData<ActivityPrizeBO> activityRules(String activePriceCode) {
        ResponseData responseData = new ResponseData();
        ActivityPrizeBO rules = this.rules(activePriceCode);
        if (rules == null) {
            responseData.setMessage("\u65e0\u89c4\u5219");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
        }
        MktActivityPOWithBLOBs activityPO = rules.getActivityPO();
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)activityPO.getActivityRule());
        return responseData;
    }

    public ResponseData lotteryDoIng(String activePriceCode, String memberCode) {
        return this.activityPrizeServiceRpc.executeActivityPrize(activePriceCode, memberCode);
    }

    public ResponseData<ActivityPrizeBO> theWayToAcquireIntegral(String activePriceCode) {
        ResponseData responseData = new ResponseData();
        ActivityPrizeBO rules = this.rules(activePriceCode);
        if (rules == null) {
            responseData.setMessage("\u65e0\u79ef\u5206\u83b7\u53d6\u9014\u5f84");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
        }
        MktActivityPOWithBLOBs activityPO = rules.getActivityPO();
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)activityPO.getActivityInfo());
        return responseData;
    }

    public ResponseData<ActivityPrizeBO> luckDraw(String activePriceCode) {
        ResponseData responseData = new ResponseData();
        ActivityPrizeBO rules = this.rules(activePriceCode);
        if (rules == null) {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
        }
        List prizePOList = rules.getActivityPrizePOList();
        for (MktActivityPrizePO mktActivityPrizePO : prizePOList) {
            if (mktActivityPrizePO.getPrizeType() != 50) continue;
            mktActivityPrizePO.setPrizeName("\u8c22\u8c22\u60e0\u987e");
        }
        Collections.sort(prizePOList, new /* Unavailable Anonymous Inner Class!! */);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)rules);
        return responseData;
    }

    public ResponseData<MktActivityPrizeRecordPO> rotation(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        return this.record(mktActivityPrizeRecordPO);
    }

    public ResponseData countIntegral(String memberCode) {
        Integer integer = this.countIntegrals(memberCode);
        logger.info("\u6211\u7684\u79ef\u5206\u4f1a\u5458\u4fe1\u606f={}", (Object)JSON.toJSONString((Object)memberCode));
        ResponseData responseData = new ResponseData();
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)integer);
        return responseData;
    }

    public ResponseData scanningLottery(String memberCode, String activityCode) {
        logger.info("\u626b\u7801\u62bd\u5956\u5165\u53c2={}", (Object)JSON.toJSONString((Object)memberCode), (Object)JSON.toJSONString((Object)activityCode));
        ResponseData responseData = new ResponseData();
        ResponseData storeId = this.wxAppletApiService.getServiceStoreId(memberCode);
        JudgeMemberVO judgeMemberVO = new JudgeMemberVO();
        judgeMemberVO.setActivityCode(activityCode);
        judgeMemberVO.setMemberCode(memberCode);
        if (storeId != null) {
            Long serviceStoreId = (Long)storeId.getData();
            if (serviceStoreId == null) {
                responseData.setMessage("\u8bf7\u68c0\u67e5\u60a8\u7684\u8d26\u53f7\uff0c\u670d\u52a1\u95e8\u5e97\u672a\u67e5\u5230");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                return responseData;
            }
            Integer integer = new Long(serviceStoreId).intValue();
            judgeMemberVO.setStoreId(integer);
        }
        ResponseData judgeMember = this.activityServiceRpc.judgeMember(judgeMemberVO);
        logger.info("\u626b\u7801\u62bd\u5956\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)judgeMember.getData()));
        if (judgeMember != null) {
            Integer data = (Integer)judgeMember.getData();
            if (data == 100) {
                responseData.setMessage("\u53c2\u6570\u4e0d\u5408\u683c");
                responseData.setCode(100);
            }
            if (data == 101) {
                responseData.setMessage("\u6d3b\u52a8\u5df2\u8fc7\u671f");
                responseData.setCode(0);
                responseData.setData((Object)"101");
            }
            if (data == 102) {
                responseData.setMessage("\u4f1a\u5458\u4e0d\u5728\u8303\u56f4\u5185");
                responseData.setCode(0);
                responseData.setData((Object)"102");
            }
            if (data == 103) {
                responseData.setMessage("\u6d3b\u52a8\u8fd8\u672a\u5f00\u59cb");
                responseData.setCode(0);
                responseData.setData((Object)"103");
            }
            if (data == 0) {
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setData((Object)"0");
            }
        } else {
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        logger.info("\u626b\u7801\u62bd\u5956\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)judgeMember.getData()), (Object)JSON.toJSONString((Object)responseData.getMessage()));
        return responseData;
    }

    public void addressLotteryRecord(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        this.activityCommonServiceRpc.addPrizeAddress(mktActivityPrizeRecordPO);
    }

    private ResponseData<MktActivityPrizeRecordPO> record(MktActivityPrizeRecordPO mktActivityPrizeRecordPO) {
        logger.info("\u62bd\u5956\u8bb0\u5f55\u5165\u53c2={}", (Object)JSON.toJSONString((Object)mktActivityPrizeRecordPO));
        ResponseData responseData = new ResponseData();
        ResponseData recordListRpc = this.activityPrizeServiceRpc.getPrizeRecordListRpc(mktActivityPrizeRecordPO);
        logger.info("\u62bd\u5956\u8bb0\u5f55\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)recordListRpc.getData()));
        List mktActivityPrizeRecordPOList = (List)recordListRpc.getData();
        List recordPOListSubList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)mktActivityPrizeRecordPOList)) {
            recordPOListSubList = mktActivityPrizeRecordPOList.size() > 30 ? ((List)recordListRpc.getData()).subList(0, 29) : mktActivityPrizeRecordPOList;
        }
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData(recordPOListSubList);
        return responseData;
    }

    private ActivityPrizeBO rules(String activePriceCode) {
        logger.info("\u62bd\u5956\u8be6\u60c5={}", (Object)JSON.toJSONString((Object)activePriceCode));
        ResponseData selectPrizeList = this.activityPrizeServiceRpc.selectPrizeList(activePriceCode);
        logger.info("\u62bd\u5956\u8be6\u60c5={}", (Object)JSON.toJSONString((Object)selectPrizeList.getData()));
        return (ActivityPrizeBO)selectPrizeList.getData();
    }

    private Integer countIntegrals(String memberCode) {
        ResponseData countIntegralByMemberCode = this.memberInfoApiService.getCountIntegralByMemberCode(memberCode);
        logger.info("\u79ef\u5206={}", (Object)JSON.toJSONString((Object)countIntegralByMemberCode.getData()));
        return (Integer)countIntegralByMemberCode.getData();
    }
}

