/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.models.bo.AppletLoginBo;
import com.bizvane.appletservice.models.bo.AppletRefreshtoInterfaceBo;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.messagefacade.interfaces.SendCommonMessageFeign;
import com.bizvane.messagefacade.models.vo.SysSmsConfigVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateService;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.JWTUtil;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatfacade.interfaces.WxMiniprgmServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.google.gson.Gson;
import io.jsonwebtoken.Claims;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements LoginService {
    @Autowired
    private SendCommonMessageFeign sendCommonMessageFeign;
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private RedisTemplateService<String, String> redisTemplateService;
    @Autowired
    private WxMiniprgmServiceFeign wxMiniprgmServiceFeign;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    public ResponseData<Map<String, Object>> login(AppletLoginBo bo) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        if (StringUtils.isBlank((CharSequence)bo.getPhone())) {
            responseData.setMessage("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)bo.getVerificationCode())) {
            responseData.setMessage("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        String redisVerificationCode = (String)this.redisTemplateService.stringGetStringByKey((Object)bo.getPhone());
        System.out.println("redisVerificationCode:" + redisVerificationCode);
        if (!bo.getVerificationCode().equals(redisVerificationCode)) {
            responseData.setMessage("\u9a8c\u8bc1\u7801\u9519\u8bef!");
            return responseData;
        }
        String memberCode = "2";
        ResponseData memberCardLevelModelData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        MemberCardLevelModel memberCardLevelModel = (MemberCardLevelModel)memberCardLevelModelData.getData();
        String token = JWTUtil.sign((Object)memberCardLevelModel, (long)JWTUtil.TTLMILLIS.intValue());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("token", token);
        map.put("memberCardLevelModel", (String)memberCardLevelModel);
        responseData.setData(map);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<Integer> sendVerificationCode(String phone, String sysBrandId) {
        int count;
        ResponseData responseData = new ResponseData();
        logger.info("phone==========" + phone);
        SysSmsConfigVO sysSmsConfigVO = new SysSmsConfigVO();
        sysSmsConfigVO.setChannelName("moments3.4");
        sysSmsConfigVO.setChannelAccount("JJ0253");
        sysSmsConfigVO.setChannelPassword("513678");
        sysSmsConfigVO.setChannelService("http://TSN19.800CT.COM:8901/MWGate/wmgw.asmx/MongateSendSubmit");
        sysSmsConfigVO.setPhone(phone);
        if (StringUtils.isNotBlank((CharSequence)sysBrandId)) {
            sysSmsConfigVO.setSysBrandId(Long.valueOf(sysBrandId));
        }
        String redisVerificationCode = (String)this.redisTemplateService.stringGetStringByKey((Object)phone);
        String authcode = "";
        if (StringUtils.isBlank((CharSequence)redisVerificationCode)) {
            Random r = new Random();
            Double d = r.nextDouble();
            authcode = d.toString().substring(3, 9);
        } else {
            authcode = redisVerificationCode;
        }
        String text = "\u60a8\u7684\u9a8c\u8bc1\u7801\u4e3a\uff1a";
        text = text + authcode + "\u3002\u9a8c\u8bc1\u780160\u79d2\u5185\u6709\u6548";
        sysSmsConfigVO.setMsgContent(text);
        String intCount = (String)this.redisTemplateService.stringGetStringByKey((Object)("intCount" + phone));
        if (StringUtils.isBlank((CharSequence)intCount)) {
            intCount = "0";
        }
        if ("50".equals(intCount = String.valueOf(count = Integer.valueOf(intCount) + 1))) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u4eca\u65e5\u9a8c\u8bc1\u7801\u53d1\u9001\u6b21\u6570\u5df2\u8d85\u9650\u5236");
            return responseData;
        }
        logger.info("sysSmsConfigVO={}", (Object)JSON.toJSONString((Object)sysSmsConfigVO));
        Integer i = this.sendCommonMessageFeign.sendSmg(sysSmsConfigVO).getCode();
        logger.info("i========" + i);
        if (i == 0) {
            this.redisTemplateService.stringSetValueAndExpireTime((Object)phone, (Object)authcode, 60000L);
            this.redisTemplateService.stringSetValueAndExpireTime((Object)("intCount" + phone), (Object)intCount, 86400000L);
            logger.info("\u60a8\u7684\u9a8c\u8bc1\u7801\u4e3a========" + authcode);
            responseData.setData((Object)0);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u53d1\u9001\u6210\u529f!");
        } else {
            responseData.setData((Object)"-1");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u53d1\u9001\u5931\u8d25!");
        }
        return responseData;
    }

    public ResponseData<Integer> loginToken(String token) {
        ResponseData responseData = new ResponseData();
        if (token == null) {
            responseData.setMessage("token \u4e3a\u7a7a");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        Gson gson = new Gson();
        Claims claims = JWTUtil.parseJWT((String)token);
        String subject = claims.getSubject();
        MemberCardLevelModel memberCardLevelModel = (MemberCardLevelModel)gson.fromJson(subject, MemberCardLevelModel.class);
        if (memberCardLevelModel == null) {
            responseData.setMessage("token \u9a8c\u8bc1\u5931\u8d25");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage("\u9a8c\u8bc1\u6210\u529f");
        responseData.setData((Object)memberCardLevelModel);
        return responseData;
    }

    public ResponseData<AppletRefreshtoInterfaceBo> refreshtoInterface(String appId) {
        ResponseData responseData = new ResponseData();
        ResponseData otherMiniprgm = this.wxMiniprgmServiceFeign.getJumpMiniprgm(appId);
        AppletRefreshtoInterfaceBo appletRefreshtoInterfaceBo = new AppletRefreshtoInterfaceBo();
        String personalAppId = ((WxPublicPO)otherMiniprgm.getData()).getAppid();
        logger.info("\u8fd4\u56de\u5fae\u5546\u57ceappid={}", (Object)personalAppId);
        String URL2 = "/pages/entry/main";
        appletRefreshtoInterfaceBo.setAppId(personalAppId);
        appletRefreshtoInterfaceBo.setUrl(URL2);
        if (appletRefreshtoInterfaceBo == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)appletRefreshtoInterfaceBo);
        return responseData;
    }
}

