/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.bizvane.appletservice.interfaces.WxPayService;
import com.bizvane.appletservice.models.vo.CreateRechargeVO;
import com.bizvane.centerstageservice.models.po.WxPayConfigPo;
import com.bizvane.centerstageservice.rpc.MbrRechargeServiceRpc;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5145\u503c", tags={"\u5fae\u4fe1\u5145\u503c"})
@RestController
@RequestMapping(value={"/wxPay"})
public class WxPayController {
    private static final Logger logger = LoggerFactory.getLogger(WxPayController.class);
    @Autowired
    private WxPayService wxPayService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MbrRechargeServiceRpc mbrRechargeServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;

    @ApiOperation(value="\u521b\u5efa\u5145\u503c\u5355", notes="\u521b\u5efa\u5145\u503c\u5355")
    @PostMapping(value={"/createRecharge"})
    public ResponseData createRecharge(CreateRechargeVO vo, HttpServletRequest request) {
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        ResponseData responseData = new ResponseData();
        if (bizvaneSessionId == null) {
            responseData.setMessage("bizvaneSessionId\u6ca1\u6709");
            responseData.setCode(100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        if ("0".equals(vo.getMoney()) || StringUtils.isBlank((CharSequence)vo.getMoney())) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u6b63\u786e\u91d1\u989d");
            responseData.setCode(100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel model = (MemberInfoModel)singleMemberModel.getData();
        if (model == null) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        WxPayConfigPo po = new WxPayConfigPo();
        po.setSysCompanyId(model.getSysCompanyId());
        po.setSysBrandId(model.getBrandId());
        ResponseData data = this.mbrRechargeServiceRpc.getWxPayConfigRpc(po);
        WxPayConfigPo wxConfig = (WxPayConfigPo)data.getData();
        if (wxConfig == null) {
            responseData.setMessage("\u5546\u6237\u4e0d\u5b58\u5728");
            responseData.setCode(100);
            return responseData;
        }
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        String appId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        vo.setOpenid(openId);
        vo.setAppId(appId);
        vo.setMemberCode(memberCode);
        logger.info("\u5145\u503c\u5165\u53c2={} , openId={} , appId={}", new Object[]{vo.toString(), openId, appId});
        Map map = this.wxPayService.createRecharge(vo, wxConfig);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)map);
        return responseData;
    }

    @PostMapping(value={"/callback"})
    public String callback(HttpServletRequest req, HttpServletResponse res) {
        return this.wxPayService.callback(req, res);
    }
}

