/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.SmashingGoldenEggsService;
import com.bizvane.appletserviceimpl.utils.UUIDUtils;
import com.bizvane.members.facade.enums.BusinessTypeEnum;
import com.bizvane.mktcenterservice.models.bo.ActivityGoldenStatisticsBo;
import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizeRecordPO;
import com.bizvane.mktcenterservice.models.vo.ProbabilityVO;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/smashingGoldenEggs"}, method={RequestMethod.POST})
public class SmashingGoldenEggsController {
    @Autowired
    private SmashingGoldenEggsService smashingGoldenEggsService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/wheelPlanting"}, method={RequestMethod.POST})
    ResponseData<List<MktActivityPrizeRecordPO>> wheelPlanting(MktActivityPrizeRecordPO mktActivityPrizeRecordPO, HttpServletRequest request) {
        List recordeList;
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("bizvaneSessionId={}", (Object)bizvaneSessionId);
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData prizeRecords = this.smashingGoldenEggsService.wheelPlanting(mktActivityPrizeRecordPO);
        if (((List)prizeRecords.getData()).size() > 0 && ((List)prizeRecords.getData()).size() >= 20) {
            recordeList = ((List)prizeRecords.getData()).subList(0, 20);
            prizeRecords.setData((Object)recordeList);
        }
        if (((List)prizeRecords.getData()).size() > 0 && ((List)prizeRecords.getData()).size() <= 20) {
            recordeList = (List)prizeRecords.getData();
            prizeRecords.setData((Object)recordeList);
        }
        if (((List)prizeRecords.getData()).size() == 0) {
            prizeRecords.setData(null);
        }
        return prizeRecords;
    }

    @RequestMapping(value={"/records"}, method={RequestMethod.POST})
    ResponseData<List<MktActivityPrizeRecordPO>> records(MktActivityPrizeRecordPO mktActivityPrizeRecordPO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("bizvaneSessionId={}", (Object)bizvaneSessionId);
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        mktActivityPrizeRecordPO.setMemberCode(memberCode);
        return this.smashingGoldenEggsService.records(mktActivityPrizeRecordPO);
    }

    @RequestMapping(value={"/details"}, method={RequestMethod.POST})
    ResponseData<MktActivityPOWithBLOBs> details(ProbabilityVO probabilityVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("bizvaneSessionId={}", (Object)bizvaneSessionId);
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            String uuid = UUIDUtils.getUUID();
            logger.info("uuid={}", (Object)uuid);
            JSONObject jsonObject = new JSONObject();
            BusinessTypeEnum smashEggActivity = BusinessTypeEnum.SMASH_EGG_ACTIVITY;
            String activityCode = smashEggActivity.getCode();
            logger.info("details+activityCode={}", (Object)activityCode);
            jsonObject.put("activityType", (Object)activityCode);
            jsonObject.put("mktActivityId", (Object)probabilityVO.getMktActivityId());
            this.redisTemplateService.stringSetValueAndExpireTime((Object)uuid, (Object)jsonObject.toString(), 86400000L);
            String getStringByKey = (String)this.redisTemplateService.stringGetStringByKey((Object)uuid);
            logger.info("getStringByKey+UUID={}", (Object)getStringByKey);
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            responseData.setData((Object)uuid);
            return responseData;
        }
        probabilityVO.setMemberCode(memberCode);
        return this.smashingGoldenEggsService.details(probabilityVO);
    }

    @RequestMapping(value={"/smashEggs"}, method={RequestMethod.POST})
    ResponseData smashEggs(ProbabilityVO probabilityVO, HttpServletRequest request) throws ParseException, IOException {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("bizvaneSessionId={}", (Object)bizvaneSessionId);
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            memberCode = probabilityVO.getMemberCode();
        }
        this.redisTemplateService.stringSetString((Object)(bizvaneSessionId + "memberCode"), (Object)memberCode);
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        probabilityVO.setMemberCode(memberCode);
        return this.smashingGoldenEggsService.smashEggs(probabilityVO);
    }

    @RequestMapping(value={"/share"}, method={RequestMethod.POST})
    ResponseData<Map<String, Integer>> share(ProbabilityVO probabilityVO, HttpServletRequest request) throws ParseException {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("bizvaneSessionId={}", (Object)bizvaneSessionId);
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        probabilityVO.setMemberCode(memberCode);
        return this.smashingGoldenEggsService.share(probabilityVO);
    }

    @RequestMapping(value={"/openShare"}, method={RequestMethod.POST})
    ResponseData<Integer> openShare(ActivityGoldenStatisticsBo goldenStatisticsBo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        this.smashingGoldenEggsService.openShare(goldenStatisticsBo);
        return responseData;
    }
}

