/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.bizvane.appletservice.interfaces.ResourcesService;
import com.bizvane.appletservice.models.po.AppletBrandThemePO;
import com.bizvane.appletservice.models.po.AppletResourcesPO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/resources"})
public class ResourcesController {
    @Autowired
    private ResourcesService resourcesService;

    @RequestMapping(value={"/getResources"})
    public ResponseData<List<AppletResourcesPO>> getResources(AppletResourcesPO po) {
        return this.resourcesService.getResources(po);
    }

    @RequestMapping(value={"/themeResources"})
    public ResponseData<String> themeResources(Long sysBrandId) {
        ResponseData responseData = new ResponseData();
        if (sysBrandId == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u672a\u83b7\u53d6\u5230\u54c1\u724c id");
            return responseData;
        }
        ResponseData themeResources = this.resourcesService.themeResources(sysBrandId);
        for (AppletBrandThemePO appletBrandThemePO : (List)themeResources.getData()) {
            String themeStyle = appletBrandThemePO.getThemeStyle();
            responseData.setData((Object)themeStyle);
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        }
        return responseData;
    }
}

