/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.interfaces.PaymentPasswordService;
import com.bizvane.appletservice.models.vo.PaymentPasswordVo;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/paymentPassword"}, method={RequestMethod.POST})
public class PaymentPasswordController {
    @Autowired
    private PaymentPasswordService paymentPasswordService;
    @Autowired
    private LoginService loginService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/maintainPassword"}, method={RequestMethod.POST})
    public ResponseData<String> maintainPassword(PaymentPasswordVo paymentPasswordVo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("bizvaneSessionId={}", (Object)bizvaneSessionId);
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        paymentPasswordVo.setMemberCode(memberCode);
        String appId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        if (StringUtils.isBlank((CharSequence)appId)) {
            responseData.setMessage("appId \u6307\u6807\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        String sysBrandId = (String)this.redisTemplateService.stringGetStringByKey((Object)("sysBrandId" + bizvaneSessionId));
        paymentPasswordVo.setAppId(appId);
        logger.info("paymentPasswordVo={}", (Object)JSON.toJSONString((Object)paymentPasswordVo));
        paymentPasswordVo.setBrandId(Long.valueOf(sysBrandId));
        return this.paymentPasswordService.maintainPassword(paymentPasswordVo);
    }

    @RequestMapping(value={"/sendVerificationCode"})
    public ResponseData<Integer> sendVerificationCode(String phone, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("bizvaneSessionId\u6ca1\u6709");
            responseData.setCode(100);
            return responseData;
        }
        String sysBrandId = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "sysBrandId"));
        if (StringUtils.isBlank((CharSequence)sysBrandId)) {
            responseData.setMessage("\u54c1\u724c\u6307\u6807\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        return this.loginService.sendVerificationCode(phone, sysBrandId);
    }

    @RequestMapping(value={"/searchPhone"})
    public ResponseData<Integer> searchPhone(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        logger.info("bizvaneSessionId={}", (Object)bizvaneSessionId);
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.paymentPasswordService.searchPhone(memberCode);
    }

    @RequestMapping(value={"/deletePhoneCode"})
    public ResponseData<Integer> deletePhoneCode(String phone) {
        ResponseData responseData = new ResponseData();
        this.redisTemplateService.deleteFromRedis((Object)(phone + "intCount_new"));
        return responseData;
    }
}

