/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.internal.org.apache.commons.lang3.ObjectUtils;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.models.bo.OrderDetailEvaluateBo;
import com.bizvane.appletservice.models.bo.OrderEvaluateBo;
import com.bizvane.appletservice.models.bo.OrderEvaluateVo;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.QiNiuUtil;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.OrderDetailEvaluateModel;
import com.bizvane.members.facade.models.OrderEvaluateModel;
import com.bizvane.members.facade.models.OrderModel;
import com.bizvane.members.facade.service.api.MemberOrderApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.members.facade.vo.OrderApiVo;
import com.bizvane.mktcenterservice.rpc.ActivityServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/menberOderby"})
public class MenberOderbyController {
    @Autowired
    private MemberOrderApiService memberOrderApiService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private ActivityServiceRpc activityServiceRpc;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/queryMemberOrderList"}, method={RequestMethod.POST})
    public ResponseData<PageInfo<OrderModel>> queryMemberOrderList(OrderApiVo orderModel, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        orderModel.setMemberCode(memberCode);
        if (orderModel.getMemberCode() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u4f1a\u5458\u7f16\u53f7");
            return responseData;
        }
        logger.info("\u4f1a\u5458\u8ba2\u5355\u5217\u8868={}", (Object)JSON.toJSONString((Object)orderModel));
        return this.memberOrderApiService.queryOrderList(orderModel);
    }

    @RequestMapping(value={"/queryOrderInfo"}, method={RequestMethod.POST})
    public ResponseData<OrderModel> queryOrderInfo(OrderModel orderModel, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        if (orderModel.getOrderNo() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u8ba2\u5355\u7f16\u53f7");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        String sysBrandId = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "sysBrandId"));
        if (StringUtils.isBlank((CharSequence)sysBrandId)) {
            responseData.setMessage("\u54c1\u724c\u6307\u6807\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        orderModel.setBrandId(Long.valueOf(sysBrandId));
        orderModel.setMemberCode(memberCode);
        logger.info("\u4f1a\u5458\u8ba2\u5355\u8be6\u60c5={}", (Object)JSON.toJSONString((Object)orderModel));
        return this.memberOrderApiService.queryOrderInfo(orderModel);
    }

    @RequestMapping(value={"/addOrderEvaluate"}, method={RequestMethod.POST})
    public ResponseData addOrderEvaluate(OrderEvaluateVo orderEvaluateModel, HttpServletRequest request) {
        OrderDetailEvaluateBo orderDetailEvaluateBo;
        Object evaluateContent;
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        StringBuffer buffer = new StringBuffer();
        logger.info("\u4f1a\u5458\u8ba2\u5355\u8bc4\u4ef7={}", (Object)JSON.toJSONString((Object)orderEvaluateModel));
        OrderEvaluateBo orderEvaluateBo = new OrderEvaluateBo();
        String modelList = orderEvaluateModel.getOrderDetailEvaluateModelList();
        ArrayList<OrderDetailEvaluateBo> orderDetailEvaluateModelLists = new ArrayList<OrderDetailEvaluateBo>();
        if (modelList == null) {
            orderDetailEvaluateModelLists.add(null);
        } else {
            JSONArray array = JSONArray.parseArray((String)modelList);
            for (int i = 0; i < array.size(); ++i) {
                OrderDetailEvaluateBo orderDetailEvaluateBo2 = new OrderDetailEvaluateBo();
                JSONObject jsonObject = array.getJSONObject(i);
                if (jsonObject == null) break;
                evaluateContent = jsonObject.getString("evaluateContent");
                String evaluateScore = jsonObject.getString("evaluateScore");
                String orderDetailNo = jsonObject.getString("orderDetailNo");
                String productName = jsonObject.getString("productName");
                String productNo = jsonObject.getString(" productNo");
                logger.info("evaluateContent={},evaluateScore={},orderDetailNo={},productName={},productNo={}", new Object[]{evaluateContent, evaluateScore, orderDetailNo, productName, productNo});
                if (StringUtils.isNotBlank((CharSequence)evaluateContent)) {
                    String replace = ((String)evaluateContent).replace(" ", "");
                    int length = replace.length();
                    String lengthString = String.valueOf(length) + ",";
                    buffer.append(lengthString);
                }
                Integer valueOf = 0;
                if (orderDetailNo == null) {
                    responseData.setMessage("\u8ba2\u5355\u8be6\u60c5\u7f16\u53f7\u672a\u83b7\u53d6");
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    return responseData;
                }
                valueOf = evaluateScore == null ? Integer.valueOf(0) : Integer.valueOf(evaluateScore);
                orderDetailEvaluateBo2.setProductName(productName);
                orderDetailEvaluateBo2.setProductNo(productNo);
                orderDetailEvaluateBo2.setEvaluateContent((String)evaluateContent);
                orderDetailEvaluateBo2.setEvaluateScore(valueOf);
                orderDetailEvaluateBo2.setOrderDetailNo(orderDetailNo);
                JSONArray objects = jsonObject.getJSONArray("evaluatePictureList");
                logger.info("objects={}", (Object)JSON.toJSONString((Object)objects));
                ArrayList<String> strings = new ArrayList<String>();
                if (objects == null) {
                    orderDetailEvaluateBo2.setEvaluatePictureList(null);
                    orderDetailEvaluateModelLists.add(orderDetailEvaluateBo2);
                    continue;
                }
                for (int n = 0; n < objects.size(); ++n) {
                    String objectsString = objects.getString(n);
                    strings.add(objectsString);
                }
                orderDetailEvaluateBo2.setEvaluatePictureList(strings);
                orderDetailEvaluateModelLists.add(orderDetailEvaluateBo2);
            }
        }
        orderEvaluateBo.setOrderDetailEvaluateModelList(orderDetailEvaluateModelLists);
        String appid = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        ResponseData wxPublicPOByAppId = this.wxPublicServiceFeign.getWxPublicPOByAppId(appid);
        Long sysBrandId = ((WxPublicPO)wxPublicPOByAppId.getData()).getSysBrandId();
        if (sysBrandId == null) {
            responseData.setMessage("\u54c1\u724c\u7f16\u53f7\u672a\u83b7\u53d6");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        Long sysCompanyId = ((WxPublicPO)wxPublicPOByAppId.getData()).getSysCompanyId();
        if (sysCompanyId == null) {
            responseData.setMessage("\u4f01\u4e1a\u7f16\u53f7\u7f16\u53f7\u672a\u83b7\u53d6");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        logger.info("orderEvaluateModel={}", (Object)JSON.toJSONString((Object)orderEvaluateBo));
        evaluateContent = orderEvaluateBo.getOrderDetailEvaluateModelList().iterator();
        while (evaluateContent.hasNext() && (orderDetailEvaluateBo = (OrderDetailEvaluateBo)evaluateContent.next()) != null) {
            StringBuilder sb = new StringBuilder();
            List evaluatePictureList = orderDetailEvaluateBo.getEvaluatePictureList();
            if (evaluatePictureList == null) {
                orderDetailEvaluateBo.setEvaluatePicture(null);
                orderDetailEvaluateBo.setBrandId(sysBrandId);
                continue;
            }
            for (int i = 0; i < evaluatePictureList.size() && evaluatePictureList != null; ++i) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append((String)evaluatePictureList.get(i));
            }
            orderDetailEvaluateBo.setEvaluatePicture(sb.toString());
            orderDetailEvaluateBo.setBrandId(sysBrandId);
        }
        OrderEvaluateModel evaluateModel = new OrderEvaluateModel();
        BeanUtils.copyProperties((Object)orderEvaluateBo, (Object)evaluateModel);
        Long serviceStoreId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
        evaluateModel.setBrandId(sysBrandId);
        evaluateModel.setSysCompanyId(sysCompanyId);
        evaluateModel.setOrderNo(orderEvaluateModel.getOrderNo());
        evaluateModel.setEvaluateMemberCode(memberCode);
        evaluateModel.setStoreEnvironmentGrade(orderEvaluateModel.getStoreEnvironmentGrade());
        evaluateModel.setStoreServerGrade(orderEvaluateModel.getStoreServerGrade());
        evaluateModel.setServiceStoreId(serviceStoreId);
        evaluateModel.setStoreName(orderEvaluateModel.getStoreName());
        evaluateModel.setStoreId(orderEvaluateModel.getStoreId());
        evaluateModel.setGuideId(orderEvaluateModel.getGuideId());
        evaluateModel.setGuideName(orderEvaluateModel.getGuideName());
        logger.info("orderEvaluateModel\uff08\u51fa\u53c2\uff09={}", (Object)JSON.toJSONString((Object)orderEvaluateModel));
        if (evaluateModel != null) {
            ResponseData data = this.memberOrderApiService.addOrderEvaluate(evaluateModel);
            if (data.getCode() == 0) {
                int oderCount = 0;
                String oderBeans = evaluateModel.getOrderNo();
                this.redisTemplateService.stringSetString((Object)oderBeans, (Object)"0");
                MemberInfoModel memberInfoModel = new MemberInfoModel();
                memberInfoModel.setMemberCode(memberCode);
                memberInfoModel.setBrandId(sysBrandId);
                if (StringUtils.isNotBlank((CharSequence)buffer)) {
                    memberInfoModel.setDistributionCreateName(buffer.toString());
                } else {
                    memberInfoModel.setDistributionCreateName("0");
                }
                logger.info("DistributionCreateName={}", (Object)memberInfoModel.getDistributionCreateName());
                Long openCardStoreId = (Long)this.wxAppletApiService.getOpenCardStoreId(memberCode).getData();
                logger.info("serviceStoreId={},openCardStoreId={}", (Object)serviceStoreId, (Object)openCardStoreId);
                memberInfoModel.setServiceStoreId(serviceStoreId);
                memberInfoModel.setOpenCardStoreId(openCardStoreId);
                String byKey = (String)this.redisTemplateService.stringGetStringByKey((Object)oderBeans);
                logger.info("byKey={}", (Object)byKey);
                if (!"0".equals(byKey)) {
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    responseData.setMessage("\u5df2\u6210\u529f\u8bc4\u4ef7\u8fc7\u4e0d\u80fd\u91cd\u590d\u8bc4\u4ef7\uff0c\u5956\u52b1\u5728\u53d1\u9001\u7684\u8def\u4e2d\u3002");
                    return responseData;
                }
                ResponseData data1 = this.activityServiceRpc.executeActivityEvaluation(memberInfoModel);
                if (data1.getCode() == 0 && oderBeans.equals(evaluateModel.getOrderNo())) {
                    this.redisTemplateService.stringSetString((Object)oderBeans, (Object)String.valueOf(++oderCount));
                }
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                responseData.setData(data.getData());
                return responseData;
            }
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        return responseData;
    }

    @RequestMapping(value={"/queryOrderEvaluateInfo"}, method={RequestMethod.POST})
    public ResponseData<OrderEvaluateModel> queryOrderEvaluateInfo(String orderNo) {
        ResponseData responseData = new ResponseData();
        if (orderNo == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u8ba2\u5355\u7f16\u53f7");
            return responseData;
        }
        ResponseData data = this.memberOrderApiService.queryOrderEvaluateInfo(orderNo);
        OrderEvaluateModel orderEvaluateModel = (OrderEvaluateModel)data.getData();
        OrderEvaluateBo orderEvaluateBo = new OrderEvaluateBo();
        BeanUtils.copyProperties((Object)orderEvaluateModel, (Object)orderEvaluateBo);
        ArrayList<OrderDetailEvaluateBo> evaluateBos = new ArrayList<OrderDetailEvaluateBo>();
        for (OrderDetailEvaluateModel orderDetailEvaluateModel : orderEvaluateModel.getOrderDetailEvaluateModelList()) {
            OrderDetailEvaluateBo orderDetailEvaluateBo = new OrderDetailEvaluateBo();
            BeanUtils.copyProperties((Object)orderDetailEvaluateModel, (Object)orderDetailEvaluateBo);
            if (orderDetailEvaluateModel.getEvaluatePicture() != null) {
                String[] split = orderDetailEvaluateModel.getEvaluatePicture().split(",");
                ArrayList<String> evaluatePictureList = new ArrayList<String>();
                for (int i = 0; i < split.length; ++i) {
                    String sord = split[i];
                    if (sord != null) {
                        evaluatePictureList.add(this.qiNiuConfig.getDomain() + sord);
                        continue;
                    }
                    evaluatePictureList.add(null);
                }
                orderDetailEvaluateBo.setEvaluatePictureList(evaluatePictureList);
                evaluateBos.add(orderDetailEvaluateBo);
                continue;
            }
            List evaluatePictureList = null;
            orderDetailEvaluateBo.setEvaluatePictureList(evaluatePictureList);
            evaluateBos.add(orderDetailEvaluateBo);
        }
        orderEvaluateBo.setOrderDetailEvaluateModelList(evaluateBos);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)orderEvaluateBo);
        logger.info("\u8bc4\u4ef7\u8be6\u60c5={}", (Object)JSON.toJSONString((Object)orderEvaluateBo));
        return responseData;
    }

    @RequestMapping(value={"/uploadEvaluatePic"}, method={RequestMethod.POST})
    public ResponseData<String> uploadEvaluatePic(@RequestParam(value="file") MultipartFile file) throws IOException {
        ResponseData responseData = new ResponseData();
        String qiniuUrl = "";
        logger.info("file={}", (Object)file);
        byte[] bs = file.getBytes();
        boolean stateInt = true;
        if (bs.length > 0) {
            try {
                String filePath = "/work1/tmp/img";
                logger.info("\u5f00\u59cb\u4e0a\u4f20");
                File validateCodeFolder = new File(filePath);
                if (!validateCodeFolder.exists()) {
                    validateCodeFolder.mkdirs();
                }
                String type = "-evaluate";
                String endPoto = "-order";
                String uuid = UUID.randomUUID().toString().replace("-", "").toLowerCase();
                String filename = uuid + type + endPoto;
                ByteArrayInputStream in = new ByteArrayInputStream(bs);
                File fileImgs = new File(filePath, filename);
                FileOutputStream fos = new FileOutputStream(fileImgs);
                byte[] b = new byte[1024];
                int nRead = 0;
                while ((nRead = in.read(b)) != -1) {
                    fos.write(b, 0, nRead);
                }
                fos.flush();
                fos.close();
                ((InputStream)in).close();
                String name = fileImgs.getName();
                logger.info("\u4e0a\u4f20\u6210\u529f");
                logger.info("validateCodeFolder={} , fileImgs={} , name={}", new Object[]{validateCodeFolder.toString(), fileImgs, name});
                String bucketNm = null;
                String url = QiNiuUtil.upload(bucketNm, (File)fileImgs);
                logger.info("url={}", (Object)url);
                if (url == null) {
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    responseData.setMessage("\u4e0a\u4f20\u4e03\u725b\u5931\u8d25");
                    return responseData;
                }
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage("\u4e0a\u4f20\u4e03\u725b\u6210\u529f");
                responseData.setData((Object)url);
                return responseData;
            }
            catch (Exception e) {
                stateInt = false;
                e.printStackTrace();
            }
        } else {
            responseData.setMessage("\u4e0a\u4f20\u672c\u5730\u5931\u8d25");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        responseData.setData((Object)qiniuUrl);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    @RequestMapping(value={"/getMinActivityEvaluationWordNum"}, method={RequestMethod.POST})
    public ResponseData getMinActivityEvaluationWordNum(MemberInfoModel memberInfoModel, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        String sysBrandId = (String)this.redisTemplateService.stringGetStringByKey((Object)("sysBrandId" + bizvaneSessionId));
        memberInfoModel.setMemberCode(memberCode);
        memberInfoModel.setBrandId(Long.valueOf((String)ObjectUtils.defaultIfNull((Object)sysBrandId, (Object)"0")));
        Long serviceStoreId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
        logger.info("DistributionCreateName={}", (Object)memberInfoModel.getDistributionCreateName());
        Long openCardStoreId = (Long)this.wxAppletApiService.getOpenCardStoreId(memberCode).getData();
        logger.info("serviceStoreId={},openCardStoreId={}", (Object)serviceStoreId, (Object)openCardStoreId);
        memberInfoModel.setServiceStoreId(serviceStoreId);
        logger.info("getMinActivityEvaluationWordNum={}", (Object)JSON.toJSONString((Object)memberInfoModel));
        ResponseData wordNum = this.activityServiceRpc.getMinActivityEvaluationWordNum(memberInfoModel);
        Integer numData = (Integer)wordNum.getData();
        logger.info("numData={}", (Object)numData);
        if (numData == null) {
            responseData.setData(null);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return responseData;
        }
        String numDataString = "\u8bc4\u4ef7\u6ee1" + numData + "\u4e2a\u5b57\u53ef\u83b7\u5f97\u4e30\u539a\u5956\u52b1\u54e6~";
        responseData.setData((Object)numDataString);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }
}

