/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.mktcenterservice.models.po.MktActivityRecordPO;
import com.bizvane.mktcenterservice.models.vo.MktActivityRecordVO;
import com.bizvane.mktcenterservice.rpc.ActivityServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/menberCenterRigister"})
public class MenberCenterRigisterController {
    @Autowired
    private ActivityServiceRpc activityServiceRpc;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/getActivityRecordPOList"}, method={RequestMethod.POST})
    public ResponseData<List<MktActivityRecordPO>> getActivityRecordPOList(MktActivityRecordVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        vo.setMemberCode(memberCode);
        if (vo.getMemberCode() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u4f1a\u5458\u7f16\u53f7");
            return responseData;
        }
        return this.activityServiceRpc.getActivityRecordPOList(vo);
    }

    @RequestMapping(value={"/executeActivitySignin"}, method={RequestMethod.POST})
    public ResponseData<Integer> executeActivitySignin(MemberInfoModel memberInfoModel, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        memberInfoModel.setMemberCode(memberCode);
        if (memberInfoModel.getMemberCode() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u4f1a\u5458\u7f16\u53f7");
            return responseData;
        }
        if (memberInfoModel.getBrandId() == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u54c1\u724c\u7f16\u53f7");
            return responseData;
        }
        Long serviceStoreId = (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
        Long openCardStoreId = (Long)this.wxAppletApiService.getOpenCardStoreId(memberCode).getData();
        logger.info("serviceStoreId={} , openCardStoreId={}" + serviceStoreId, (Object)openCardStoreId);
        memberInfoModel.setServiceStoreId(serviceStoreId);
        memberInfoModel.setOpenCardStoreId(openCardStoreId);
        ResponseData data = this.activityServiceRpc.executeActivitySignin(memberInfoModel);
        if (data.getCode() == 0) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setData(data.getData());
            return responseData;
        }
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage("\u5f53\u524d\u6ca1\u6709\u8fdb\u884c\u4e2d\u7684\u6d3b\u52a8\uff01");
        return responseData;
    }
}

