/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.interfaces.MemberPrivilegeService;
import com.bizvane.appletservice.interfaces.MembershipCardService;
import com.bizvane.appletservice.models.bo.AppletCardLevelPrivLegeBo;
import com.bizvane.appletservice.models.bo.MemberInfoModelBo;
import com.bizvane.appletservice.models.po.AppletVipCartPO;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.members.facade.models.IntegralRecordModel;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.members.facade.vo.IntegralRecordVo;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.text.DecimalFormat;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/memberCardProgram"})
public class MenberCenterGradeController {
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private MemberPrivilegeService memberPrivilegeService;
    @Autowired
    private MembershipCardService membershipCardService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    private DecimalFormat df = new DecimalFormat("###,###.00");
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/queryMemberCardInfo"}, method={RequestMethod.POST})
    public ResponseData<MemberCardLevelModel> queryMemberCardInfo(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData memberCardLevelModelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        AppletCardLevelPrivLegeBo appletCardLevelPrivLegeBo = new AppletCardLevelPrivLegeBo();
        appletCardLevelPrivLegeBo.setAdditionalDiscount(((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getAdditionalDiscount());
        appletCardLevelPrivLegeBo.setBarCode(((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getBarCode());
        appletCardLevelPrivLegeBo.setCardNo(((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getCardNo());
        Integer countIntegral = ((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getCountIntegral();
        appletCardLevelPrivLegeBo.setCountIntegral(String.valueOf(ObjectUtils.defaultIfNull((Object)countIntegral, (Object)"0")));
        appletCardLevelPrivLegeBo.setLevelId(((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getLevelId());
        appletCardLevelPrivLegeBo.setLevelName(((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getLevelName());
        appletCardLevelPrivLegeBo.setMemberDiscount(((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getMemberDiscount());
        appletCardLevelPrivLegeBo.setOfflineCardNo(((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getOfflineCardNo());
        appletCardLevelPrivLegeBo.setWxHeadPortraits(this.qiNiuConfig.getDomain() + ((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getWxHeadPortraits());
        appletCardLevelPrivLegeBo.setWxNick(((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getWxNick());
        Long levelId = ((MemberCardLevelModel)memberCardLevelModelResponseData.getData()).getLevelId();
        ResponseData modelResponseData = this.memberLevelApiService.queryLevelModel(levelId);
        MbrLevelModel levelModel = (MbrLevelModel)modelResponseData.getData();
        if (modelResponseData.getData() == null) {
            appletCardLevelPrivLegeBo.setDiscountMethod(Integer.valueOf(1));
        } else if (levelModel.getDiscountMethod() == null) {
            appletCardLevelPrivLegeBo.setDiscountMethod(Integer.valueOf(1));
        } else {
            appletCardLevelPrivLegeBo.setDiscountMethod(levelModel.getDiscountMethod());
        }
        ResponseData appletVipCartPO = this.membershipCardService.selectByPrimaryKey(levelId);
        if (appletVipCartPO != null || appletVipCartPO.getData() != null) {
            for (AppletVipCartPO appletVipCartPO1 : (List)appletVipCartPO.getData()) {
                if (appletVipCartPO1.getCardStyle() != null) {
                    if (appletVipCartPO1.getIsImg().booleanValue()) {
                        appletCardLevelPrivLegeBo.setImg(appletVipCartPO1.getIsImg());
                        appletCardLevelPrivLegeBo.setCardStyle(this.qiNiuConfig.getDomain() + appletVipCartPO1.getCardStyle());
                    } else {
                        appletCardLevelPrivLegeBo.setCardStyle(appletVipCartPO1.getCardStyle());
                    }
                }
                if (appletVipCartPO1.getAppletVipCardId() != null) {
                    ResponseData listCardId = this.memberPrivilegeService.getMemberPrivilegebyGrder(appletVipCartPO1.getAppletVipCardId());
                    List listCardIdData = (List)listCardId.getData();
                    appletCardLevelPrivLegeBo.setAppletVipPrivilegePOList(listCardIdData);
                    continue;
                }
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u4f1a\u5458\u5361 id \u4e3a\u7a7a");
                responseData.setData(null);
                return responseData;
            }
        } else {
            responseData.setMessage("\u9ed8\u8ba4\u4f1a\u5458\u5361\u672a\u83b7\u53d6");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        logger.info("\u4f1a\u5458\u5361\u57fa\u672c\u4fe1\u606f={}", (Object)JSON.toJSONString((Object)appletCardLevelPrivLegeBo));
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)appletCardLevelPrivLegeBo);
        return responseData;
    }

    @RequestMapping(value={"/queryMemberIntegral"}, method={RequestMethod.POST})
    public ResponseData<MemberInfoModel> queryMemberIntegral(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData memberInfoModelResponseData = this.memberCardProgramApiService.queryMemberIntegral(memberCode);
        MemberInfoModel modelResponseDataData = (MemberInfoModel)memberInfoModelResponseData.getData();
        MemberInfoModelBo memberInfoModelBo = new MemberInfoModelBo();
        logger.info("\u4f1a\u5458\u79ef\u5206={}", (Object)JSON.toJSONString((Object)memberInfoModelBo));
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)modelResponseDataData);
        return responseData;
    }

    @RequestMapping(value={"/queryMemberIntegralRecord"}, method={RequestMethod.POST})
    public ResponseData<PageInfo<IntegralRecordModel>> queryMemberIntegralRecord(IntegralRecordVo vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        vo.setMemberCode(memberCode);
        logger.info("\u4f1a\u5458\u79ef\u5206\u6d41\u6c34\u5165\u53c2={}", (Object)JSON.toJSONString((Object)vo));
        return this.memberCardProgramApiService.queryMemberIntegralRecord(vo);
    }

    @RequestMapping(value={"/queryLevelList"}, method={RequestMethod.POST})
    public ResponseData<List<MbrLevelModel>> queryLevelList(@RequestParam(value="brandId") Long brandId, @RequestParam(value="source") String source) {
        ResponseData responseData = new ResponseData();
        if (brandId == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u54c1\u724c\u7f16\u53f7");
            return responseData;
        }
        if (source == null) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u6765\u6e90\u4fe1\u606f");
            return responseData;
        }
        return this.memberCardProgramApiService.queryLevelList(brandId, source);
    }
}

