/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.common.HttpUtil;
import com.bizvane.appletservice.interfaces.ActivityService;
import com.bizvane.appletservice.interfaces.LoginService;
import com.bizvane.appletservice.models.bo.AppletBrandMenberBo;
import com.bizvane.appletservice.models.bo.AppletByCodeBo;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.appletserviceimpl.utils.UUIDUtils;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.vo.SysBrandVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.WxChannelInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MiniProgramOpenCardService;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.service.card.request.RequestOpenCardModel;
import com.bizvane.members.facade.service.card.response.ResponseOpenCardModel;
import com.bizvane.members.facade.service.qywxapi.QwChannelApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import com.bizvane.wechatenterprise.service.rpc.WxqyInteractHistoryServiceRpc;
import com.bizvane.wechatfacade.interfaces.UserAuthorizationFeign;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.bizvane.wechatfacade.models.vo.UserAuthorizationGetPhoneNumberRequestVO;
import com.bizvane.wechatfacade.models.vo.UserAuthorizationGetPhoneNumberResponseVO;
import com.bizvane.wechatfacade.models.vo.UserAuthorizationGetUserInfoRequestVO;
import com.bizvane.wechatfacade.models.vo.UserAuthorizationGetUserInfoResponseVO;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"})
public class LoginController {
    @Autowired
    private LoginService loginService;
    @Autowired
    private UserAuthorizationFeign userAuthorizationFeign;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MiniProgramOpenCardService miniProgramOpenCardService;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private QwChannelApiService queryWxChannelInfoOnly;
    @Autowired
    private WxqyInteractHistoryServiceRpc wxqyInteractHistoryServiceRpc;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    private static final String MEMEBER_ACTIVITY = "api/marketActivity/newMemberByActivity";
    @Value(value="${wxStore.baseUrl}")
    private String DOMAINNAME;

    @RequestMapping(value={"/sendVerificationCode"})
    public ResponseData<Integer> sendVerificationCode(String phone, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("bizvaneSessionId\u6ca1\u6709");
            responseData.setCode(100);
            return responseData;
        }
        String sysBrandId = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "sysBrandId"));
        return this.loginService.sendVerificationCode(phone, sysBrandId);
    }

    @RequestMapping(value={"/byCode"})
    public ResponseData byCode(@RequestParam(value="code") String code, @RequestParam(value="appid") String appid) {
        String bizvanekey;
        ResponseData stringResponseData;
        ResponseData responseData = new ResponseData();
        logger.info("code={} , appid={}", (Object)code, (Object)appid);
        if (code == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("code\u4e3a\u7a7a");
            responseData.setCode(100);
            return responseData;
        }
        if (appid == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("appId\u4e3a\u7a7a");
            responseData.setCode(100);
            return responseData;
        }
        ResponseData wxPublicPOByAppId = this.wxPublicServiceFeign.getWxPublicPOByAppId(appid);
        Long sysBrandId = ((WxPublicPO)wxPublicPOByAppId.getData()).getSysBrandId();
        logger.info("ByCode sysBrandId={}", (Object)sysBrandId);
        ResponseData brandByID = this.brandServiceRpc.getBrandByID(sysBrandId);
        SysBrandPo brandByIDData = (SysBrandPo)brandByID.getData();
        String brandLogo = null;
        if (brandByIDData != null && StringUtils.isNotBlank((CharSequence)brandByIDData.getBrandLogo())) {
            brandLogo = this.qiNiuConfig.getDomain() + ((SysBrandPo)brandByID.getData()).getBrandLogo();
        }
        if ((stringResponseData = this.userAuthorizationFeign.byCode(code, appid)).getData() == null) {
            responseData.setMessage("bizvanekey\u672a\u83b7\u53d6");
            responseData.setCode(100);
            responseData.setData(null);
        }
        if (StringUtils.isNotBlank((CharSequence)(bizvanekey = (String)stringResponseData.getData()))) {
            this.redisTemplateService.stringSetValueAndExpireTime((Object)bizvanekey, (Object)bizvanekey, 2592000000L);
            AppletByCodeBo appletByCodeBo = new AppletByCodeBo();
            appletByCodeBo.setBizvanekey(bizvanekey);
            appletByCodeBo.setBrandLogo(brandLogo);
            appletByCodeBo.setQiniuUrl(this.qiNiuConfig.getDomain());
            logger.info("byCode\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)appletByCodeBo));
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)appletByCodeBo);
            return responseData;
        }
        responseData.setMessage("bizvanekey\u4e3a\u7a7a");
        responseData.setCode(100);
        return responseData;
    }

    @RequestMapping(value={"/getUserInfo"})
    public ResponseData getUserInfo(HttpServletRequest request, @RequestParam(value="userInfoData") String userInfoData, @RequestParam(value="appid") String appid) {
        ResponseData responseData = new ResponseData();
        UserAuthorizationGetUserInfoRequestVO userAuthorizationGetUserInfoRequestVo = new UserAuthorizationGetUserInfoRequestVO();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("bizvaneSessionId\u6ca1\u6709");
            responseData.setCode(100);
            return responseData;
        }
        String bizvanekey = (String)this.redisTemplateService.stringGetStringByKey((Object)bizvaneSessionId);
        if (!bizvaneSessionId.equals(bizvanekey)) {
            responseData.setMessage("bizvaneSessionId\u65e0\u6548");
            responseData.setCode(-100);
            return responseData;
        }
        userAuthorizationGetUserInfoRequestVo.setAppid(appid);
        userAuthorizationGetUserInfoRequestVo.setBizvaneSessionId(bizvaneSessionId);
        userAuthorizationGetUserInfoRequestVo.setUserInfoData(userInfoData);
        logger.info("userInfo\u5165\u53c2={}", (Object)JSON.toJSONString((Object)userAuthorizationGetUserInfoRequestVo));
        ResponseData userInfo = this.userAuthorizationFeign.getUserInfo(userAuthorizationGetUserInfoRequestVo);
        logger.info("\u6388\u6743\u8fd4\u56de\u7684\u7ed3\u679c={}", (Object)JSON.toJSONString((Object)userInfo.getData()));
        if (userInfo.getData() == null) {
            responseData.setMessage("\u6388\u6743\u83b7\u53d6\u4fe1\u606f\u5931\u8d25");
            responseData.setCode(100);
            return responseData;
        }
        String memberCode = ((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getMemberCode();
        AppletBrandMenberBo appletBrandMenberBo = new AppletBrandMenberBo();
        if (userInfo.getData() == null || ((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getSysBrandId() == null) {
            responseData.setCode(100);
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getOpenId" + bizvaneSessionId), (Object)((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getOpenId(), 2592000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getUnionId" + bizvaneSessionId), (Object)((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getUnionId(), 2592000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("getAppId" + bizvaneSessionId), (Object)appid, 2592000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)("sysBrandId" + bizvaneSessionId), (Object)String.valueOf(((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getSysBrandId()), 2592000000L);
        this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "sysBrandId"), (Object)String.valueOf(((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getSysBrandId()), 2592000000L);
        if (StringUtils.isNotBlank((CharSequence)memberCode)) {
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(memberCode);
            ResponseData model = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            if (model.getData() != null) {
                String phone = ((MemberInfoModel)model.getData()).getPhone();
                this.redisTemplateService.stringSetValueAndExpireTime((Object)("Phone:" + memberCode), (Object)phone, 2592000000L);
            }
            this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "memberCode"), (Object)memberCode, 2592000000L);
            this.redisTemplateService.stringSetValueAndExpireTime((Object)(memberCode + "bizvaneSessionId"), (Object)bizvaneSessionId, 2592000000L);
            logger.info("memberCode\u6388\u6743\u5df2\u5f00\u5361={}", this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode")));
            appletBrandMenberBo.setOpenCard(true);
            appletBrandMenberBo.setSysBrandId(((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getSysBrandId());
            responseData.setMessage("\u5df2\u5f00\u5361");
            responseData.setData((Object)appletBrandMenberBo);
            logger.info("openCard={}", (Object)JSON.toJSONString((Object)appletBrandMenberBo));
            return responseData;
        }
        appletBrandMenberBo.setSysBrandId(((UserAuthorizationGetUserInfoResponseVO)userInfo.getData()).getSysBrandId());
        appletBrandMenberBo.setOpenCard(false);
        responseData.setMessage("\u672a\u5f00\u5361");
        responseData.setData((Object)appletBrandMenberBo);
        logger.info("openCard={}", (Object)JSON.toJSONString((Object)appletBrandMenberBo));
        return responseData;
    }

    @RequestMapping(value={"/openCardMenbr"})
    public ResponseData openCardMenbr(AppletBrandMenberBo appletBrandMenberBo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        logger.info("\u5f00\u5361\u63a5\u53e3\u5165\u53c2={}", (Object)JSON.toJSONString((Object)appletBrandMenberBo));
        String mktTaskId = appletBrandMenberBo.getMktTaskId();
        if (appletBrandMenberBo.getPhone() == null) {
            responseData.setMessage("\u6ca1\u6709\u6536\u5230\u624b\u673a\u53f7");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u6536\u5230bizvaneSessionId");
            return responseData;
        }
        logger.info("oderMemberCode={}", (Object)appletBrandMenberBo.getOderMemberCode());
        RequestOpenCardModel requestOpenCardModel = new RequestOpenCardModel();
        requestOpenCardModel.setPhone(appletBrandMenberBo.getPhone());
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        String unionId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getUnionId" + bizvaneSessionId));
        String appid = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        UserAuthorizationGetPhoneNumberRequestVO userAuthorizationGetPhoneNumberRequestVO = new UserAuthorizationGetPhoneNumberRequestVO();
        userAuthorizationGetPhoneNumberRequestVO.setAppid(appid);
        userAuthorizationGetPhoneNumberRequestVO.setBizvaneSessionId(bizvaneSessionId);
        userAuthorizationGetPhoneNumberRequestVO.setPhoneNumberData(requestOpenCardModel.getPhone());
        logger.info("openId={} , unionId={} , appid={} , bizvaneSessionId={}", new Object[]{openId, unionId, appid, bizvaneSessionId});
        if (StringUtils.isBlank((CharSequence)openId) || StringUtils.isBlank((CharSequence)unionId) || StringUtils.isBlank((CharSequence)appid) || StringUtils.isBlank((CharSequence)bizvaneSessionId)) {
            responseData.setMessage("\u7f13\u5b58\u6307\u6807\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData phoneNumber = this.userAuthorizationFeign.getPhoneNumber(userAuthorizationGetPhoneNumberRequestVO);
        if (phoneNumber.getData() == null) {
            responseData.setMessage("\u89e3\u5bc6\u624b\u673a\u53f7\u63a5\u53e3\u5f02\u5e38");
            responseData.setCode(100);
            return responseData;
        }
        if (((UserAuthorizationGetPhoneNumberResponseVO)phoneNumber.getData()).getPurePhoneNumber() == null) {
            responseData.setMessage("\u89e3\u5bc6\u624b\u673a\u53f7\u5931\u8d25");
            responseData.setCode(100);
            return responseData;
        }
        requestOpenCardModel.setOpenId(openId);
        requestOpenCardModel.setUnionId(unionId);
        requestOpenCardModel.setAppId(appid);
        requestOpenCardModel.setPhone(((UserAuthorizationGetPhoneNumberResponseVO)phoneNumber.getData()).getPurePhoneNumber());
        String uuid = request.getHeader("UUID");
        logger.info("UUID\u5f00\u5361={}", (Object)uuid);
        if (StringUtils.isNotBlank((CharSequence)uuid)) {
            String uuidJONString = (String)this.redisTemplateService.stringGetStringByKey((Object)uuid);
            logger.info("uuidJONString={}", (Object)uuidJONString);
            if (StringUtils.isNotBlank((CharSequence)uuidJONString)) {
                JSONObject JSONobjectUUID = JSONObject.parseObject((String)uuidJONString);
                String activityType = JSONobjectUUID.getString("activityType");
                String mktActivityId = JSONobjectUUID.getString("mktActivityId");
                logger.info("activityType={}", (Object)activityType);
                logger.info("mktActivityId={}", (Object)mktActivityId);
                requestOpenCardModel.setActivityId(Long.valueOf(mktActivityId));
                requestOpenCardModel.setActivityType(Integer.valueOf(activityType));
            }
        }
        ResponseOpenCardModel responseOpenCardModel = null;
        try {
            responseOpenCardModel = this.miniProgramOpenCardService.openCard(requestOpenCardModel);
            logger.info("open card result {}", (Object)JSON.toJSONString((Object)responseOpenCardModel));
        }
        catch (MemberException e) {
            logger.info("responseOpenCardModel={}", (Object)JSON.toJSONString((Object)((Object)e)));
        }
        if (responseOpenCardModel.getCode() == 9000) {
            responseData.setMessage(responseOpenCardModel.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        if (responseOpenCardModel.getMemberCode() != null) {
            this.redisTemplateService.stringSetValueAndExpireTime((Object)("Phone:" + responseOpenCardModel.getMemberCode()), (Object)((UserAuthorizationGetPhoneNumberResponseVO)phoneNumber.getData()).getPurePhoneNumber(), 2592000000L);
            Integer operateType = responseOpenCardModel.getOperateType();
            this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "memberCode"), (Object)responseOpenCardModel.getMemberCode(), 2592000000L);
            ResponseData wxPublicPOByAppId = this.wxPublicServiceFeign.getWxPublicPOByAppId(appid);
            Long sysBrandId = ((WxPublicPO)wxPublicPOByAppId.getData()).getSysBrandId();
            this.activityService.executeActivity(sysBrandId, responseOpenCardModel.getMemberCode(), operateType);
            if (StringUtils.isNotBlank((CharSequence)appletBrandMenberBo.getOderMemberCode())) {
                this.activityService.inviteOpenCoder(responseOpenCardModel.getMemberCode(), appletBrandMenberBo.getOderMemberCode(), mktTaskId);
            }
            try {
                if (StringUtils.isNotBlank((CharSequence)appletBrandMenberBo.getActivityNo()) && StringUtils.isNotBlank((CharSequence)appletBrandMenberBo.getActivityOrdersNo())) {
                    String userNo = responseOpenCardModel.getMemberCode();
                    String url = this.DOMAINNAME + MEMEBER_ACTIVITY + "?activityNo" + appletBrandMenberBo.getActivityNo() + "&activityOrdersNo=" + appletBrandMenberBo.getActivityOrdersNo() + "&userNo" + userNo;
                    logger.info("\u5f00\u5361\u8c03\u7528\u5fae\u5546\u57ceURL={}", (Object)url);
                    String result = HttpUtil.get((String)url);
                    logger.info("\u5fae\u5546\u57ce\u8fd4\u56de\u6570\u636e={}", (Object)result);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            SysBrandVo sysBrandVo = new SysBrandVo();
            sysBrandVo.setSysBrandId(sysBrandId);
            ResponseData skipByBrandId = this.brandServiceRpc.getSkipByBrandId(sysBrandVo);
            String skipByBrandIdData = (String)skipByBrandId.getData();
            AppletBrandMenberBo menberBo = new AppletBrandMenberBo();
            menberBo.setSkipByBrandId(skipByBrandIdData);
            menberBo.setPhone(responseOpenCardModel.getPhone());
            WxChannelInfoModel wxChannelInfoModel = new WxChannelInfoModel();
            wxChannelInfoModel.setBrandId(sysBrandId);
            wxChannelInfoModel.setOpenId(openId);
            wxChannelInfoModel.setUnionId(unionId);
            logger.info("operateType={} , mktTaskId={} , sysBrandId={} , \u4f1a\u5458\u4fe1\u606f\u5b58\u50a8={}", new Object[]{operateType, mktTaskId, sysBrandId, this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"))});
            if (responseOpenCardModel.getOpenCardGuideId() != null) {
                menberBo.setMemberCode(responseOpenCardModel.getMemberCode());
            } else {
                menberBo.setMemberCode(null);
            }
            responseData.setMessage("\u5f00\u5361\u6210\u529f");
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)menberBo);
            return responseData;
        }
        responseData.setMessage("\u5f00\u5361\u5931\u8d25,\u672a\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f");
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        return responseData;
    }

    @RequestMapping(value={"/redisMan"})
    public ResponseData redisMan() {
        ResponseData responseData = new ResponseData();
        String uuid = UUIDUtils.getUUID();
        this.redisTemplateService.stringSetValueAndExpireTime((Object)uuid, (Object)"11111111", 2592000000L);
        String s = (String)this.redisTemplateService.stringGetStringByKey((Object)uuid);
        responseData.setData((Object)s);
        return responseData;
    }

    @RequestMapping(value={"/getBizSessionIdByMemberCode"})
    public ResponseData getBizSessionIdByMemverCode(String memberCode) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = "";
        String redisMmeberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(memberCode + "testLogin"));
        String avc = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (redisMmeberCode == null || redisMmeberCode == "") {
            bizvaneSessionId = UUIDUtils.getUUID();
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setMemberCode(memberCode);
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            MemberInfoModel member = (MemberInfoModel)singleMemberModel.getData();
            this.redisTemplateService.stringSetValueAndExpireTime((Object)("sysBrandId" + bizvaneSessionId), (Object)String.valueOf(member.getBrandId()), 2592000000L);
            this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "sysBrandId"), (Object)String.valueOf(member.getBrandId()), 2592000000L);
            this.redisTemplateService.stringSetValueAndExpireTime((Object)(bizvaneSessionId + "memberCode"), (Object)memberCode, 2592000000L);
            this.redisTemplateService.stringSetValueAndExpireTime((Object)(memberCode + "testLogin"), (Object)bizvaneSessionId, 2592000000L);
        } else {
            bizvaneSessionId = redisMmeberCode;
        }
        responseData.setData((Object)bizvaneSessionId);
        return responseData;
    }
}

