/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.interfaces.IntegrationShopService;
import com.bizvane.appletservice.models.po.AppletResourcesPO;
import com.bizvane.appletservice.models.po.AppletResourcesPOExample;
import com.bizvane.appletservice.models.vo.AllMerchandiseVo;
import com.bizvane.appletservice.models.vo.ConfirmGoodsVo;
import com.bizvane.appletservice.models.vo.RefundLogisticsVo;
import com.bizvane.appletservice.models.vo.ReturnGoodsVo;
import com.bizvane.appletservice.models.vo.UserAddressPutVo;
import com.bizvane.appletservice.models.vo.classifiedGoodsVo;
import com.bizvane.appletserviceimpl.mappers.AppletResourcesPOMapper;
import com.bizvane.appletserviceimpl.utils.QiNiuConfig;
import com.bizvane.members.facade.models.MemberCardLevelModel;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberCardProgramApiService;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.mktcenterservice.models.vo.CouponRecordVO;
import com.bizvane.mktcenterservice.rpc.TaskServiceForWXRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/integrationShop"}, method={RequestMethod.POST})
public class IntegrationShopController {
    @Autowired
    private TaskServiceForWXRpc taskServiceForWXRpc;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private MemberCardProgramApiService memberCardProgramApiService;
    @Autowired
    private AppletResourcesPOMapper appletResourcesPOMapper;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private IntegrationShopService integrationShopService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/integrationShopResources"}, method={RequestMethod.POST})
    public ResponseData integrationShopResources(HttpServletRequest request, CouponRecordVO couponRecordVO) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        AppletResourcesPOExample appletResourcesPOExample = new AppletResourcesPOExample();
        appletResourcesPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andModularCodeEqualTo("M006").andSysBrandIdEqualTo(couponRecordVO.getBrandId()).andModularTypeEqualTo("2");
        List resourcesPOS = this.appletResourcesPOMapper.selectByExample(appletResourcesPOExample);
        for (AppletResourcesPO appletResourcesPO : resourcesPOS) {
            appletResourcesPO.setModularContent(this.qiNiuConfig.getDomain() + appletResourcesPO.getModularContent());
        }
        responseData.setCode(0);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)resourcesPOS);
        return responseData;
    }

    @RequestMapping(value={"/integrationShopGetall"}, method={RequestMethod.POST})
    public ResponseData integrationShopGetall(CouponRecordVO couponRecordVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        if (couponRecordVO.getBrandId() == null) {
            responseData.setMessage("\u54c1\u724c\u4e3a null");
            responseData.setCode(100);
            return responseData;
        }
        if (couponRecordVO.getCanConvertCoupon() == null) {
            responseData.setMessage("\u67e5\u8be2\u52fe\u9009\u6846\u4e3anull");
            responseData.setCode(100);
            return responseData;
        }
        couponRecordVO.setMemberCode(memberCode);
        Long serviceStoreId = this.wxAppletApiService.getOpenCardStoreId(memberCode).getData() == null ? Long.valueOf(0L) : (Long)this.wxAppletApiService.getServiceStoreId(memberCode).getData();
        couponRecordVO.setOpenCardStoreId(serviceStoreId);
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        MemberCardLevelModel data = (MemberCardLevelModel)modelResponseData.getData();
        Integer integral = data.getCountIntegral();
        if (integral != null) {
            couponRecordVO.setCountIntegral(integral);
        }
        couponRecordVO.setMbrLevelId(data.getLevelId());
        logger.info("\u5165\u53c2====" + JSON.toJSON((Object)couponRecordVO.toString()));
        return this.taskServiceForWXRpc.getConvernCouponLists(couponRecordVO);
    }

    @RequestMapping(value={"/integrationShopStallInfo"}, method={RequestMethod.POST})
    public ResponseData integrationShopStallInfo(HttpServletRequest request, CouponRecordVO couponRecordVO) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        if (couponRecordVO.getBrandId() == null) {
            responseData.setMessage("\u54c1\u724c\u4e3a null");
            responseData.setCode(100);
            return responseData;
        }
        if (couponRecordVO.getExchangeId() == null) {
            responseData.setMessage("\u89c4\u5219 id \u4e3a\u7a7a");
            responseData.setCode(100);
            return responseData;
        }
        if (couponRecordVO.getExchangeNum() == null) {
            responseData.setMessage("\u5151\u6362\u6570 \u4e3a\u7a7a");
            responseData.setCode(100);
            return responseData;
        }
        Long openCardStoreId = this.wxAppletApiService.getOpenCardStoreId(memberCode).getData() == null ? Long.valueOf(0L) : (Long)this.wxAppletApiService.getOpenCardStoreId(memberCode).getData();
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        MemberCardLevelModel data = (MemberCardLevelModel)modelResponseData.getData();
        Integer integral = data.getCountIntegral();
        if (integral != null) {
            couponRecordVO.setCountIntegral(integral);
        }
        couponRecordVO.setMbrLevelId(data.getLevelId());
        couponRecordVO.setOpenCardStoreId(openCardStoreId);
        couponRecordVO.setMemberCode(memberCode);
        logger.info("\u5165\u53c2====" + JSON.toJSON((Object)couponRecordVO.toString()));
        return this.taskServiceForWXRpc.doConvernCoupon(couponRecordVO);
    }

    @RequestMapping(value={"/integrationShopGetOld"}, method={RequestMethod.POST})
    public ResponseData integrationShopGetOld(HttpServletRequest request, CouponRecordVO couponRecordVO) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        if (couponRecordVO.getBrandId() == null) {
            responseData.setMessage("\u54c1\u724c\u4e3a null");
            responseData.setCode(100);
            return responseData;
        }
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        MemberCardLevelModel data = (MemberCardLevelModel)modelResponseData.getData();
        couponRecordVO.setMbrLevelId(data.getLevelId());
        couponRecordVO.setMemberCode(memberCode);
        logger.info("\u5165\u53c2====" + JSON.toJSON((Object)couponRecordVO.toString()));
        return this.taskServiceForWXRpc.getConvernConpouByMember(couponRecordVO);
    }

    @RequestMapping(value={"/getCouponAndPrice"}, method={RequestMethod.POST})
    public ResponseData getCouponAndPrice(HttpServletRequest request, CouponRecordVO couponRecordVO) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        ResponseData modelResponseData = this.memberCardProgramApiService.queryMemberCardInfo(memberCode);
        MemberCardLevelModel data = (MemberCardLevelModel)modelResponseData.getData();
        couponRecordVO.setMemberCode(memberCode);
        couponRecordVO.setMbrLevelId(data.getLevelId());
        logger.info("\u5165\u53c2====" + JSON.toJSON((Object)couponRecordVO.toString()));
        return this.taskServiceForWXRpc.getCouponAndPrice(couponRecordVO);
    }

    @RequestMapping(value={"/shopHomePage"}, method={RequestMethod.POST})
    public ResponseData shopHomePage(String sysBrandId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.shopHomePage(sysBrandId, memberCode);
    }

    @RequestMapping(value={"/fullMerchandiseDisplay"}, method={RequestMethod.POST})
    public ResponseData fullMerchandiseDisplay(AllMerchandiseVo allMerchandiseVo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.fullMerchandiseDisplay(allMerchandiseVo);
    }

    @RequestMapping(value={"/commodityDetails"}, method={RequestMethod.POST})
    public ResponseData commodityDetails(String hostId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.commodityDetails(hostId);
    }

    @RequestMapping(value={"/classifiedGoods"}, method={RequestMethod.POST})
    public ResponseData classifiedGoods(classifiedGoodsVo classifiedGoodsVo2, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.classifiedGoods(classifiedGoodsVo2);
    }

    @RequestMapping(value={"/tailForClassifiedGoods"}, method={RequestMethod.POST})
    public ResponseData tailForClassifiedGoods(AllMerchandiseVo allMerchandiseVo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.tailForClassifiedGoods(allMerchandiseVo);
    }

    @RequestMapping(value={"/generateOrder"}, method={RequestMethod.POST})
    public ResponseData generateOrder(ConfirmGoodsVo confirmGoodsVo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        Integer countIntegral = ((MemberInfoModel)singleMemberModel.getData()).getCountIntegral();
        if (Integer.valueOf(confirmGoodsVo.getSaleIntegral()) > countIntegral) {
            responseData.setMessage("\u60a8\u7684\u79ef\u5206\u597d\u50cf\u4e0d\u591f\u4e86\u54e6");
            responseData.setCode(100);
            return responseData;
        }
        confirmGoodsVo.setMemberCode(memberCode);
        return this.integrationShopService.generateOrder(confirmGoodsVo);
    }

    @RequestMapping(value={"/inventoryStatus"}, method={RequestMethod.POST})
    public ResponseData inventoryStatus(ConfirmGoodsVo confirmGoodsVo, String hostId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.inventoryStatus(confirmGoodsVo);
    }

    @RequestMapping(value={"/increaseReceivingAddress"}, method={RequestMethod.POST})
    public ResponseData increaseReceivingAddress(UserAddressPutVo UserAddressPutVo2, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        UserAddressPutVo2.setMemberCode(memberCode);
        return this.integrationShopService.increaseReceivingAddress(UserAddressPutVo2);
    }

    @RequestMapping(value={"/editReceivingAddress"}, method={RequestMethod.POST})
    public ResponseData editReceivingAddress(UserAddressPutVo UserAddressPutVo2, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        UserAddressPutVo2.setMemberCode(memberCode);
        return this.integrationShopService.editReceivingAddress(UserAddressPutVo2);
    }

    @RequestMapping(value={"/eliminateReceivingAddress"}, method={RequestMethod.POST})
    public ResponseData eliminateReceivingAddress(UserAddressPutVo UserAddressPutVo2, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        UserAddressPutVo2.setMemberCode(memberCode);
        return this.integrationShopService.eliminateReceivingAddress(UserAddressPutVo2);
    }

    @RequestMapping(value={"/addressuery"}, method={RequestMethod.POST})
    ResponseData addressuery(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.addressuery(memberCode);
    }

    @RequestMapping(value={"/fullOrderDisplay"}, method={RequestMethod.POST})
    ResponseData fullOrderDisplay(String sysBrandId, String orderStatus, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.fullOrderDisplay(sysBrandId, orderStatus, memberCode);
    }

    @RequestMapping(value={"/fullCouponDisplay"}, method={RequestMethod.POST})
    ResponseData fullCouponDisplay(CouponRecordVO couponRecordVO, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        couponRecordVO.setMemberCode(memberCode);
        return this.integrationShopService.fullCouponDisplay(couponRecordVO);
    }

    @RequestMapping(value={"/tailForFullCouponDisplay"}, method={RequestMethod.POST})
    ResponseData tailForFullCouponDisplay(Long convertCouponRecordId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.tailForFullCouponDisplay(convertCouponRecordId, memberCode);
    }

    @RequestMapping(value={"/viewOrder"}, method={RequestMethod.POST})
    ResponseData viewOrder(String orderId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.viewOrder(orderId);
    }

    @RequestMapping(value={"/integralAcquisition"}, method={RequestMethod.POST})
    ResponseData integralAcquisition(String sysBrandId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.integralAcquisition(sysBrandId);
    }

    @RequestMapping(value={"/storeSelfMention"}, method={RequestMethod.POST})
    ResponseData storeSelfMention(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.storeSelfMention();
    }

    @RequestMapping(value={"/logisticsCompanyGroup"}, method={RequestMethod.POST})
    ResponseData logisticsCompanyGroup(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.logisticsCompanyGroup();
    }

    @RequestMapping(value={"/displayLogistics"}, method={RequestMethod.POST})
    ResponseData displayLogistics(String companyCode, String num, String phone, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.displayLogistics(companyCode, num, phone);
    }

    @RequestMapping(value={"/applyeturnSubmission"}, method={RequestMethod.POST})
    ResponseData applyeturnSubmission(ReturnGoodsVo returnGoodsVo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        returnGoodsVo.setMemberCode(memberCode);
        return this.integrationShopService.applyeturnSubmission(returnGoodsVo);
    }

    @RequestMapping(value={"/applyeturnNotSubmitted"}, method={RequestMethod.POST})
    ResponseData applyeturnNotSubmitted(RefundLogisticsVo refundLogisticsVo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.applyeturnNotSubmitted(refundLogisticsVo);
    }

    @RequestMapping(value={"/instructions"}, method={RequestMethod.POST})
    ResponseData instructions(String sysBrandId, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230bizvaneSessionId");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u4f1a\u5458\u4e3a\u7a7a");
            responseData.setCode(-100);
            return responseData;
        }
        return this.integrationShopService.instructions(sysBrandId);
    }

    @GetMapping(value={"/getConfig"})
    public ResponseData getConfig(Integer merchantId) throws IOException {
        return this.integrationShopService.getConfig(merchantId);
    }
}

