/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.appletservice.interfaces.FitmentService;
import com.bizvane.appletservice.models.vo.NorthOuBiRecordVO;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.bo.MiniProgramPropertyVipCardShowBo;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxAppletApiService;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenUtils;
import java.text.DecimalFormat;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fitment"})
public class FitmentController {
    @Autowired
    private FitmentService fitmentService;
    @Autowired
    private WxAppletApiService wxAppletApiService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    private DecimalFormat df = new DecimalFormat("###,###.00");
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);

    @RequestMapping(value={"/selectBrandIntroduce"})
    public ResponseData selectBrandIntroduce(Long sysBrandId) {
        return this.fitmentService.selectBrandIntroduce(sysBrandId);
    }

    @RequestMapping(value={"/northOuBiRecord"})
    public ResponseData northOuBiRecord(NorthOuBiRecordVO northOuBiRecordVO, HttpServletRequest request) {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(northOuBiRecordVO.getMemberCode());
        MemberInfoModel memberModel = (MemberInfoModel)this.memberInfoApiService.getMemberModel(memberInfoModel).getData();
        if (memberModel != null) {
            northOuBiRecordVO.setSysCompanyId(memberModel.getSysCompanyId());
        }
        return this.fitmentService.northOuBiRecord(northOuBiRecordVO);
    }

    @RequestMapping(value={"/getBaseAndExtendPropertyValueVipCardStyle"})
    public ResponseData getBaseAndExtendPropertyValueVipCardStyle(String memberCode, Long brandId) {
        ResponseData responseData = new ResponseData();
        ResponseData miniProgramPropertyVipCardShow = this.wxAppletApiService.getMiniProgramPropertyVipCardShow(brandId, memberCode);
        if (miniProgramPropertyVipCardShow.getData() == null) {
            return this.wxAppletApiService.getMiniProgramPropertyVipCardShow(brandId, memberCode);
        }
        List cardShowData = (List)miniProgramPropertyVipCardShow.getData();
        for (MiniProgramPropertyVipCardShowBo miniProgramPropertyVipCardShowBo : cardShowData) {
            String propertyValue;
            if (miniProgramPropertyVipCardShowBo.getPropertyCode().indexOf("integral_") != -1) {
                propertyValue = miniProgramPropertyVipCardShowBo.getPropertyValue();
                logger.info("integral_+propertyValueString={}", (Object)propertyValue);
                Integer integer = Integer.valueOf(propertyValue);
                logger.info("integral_+propertyValueInteger={}", (Object)integer);
            }
            if (miniProgramPropertyVipCardShowBo.getPropertyCode().indexOf("extend_") != -1) {
                propertyValue = miniProgramPropertyVipCardShowBo.getPropertyValue();
                String propertyType = miniProgramPropertyVipCardShowBo.getPropertyType();
                if ("4".equals(propertyType) && StringUtils.isBlank((CharSequence)propertyValue)) {
                    miniProgramPropertyVipCardShowBo.setPropertyValue("0");
                }
            }
            if (miniProgramPropertyVipCardShowBo.getPropertyCode().indexOf("gender_") == -1 || !StringUtils.isNotBlank((CharSequence)(propertyValue = miniProgramPropertyVipCardShowBo.getPropertyValue())) || !propertyValue.equals("3")) continue;
            miniProgramPropertyVipCardShowBo.setPropertyValue("");
        }
        responseData.setData((Object)cardShowData);
        return responseData;
    }
}

