/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.client.RestTemplate;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@SpringBootApplication(scanBasePackages={"com.bizvane"})
@EnableDiscoveryClient
@EnableSwagger2
@EnableAsync
@EnableFeignClients(basePackages={"com.bizvane.centerstageservice.rpc", "com.bizvane.members.facade.service.api", "com.bizvane.members.facade.service.electcard", "com.bizvane.mktcenterservice.rpc", "com.bizvane.messagefacade.interfaces", "com.bizvane.couponfacade.interfaces", "com.bizvane.wechatfacade.interfaces", "com.bizvane.wechatenterprise.service.rpc", "com.bizvane.members.facade.service.qywxapi", "com.bizvane.fitmentservice.models.Rpc", "com.bizvane.connectorservice.interfaces.rpc"})
@MapperScan(value={"com.bizvane.appletserviceimpl.mappers"})
public class ControlAppletServiceImplApplication {
    @LoadBalanced
    @Bean
    RestTemplate restTemplate(RestTemplateBuilder restTemplateBuilder) {
        return restTemplateBuilder.build();
    }

    public static void main(String[] args) {
        SpringApplication.run(ControlAppletServiceImplApplication.class, (String[])args);
    }
}

