/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.bizvane.appletservice.interfaces.PayMentService;
import com.bizvane.appletservice.interfaces.RedPackService;
import com.bizvane.appletservice.interfaces.RevicePackSservice;
import com.bizvane.appletservice.interfaces.RuleRedPackService;
import com.bizvane.appletservice.interfaces.UserService;
import com.bizvane.appletservice.models.Amount;
import com.bizvane.appletservice.models.CashTransactionRecord;
import com.bizvane.appletservice.models.RevicePack;
import com.bizvane.appletservice.models.RuleRedPack;
import com.bizvane.appletservice.models.SendPack;
import com.bizvane.appletservice.models.User;
import com.bizvane.appletserviceimpl.utils.RedPackUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RedPackController {
    @Autowired
    private RedPackService redPackService;
    @Autowired
    private RevicePackSservice revicePackSservice;
    @Autowired
    private PayMentService userHomeService;
    @Autowired
    private RuleRedPackService ruleRedPackService;
    @Autowired
    private UserService userService;

    @RequestMapping(value={"sendRedPack"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> sendRedPack(Integer type, Integer number, Integer money, Integer sendId, String packDic, String messgeId, String groupId) {
        ArrayList<RevicePack> list;
        RevicePack revicePack;
        UUID randomUUID;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Amount amount = this.userHomeService.queryAmount(sendId);
        double count = amount.getAmountCount() - (double)money.intValue() / 100.0;
        if (count < 0.0) {
            map.put("code", 201);
            return map;
        }
        RedPackUtil redPackUtil = new RedPackUtil();
        SendPack sendPack = new SendPack();
        sendPack.setMoney(money);
        sendPack.setPackNum(number);
        sendPack.setPackType(type);
        sendPack.setSendId(sendId);
        sendPack.setPackDic(packDic);
        sendPack.setMessageId(messgeId);
        this.redPackService.addSendPack(sendPack);
        if (null != groupId && type != 0) {
            List listRule = this.ruleRedPackService.queryRule(groupId);
            for (RuleRedPack rrp : listRule) {
                if (rrp.getUserId() != null) {
                    // empty if block
                }
                if (money - rrp.getMoney() <= number - 1) continue;
                randomUUID = UUID.randomUUID();
                revicePack = new RevicePack();
                revicePack.setPackId(sendPack.getId());
                revicePack.setMoney(rrp.getMoney());
                revicePack.setFlag(Integer.valueOf(1));
                revicePack.setId(randomUUID.toString());
                revicePack.setRuleUserId(rrp.getUserId());
                this.revicePackSservice.addrevicePack(revicePack);
                money = money - rrp.getMoney();
                number = number - 1;
                this.ruleRedPackService.deleteRule(rrp.getId());
                break;
            }
        }
        if (type == 0) {
            int sum = number * money;
            list = new ArrayList<RevicePack>();
            for (int i = 0; i < number; ++i) {
                randomUUID = UUID.randomUUID();
                revicePack = new RevicePack();
                revicePack.setPackId(sendPack.getId());
                revicePack.setMoney(money);
                revicePack.setFlag(Integer.valueOf(1));
                revicePack.setId(randomUUID.toString());
                list.add(revicePack);
            }
            this.revicePackSservice.addrevicePacks(list);
        } else {
            List splitRedPackets = redPackUtil.splitRedPackets(money.intValue(), number.intValue());
            list = new ArrayList();
            for (Integer mon : splitRedPackets) {
                UUID randomUUID2 = UUID.randomUUID();
                RevicePack revicePack2 = new RevicePack();
                revicePack2.setPackId(sendPack.getId());
                revicePack2.setMoney(mon);
                revicePack2.setFlag(Integer.valueOf(1));
                revicePack2.setId(randomUUID2.toString());
                list.add(revicePack2);
            }
            this.revicePackSservice.addrevicePacks(list);
        }
        Amount am = new Amount();
        am.setAmountCount(count);
        am.setUserId(amount.getUserId());
        am.setAmountId(amount.getAmountId());
        this.userHomeService.updAmount(am);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CashTransactionRecord record = new CashTransactionRecord();
        record.setCashTransactionRecordAmount((double)money.intValue() / 100.0);
        record.setCashTransactionRecordDate(df.format(new Date()));
        record.setCashTransactionRecordSig(Integer.valueOf(1));
        record.setCashTransactionRecordType("\u4f59\u989d\u53d1\u9001\u7ea2\u5305");
        record.setUserId(sendId);
        record.setCashTransactionRecordCount(Integer.valueOf(2));
        record.setCashTransactionRecordOrde("001");
        this.userHomeService.addCashTransactionRecord(record);
        map.put("code", 200);
        return map;
    }

    @RequestMapping(value={"getRedPack"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> getRedPack(String messageId, Integer userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SendPack sp = this.redPackService.queryReadPack(messageId);
        List list = this.revicePackSservice.queryRestOfRedPack(messageId);
        if (list.size() == 0) {
            map.put("code", 520);
            return map;
        }
        map.put("code", 521);
        return map;
    }

    @RequestMapping(value={"openRedPack"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> openRedPack(String messageId, Integer userId) {
        int count;
        HashMap<String, Object> map = new HashMap<String, Object>();
        SendPack sp = this.redPackService.queryReadPack(messageId);
        if (sp != null && sp.getPackStatus() == 2) {
            map.put("code", 523);
            map.put("money", 0);
            map.put("number", 0);
            map.put("sp", sp);
            map.put("list", null);
            return map;
        }
        List list = this.revicePackSservice.queryRestOfRedPack(messageId);
        if (list.size() == 0) {
            map.put("code", 520);
            map.put("money", 0);
            map.put("number", 0);
            map.put("sp", sp);
            map.put("list", null);
            return map;
        }
        for (RevicePack rp : list) {
            if (rp.getRuleUserId() == null) continue;
            if (userId.intValue() == rp.getRuleUserId().intValue()) {
                int count2 = this.revicePackSservice.updateRestOfRedPack(rp.getId(), userId);
                if (count2 == 0) continue;
                if (list.size() == 1) {
                    this.redPackService.updatePackStatus(messageId, Integer.valueOf(1));
                }
                List allList = this.revicePackSservice.queryAllRedPack(messageId);
                Amount amount = this.userHomeService.queryAmount(userId);
                double amoutReadPack = (double)rp.getMoney().intValue() / 100.0;
                double amut = amount.getAmountCount() + amoutReadPack;
                Amount am = new Amount();
                am.setAmountCount(amut);
                am.setUserId(amount.getUserId());
                am.setAmountId(amount.getAmountId());
                this.userHomeService.updAmount(am);
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                CashTransactionRecord record = new CashTransactionRecord();
                record.setCashTransactionRecordAmount(amoutReadPack);
                record.setCashTransactionRecordDate(df.format(new Date()));
                record.setCashTransactionRecordSig(Integer.valueOf(1));
                record.setCashTransactionRecordType("\u62a2\u7ea2\u5305\u8bb0\u5f55");
                record.setUserId(userId);
                record.setCashTransactionRecordCount(Integer.valueOf(1));
                record.setCashTransactionRecordOrde("001");
                this.userHomeService.addCashTransactionRecord(record);
                map.put("code", 521);
                map.put("money", rp.getMoney());
                map.put("number", list.size() - 1);
                map.put("sp", sp);
                map.put("list", allList);
                return map;
            }
            list.remove(rp);
            break;
        }
        if ((count = this.revicePackSservice.updateRestOfRedPack(((RevicePack)list.get(0)).getId(), userId)) == 0) {
            map.put("code", 522);
            map.put("money", 0);
            map.put("number", list.size());
            map.put("sp", sp);
            map.put("list", null);
            return map;
        }
        if (list.size() == 1) {
            this.redPackService.updatePackStatus(messageId, Integer.valueOf(1));
        }
        List allList = this.revicePackSservice.queryAllRedPack(messageId);
        Amount amount = this.userHomeService.queryAmount(userId);
        double amoutReadPack = (double)((RevicePack)list.get(0)).getMoney().intValue() / 100.0;
        double amut = amount.getAmountCount() + amoutReadPack;
        Amount am = new Amount();
        am.setAmountCount(amut);
        am.setUserId(amount.getUserId());
        am.setAmountId(amount.getAmountId());
        this.userHomeService.updAmount(am);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CashTransactionRecord record = new CashTransactionRecord();
        record.setCashTransactionRecordAmount(amoutReadPack);
        record.setCashTransactionRecordDate(df.format(new Date()));
        record.setCashTransactionRecordSig(Integer.valueOf(1));
        record.setCashTransactionRecordType("\u62a2\u7ea2\u5305\u8bb0\u5f55");
        record.setUserId(userId);
        record.setCashTransactionRecordCount(Integer.valueOf(1));
        record.setCashTransactionRecordOrde("001");
        this.userHomeService.addCashTransactionRecord(record);
        map.put("code", 521);
        map.put("money", ((RevicePack)list.get(0)).getMoney());
        map.put("number", list.size() - 1);
        map.put("sp", sp);
        map.put("list", allList);
        return map;
    }

    @RequestMapping(value={"queryRedPack"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryRedPack(String messageId, Integer userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = this.revicePackSservice.queryAllRedPack(messageId);
        map.put("code", 521);
        map.put("list", list);
        return map;
    }

    @RequestMapping(value={"addRedPackRule"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> addRedPackRule(@RequestBody RuleRedPack ruleRedPack) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != ruleRedPack.getUserName()) {
            User queryByUserName = this.userService.queryByUserName(ruleRedPack.getUserName());
            if (null == queryByUserName) {
                map.put("Code", 1);
                map.put("Message", "\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
                return map;
            }
            ruleRedPack.setUserId(queryByUserName.getUserId());
        }
        ruleRedPack.setId(UUID.randomUUID().toString());
        this.ruleRedPackService.addRedPackRule(ruleRedPack);
        map.put("Code", 0);
        map.put("Message", "\u65b0\u589e\u89c4\u5219\u6210\u529f");
        return map;
    }

    @RequestMapping(value={"queryRule"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryRule(String groupId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = this.ruleRedPackService.queryRule(groupId);
        map.put("list", list);
        return map;
    }

    @RequestMapping(value={"queryAllRule"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryAllRule() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = this.ruleRedPackService.queryAllRule();
        map.put("numberData", list);
        map.put("numberCount", list.size());
        map.put("Code", 0);
        map.put("Message", "\u67e5\u8be2\u6210\u529f");
        return map;
    }

    @RequestMapping(value={"deleteRule"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> deleteRule(@RequestBody RuleRedPack ruleRedPack) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.ruleRedPackService.deleteRule(ruleRedPack.getId());
        map.put("Code", 0);
        map.put("Message", "\u5220\u9664\u6210\u529f");
        return map;
    }

    @RequestMapping(value={"queryRuleById"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryRuleById(@RequestBody RuleRedPack ruleRedPack) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        RuleRedPack rr = this.ruleRedPackService.queryRuleById(ruleRedPack.getId());
        map.put("numberData", rr);
        map.put("Code", 0);
        map.put("Message", "\u67e5\u8be2\u6210\u529f");
        return map;
    }

    @RequestMapping(value={"updateRuleById"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> updateRuleById(@RequestBody RuleRedPack ruleRedPack) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != ruleRedPack.getUserName()) {
            User queryByUserName = this.userService.queryByUserName(ruleRedPack.getUserName());
            if (null == queryByUserName) {
                map.put("Code", 1);
                map.put("Message", "\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
                return map;
            }
            ruleRedPack.setUserId(queryByUserName.getUserId());
        }
        this.ruleRedPackService.updateRuleById(ruleRedPack);
        map.put("Message", "\u4fee\u6539\u6210\u529f");
        map.put("Code", 0);
        map.put("numberData", ruleRedPack);
        return map;
    }
}

