/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayFundTransToaccountTransferModel;
import com.alipay.api.domain.AlipayTradeAppPayModel;
import com.alipay.api.domain.AlipayTradePrecreateModel;
import com.alipay.api.request.AlipayFundTransToaccountTransferRequest;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradePrecreateRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.response.AlipayFundTransToaccountTransferResponse;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradePrecreateResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.bizvane.appletservice.interfaces.PayMentService;
import com.bizvane.appletservice.interfaces.UserDynamicService;
import com.bizvane.appletservice.interfaces.UserHomeService;
import com.bizvane.appletservice.interfaces.UserService;
import com.bizvane.appletservice.models.AlipayRecharge;
import com.bizvane.appletservice.models.Amount;
import com.bizvane.appletservice.models.BlackList;
import com.bizvane.appletservice.models.CashTransactionRecord;
import com.bizvane.appletservice.models.CircleCoin;
import com.bizvane.appletservice.models.CircleCoinTransaction;
import com.bizvane.appletservice.models.DataVisitor;
import com.bizvane.appletservice.models.DoNotDisturb;
import com.bizvane.appletservice.models.Follow;
import com.bizvane.appletservice.models.Friends;
import com.bizvane.appletservice.models.GiftRecord;
import com.bizvane.appletservice.models.Member;
import com.bizvane.appletservice.models.RasType;
import com.bizvane.appletservice.models.User;
import com.bizvane.appletservice.models.UserRole;
import com.bizvane.appletservice.models.Vehicle;
import com.bizvane.appletserviceimpl.utils.EndDateUtil;
import com.bizvane.appletserviceimpl.utils.FileNameUtils;
import com.bizvane.appletserviceimpl.utils.MathMunberUtil;
import com.bizvane.appletserviceimpl.utils.OSSUitl;
import com.bizvane.appletserviceimpl.utils.PropertiesUtil;
import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.notify.WxScanPayNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayAppOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayNativeOrderResult;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.bean.result.WxPayOrderQueryResult;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceApacheHttpImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u652f\u4ed8"})
@RestController
public class PayMentController {
    private static Logger log = LoggerFactory.getLogger(PayMentController.class);
    public static Map<String, Object> map = new HashMap();
    private static AlipayRecharge alipayRecharge = new AlipayRecharge();
    private static MathMunberUtil mathUtil = new MathMunberUtil();
    private WxPayConfig config = new WxPayConfig();
    private WxPayService payService = new WxPayServiceApacheHttpImpl();
    @Autowired
    private UserService userService;
    @Autowired
    private UserDynamicService dynamicService;
    @Autowired
    private PayMentService userHomeService;
    @Autowired
    private UserHomeService userHome;

    public PayMentController() {
        this.config.setAppId(PropertiesUtil.getProperty((String)"wx.appId"));
        this.config.setMchId(PropertiesUtil.getProperty((String)"wx.mchId"));
        this.config.setMchKey(PropertiesUtil.getProperty((String)"wx.mchKey"));
        this.config.setNotifyUrl(PropertiesUtil.getProperty((String)"wx.notifyUrl"));
        this.payService.setConfig(this.config);
    }

    @RequestMapping(value={"addBlackList"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> addBlackList(BlackList blackList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BlackList br = this.userHome.queryByBlackId(blackList);
        if (br == null) {
            Follow follow = new Follow();
            follow.setFollowId(blackList.getUserId());
            follow.setUserId(blackList.getBlackListId());
            Follow fl = this.dynamicService.queryByfwSig(follow);
            if (fl != null) {
                this.dynamicService.CancelFollow(fl.getFwId());
            }
            follow.setFollowId(blackList.getBlackListId());
            follow.setUserId(blackList.getUserId());
            Follow fo = this.dynamicService.queryByfwSig(follow);
            if (fo != null) {
                this.dynamicService.CancelFollow(fo.getFwId());
            }
            Friends friends = new Friends();
            friends.setFriendsId(blackList.getUserId());
            friends.setUserId(blackList.getBlackListId());
            Friends fs = this.dynamicService.queryFriends(friends);
            if (fs != null) {
                this.dynamicService.delFriends(fs.getFnId());
            }
            friends.setFriendsId(blackList.getBlackListId());
            friends.setUserId(blackList.getUserId());
            Friends fd = this.dynamicService.queryFriends(friends);
            if (fd != null) {
                this.dynamicService.delFriends(fd.getFnId());
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            blackList.setBlackListDate(df.format(new Date()));
            this.userHomeService.addBlackList(blackList);
        }
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"delBkltId"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> delBkltId(String bkltId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int bkId = Integer.parseInt(bkltId);
        this.userHomeService.delBkltId(Integer.valueOf(bkId));
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"queryBlackList"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryBlackList(Integer userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List BlackList2 = this.userHomeService.queryBlackList(userId);
        for (BlackList bk : BlackList2) {
            User user = this.userService.queryByUserTestOne(bk.getBlackListId());
            user.setRoleid(Integer.valueOf(this.userService.queryRoleId(user.getUserId().intValue())));
            bk.setUser(user);
        }
        map.put("BlackList", BlackList2);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"queryVehicle"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryVehicle(Integer userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List vehicleList = this.userHomeService.queryVehicle(userId);
        map.put("vehicleList", vehicleList);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"addVehicle"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> addVehicle(Vehicle vehicle) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.userHomeService.addVehicle(vehicle);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"delVehicle"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> delVehicle(Integer vehicleId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.userHomeService.delVehicle(vehicleId);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"addMemberAmount"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> addMember(Member member) throws ParseException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        EndDateUtil endDateUtil = new EndDateUtil();
        UserRole role = new UserRole();
        role.setUserId(member.getUserId().intValue());
        if (member.getMeberType() == 1) {
            role.setRoleId(2);
        } else {
            role.setRoleId(3);
        }
        this.userService.updUserRole(role);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        member.setMemberStartDate(df.format(new Date()));
        member.setMemberEndDate(endDateUtil.endDate(member.getMemberMoths()));
        if (member.getMemberSig() == 1) {
            Amount amount = this.userHomeService.queryAmount(member.getUserId());
            double count = amount.getAmountCount() - (double)member.getMemberAmount();
            Amount am = new Amount();
            am.setAmountCount(count);
            am.setUserId(amount.getUserId());
            am.setAmountId(amount.getAmountId());
            this.userHomeService.updAmount(am);
            this.userHomeService.addMember(member);
        }
        if (member.getMemberSig() == 2) {
            this.userHomeService.addMember(member);
        }
        if (member.getMemberSig() == 3) {
            this.userHomeService.addMember(member);
        }
        CashTransactionRecord record = new CashTransactionRecord();
        record.setCashTransactionRecordAmount((double)member.getMemberAmount());
        record.setCashTransactionRecordDate(df.format(new Date()));
        record.setCashTransactionRecordSig(member.getMemberSig());
        record.setCashTransactionRecordType("\u5f00\u901a\u4f1a\u5458");
        record.setUserId(member.getUserId());
        record.setCashTransactionRecordCount(Integer.valueOf(2));
        this.userHomeService.addCashTransactionRecord(record);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"queryMember"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryMember(Integer userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Member member = this.userHomeService.queryMember(userId);
        map.put("member", member);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"updByMemberId"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> updByMemberId(Member member) throws ParseException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Member members = this.userHomeService.queryMember(member.getUserId());
        EndDateUtil endDateUtil = new EndDateUtil();
        UserRole role = new UserRole();
        role.setUserId(member.getUserId().intValue());
        if (member.getMeberType() == 1) {
            role.setRoleId(2);
        } else {
            role.setRoleId(3);
        }
        this.userService.updUserRole(role);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        member.setMemberStartDate(df.format(new Date()));
        member.setMemberEndDate(endDateUtil.endDate(member.getMemberMoths()));
        if (member.getMemberSig() == 1) {
            Amount amount = this.userHomeService.queryAmount(member.getUserId());
            double count = amount.getAmountCount() - (double)member.getMemberAmount();
            Amount am = new Amount();
            am.setAmountCount(count);
            am.setUserId(amount.getUserId());
            am.setAmountId(amount.getAmountId());
            this.userHomeService.updAmount(am);
            member.setMemberId(members.getMemberId());
            this.userHomeService.updByMemberId(member);
        }
        if (member.getMemberSig() == 2) {
            member.setMemberId(members.getMemberId());
            this.userHomeService.updByMemberId(member);
        }
        if (member.getMemberSig() == 3) {
            member.setMemberId(members.getMemberId());
            this.userHomeService.updByMemberId(member);
        }
        CashTransactionRecord record = new CashTransactionRecord();
        record.setCashTransactionRecordAmount((double)member.getMemberAmount());
        record.setCashTransactionRecordDate(df.format(new Date()));
        record.setCashTransactionRecordSig(member.getMemberSig());
        record.setCashTransactionRecordType("\u7eed\u8d39\u4f1a\u5458");
        record.setUserId(member.getUserId());
        record.setCashTransactionRecordCount(Integer.valueOf(2));
        this.userHomeService.addCashTransactionRecord(record);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"queryMyDynamicOne"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryMyDynamic(Integer userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        UserRole userRole = this.userService.queryUserRole(userId);
        User user = this.userService.queryByUserTestOne(userId);
        Integer dataVisitorId = userId;
        List DataVisitorList = this.userHomeService.queryDataVisitorList(dataVisitorId);
        ArrayList<DataVisitor> logoutList = new ArrayList<DataVisitor>();
        for (DataVisitor dataVisitor : DataVisitorList) {
            User use = this.userService.queryByUserTestOne(dataVisitor.getUserId());
            if (use != null) {
                if (use.getUserJuli() != 3) {
                    User up = this.userService.queryByUserId(use.getUserId(), Double.valueOf(user.getLatttud()), Double.valueOf(user.getLongitud()));
                    use.setDistance(up.getDic() + "km");
                }
                Integer GiftReCordSD = this.userService.queryByGiftReCordSD(dataVisitor.getUserId());
                Integer GiftReCordSC = this.userService.queryByGiftReCordSC(dataVisitor.getUserId());
                Integer rs = null;
                Integer rq = null;
                rs = GiftReCordSD == null ? Integer.valueOf(0) : GiftReCordSD;
                rq = GiftReCordSC == null ? Integer.valueOf(0) : GiftReCordSC;
                use.setUserWealth(rs + rq / 10);
                use.setRoleid(Integer.valueOf(this.userService.queryRoleId(use.getUserId().intValue())));
                dataVisitor.setUser(use);
                continue;
            }
            logoutList.add(dataVisitor);
        }
        if (logoutList.size() > 0) {
            DataVisitorList.removeAll(logoutList);
        }
        map.put("DataVisitorUserList", DataVisitorList);
        map.put("UserRole", userRole.getRoleId());
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"delByDvtId"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> delByDvtId(Integer dvtId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.userHomeService.delByDvtId(dvtId);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"delBydataVisitorId"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> delBydataVisitorId(Integer dataVisitorId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.userHomeService.delBydataVisitorId(dataVisitorId);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"updByUserWechat"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> updByUserWechat(User user) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        User use = this.userService.queryByUserWechat(user.getUserWechat());
        if (use == null) {
            this.userService.updByUserWechat(user);
        }
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"updByUserQQ"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> updByUserQQ(User user) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        User use = this.userService.queryByUserQQ(user.getUserQQ());
        if (use == null) {
            this.userService.updByUserQQ(user);
        }
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"updByUserPayMent"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> updByUserPayMent(User user) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.userService.updByUserPayMent(user);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"myWallet"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> myWallet(Integer userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Amount amount = this.userHomeService.queryAmount(userId);
        CircleCoin circleCoin = this.userHomeService.queryCircleCoin(userId);
        Integer record = this.userHomeService.queryByGiftRecordThePrice(userId);
        if (record != null) {
            map.put("record", record / 10);
        } else {
            map.put("record", 0);
        }
        map.put("amount", amount.getAmountCount());
        map.put("circleCoin", circleCoin.getCircleCoinCount());
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"addCircleCoin"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> addCircleCoin(CircleCoinTransaction transaction, String tradeNo) throws AlipayApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (transaction.getCircleCoinTransactionSig() == 1) {
            Amount amount = this.userHomeService.queryAmount(transaction.getUserId());
            Amount am = new Amount();
            double amountByCount = transaction.getCircleCoinTransactionAmount().intValue();
            am.setAmountCount(amount.getAmountCount() - amountByCount);
            am.setAmountId(amount.getAmountId());
            am.setUserId(amount.getUserId());
            this.userHomeService.updAmount(am);
            CashTransactionRecord cashTransactionRecord = new CashTransactionRecord();
            cashTransactionRecord.setCashTransactionRecordDate(df.format(new Date()));
            cashTransactionRecord.setCashTransactionRecordAmount(amountByCount);
            cashTransactionRecord.setCashTransactionRecordType("\u4f59\u989d\u5145\u503c\u5708\u5e01");
            cashTransactionRecord.setCashTransactionRecordCount(Integer.valueOf(2));
            cashTransactionRecord.setUserId(transaction.getUserId());
            cashTransactionRecord.setCashTransactionRecordSig(transaction.getCircleCoinTransactionSig());
            cashTransactionRecord.setCashTransactionRecordOrde("111");
            this.userHomeService.addCashTransactionRecord(cashTransactionRecord);
        }
        CircleCoin circleCoin = this.userHomeService.queryCircleCoin(transaction.getUserId());
        CircleCoin coin = new CircleCoin();
        coin.setCircleCoinCount(Integer.valueOf(circleCoin.getCircleCoinCount() + transaction.getCircleCoinTransactionAmount() * 10));
        coin.setUserId(circleCoin.getUserId());
        coin.setCircleCoinId(circleCoin.getCircleCoinId());
        this.userHomeService.updCircleCoin(coin);
        transaction.setCircleCoinTransactionDate(df.format(new Date()));
        if (transaction.getCircleCoinTransactionSig() == 2) {
            transaction.setCircleCoinTransactionType("\u652f\u4ed8\u5b9d\u5708\u5e01\u5145\u503c");
        }
        if (transaction.getCircleCoinTransactionSig() == 3) {
            transaction.setCircleCoinTransactionType("\u5fae\u4fe1\u5708\u5e01\u5145\u503c");
        }
        if (transaction.getCircleCoinTransactionSig() == 1) {
            transaction.setCircleCoinTransactionType("\u4f59\u989d\u5145\u503c\u5708\u5e01");
        }
        if (transaction.getCircleCoinTransactionSig() == 4) {
            transaction.setCircleCoinTransactionType("\u5185\u8d2d\u5145\u503c\u5708\u5e01");
        }
        transaction.setCircleCoinTransactionCount("2");
        this.userHomeService.addCircleCoinTransaction(transaction);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"queryCircleCoinTransaction"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryCircleCoinTransaction(Integer userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List CircleCoinTransactionList = this.userHomeService.queryCircleCoinTransaction(userId);
        Integer transactionAmount = this.userHomeService.queryCircleRechargeAmount(userId);
        Integer coinTransactionAmount = this.userHomeService.queryCircleExpenditureAmount(userId);
        map.put("CircleCoinTransactionList", CircleCoinTransactionList);
        map.put("transactionAmount", transactionAmount);
        map.put("coinTransactionAmount", coinTransactionAmount);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"BalanceWithdrawal"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> BalanceWithdrawal(CashTransactionRecord record, String openId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Integer userId = record.getUserId();
        Amount amount = this.userHomeService.queryAmount(userId);
        if (record.getCashTransactionRecordAmount() <= amount.getAmountCount()) {
            double JE = record.getCashTransactionRecordAmount() * 0.01;
            double aqm = record.getCashTransactionRecordAmount() - JE;
            DecimalFormat dfs = new DecimalFormat("#.00");
            String total_amount = dfs.format(aqm);
            if (record.getCashTransactionRecordSig() == 1) {
                String outNo = mathUtil.getGroupId();
                User user = this.userService.queryByUserTestOne(userId);
                DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", alipayRecharge.getAPP_ID(), alipayRecharge.getAPP_PRIVATE_KEY(), "json", alipayRecharge.getCHARSET(), alipayRecharge.getALIPAY_PUBLIC_KEY1(), "RSA2");
                AlipayFundTransToaccountTransferRequest request = new AlipayFundTransToaccountTransferRequest();
                AlipayFundTransToaccountTransferModel model = new AlipayFundTransToaccountTransferModel();
                model.setOutBizNo(outNo);
                model.setPayeeType("ALIPAY_USERID");
                model.setPayeeAccount(user.getUserPayMent());
                model.setAmount(total_amount);
                model.setPayerShowName("\u4e0a\u6d77\u742a\u94a6\u79d1\u6280\u6709\u9650\u516c\u53f8");
                model.setPayerRealName("");
                model.setRemark("\u5728\u7ebf\u5708\u5b50\u4f59\u989d\u63d0\u73b0");
                request.setBizModel((AlipayObject)model);
                try {
                    AlipayFundTransToaccountTransferResponse response = (AlipayFundTransToaccountTransferResponse)alipayClient.execute((AlipayRequest)request);
                    String body = response.getBody();
                    System.out.println(body);
                    String code = response.getCode();
                    if (!code.equals("10000")) {
                        map.put("errCode", 1000);
                        return map;
                    }
                    Amount am = new Amount();
                    am.setAmountCount(amount.getAmountCount() - record.getCashTransactionRecordAmount());
                    am.setAmountId(amount.getAmountId());
                    am.setUserId(amount.getUserId());
                    this.userHomeService.updAmount(am);
                }
                catch (AlipayApiException e) {
                    e.printStackTrace();
                }
            }
            if (record.getCashTransactionRecordSig() == 2) {
                // empty if block
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            record.setCashTransactionRecordDate(df.format(new Date()));
            record.setCashTransactionRecordType("\u4f59\u989d\u63d0\u73b0");
            record.setCashTransactionRecordCount(Integer.valueOf(2));
            record.setCashTransactionRecordOrde(mathUtil.getId());
            this.userHomeService.addCashTransactionRecord(record);
            map.put("errCode", 200);
        } else {
            map.put("errCode", 1000);
        }
        return map;
    }

    @RequestMapping(value={"queryRasType"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryRasType(String rasAppId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        RasType rasType = this.userHomeService.queryRasType(rasAppId);
        map.put("rasType", rasType);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"AlipayRecharge"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> AlipayRecharge(String Amount2) throws AlipayApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", alipayRecharge.getAPP_ID(), alipayRecharge.getAPP_PRIVATE_KEY(), "json", alipayRecharge.getCHARSET(), alipayRecharge.getALIPAY_PUBLIC_KEY(), "RSA2");
        AlipayTradeAppPayRequest request = new AlipayTradeAppPayRequest();
        AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
        model.setBody("\u6211\u662f\u6d4b\u8bd5\u6570\u636e");
        model.setSubject("\u5728\u7ebf\u5708\u5b50\u5145\u503c");
        model.setOutTradeNo(mathUtil.getId());
        model.setTimeoutExpress("30m");
        model.setTotalAmount(Amount2);
        model.setProductCode("QUICK_MSECURITY_PAY");
        request.setBizModel((AlipayObject)model);
        request.setNotifyUrl("http://www.linequan.com:8080/app-manage-web/app/appPayl");
        AlipayTradeAppPayResponse response = (AlipayTradeAppPayResponse)alipayClient.sdkExecute((AlipayRequest)request);
        String orderString = response.getBody().toString();
        map.put("orderString", orderString);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"appPayl"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> appPayl(AlipayTradeQueryResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        System.out.println(response);
        System.out.println("\u56de\u6389\u6210\u529f");
        System.out.print(response.getBody());
        return map;
    }

    @ApiOperation(value="\u652f\u4ed8\u5b9d\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355")
    @RequestMapping(value={"alipayF2FRecharge"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> alipayF2FRecharge(String Amount2) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", alipayRecharge.getAPP_ID(), alipayRecharge.getAPP_PRIVATE_KEY(), "json", alipayRecharge.getCHARSET(), "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAk43MaMrzfHuCrk6yWEypC/t7nvZz84fZaPy4KkWjAnONGAJSAkHP352cxOQuZ0AYHvEFfKg3f2uEMzdC5jbYRdQTmYn+LgSrLQZeXYpTRgoLbEWhcp0B+xr8QxxoZWd0unpEqIKXeDFCAsbeLWx0hL6UFRjt7TO6NvG8v7SfHs3/1l+RTqTpjx/5YVn73UocanPEBy6yuadGezf2u2MLMV505B/sXDgoSEEJ4dI9P+dKN2XnuvS8oaElfOJ0cFPs2MRkWfqpLqo3cWiRc/FpJuHhwT5WDTJWI5XhRJwDLnObXgo5rOaN5+OMvCIO1hGGCz7co+J/4y0CfXKJKrFmPQIDAQAB", "RSA2");
        AlipayTradePrecreateRequest request = new AlipayTradePrecreateRequest();
        AlipayTradePrecreateModel model = new AlipayTradePrecreateModel();
        model.setBody("\u652f\u4ed8\u5b9d\u626b\u7801\u652f\u4ed8");
        model.setSubject("\u5728\u7ebf\u5708\u5b50\u652f\u4ed8\u5b9d\u626b\u7801\u5145\u503c");
        model.setOutTradeNo(mathUtil.getId());
        model.setTimeoutExpress("30m");
        model.setTotalAmount(Amount2);
        request.setBizModel((AlipayObject)model);
        request.setNotifyUrl("http://www.linequan.com:8080/app-manage-web/app/appPayl");
        try {
            AlipayTradePrecreateResponse response = (AlipayTradePrecreateResponse)alipayClient.execute((AlipayRequest)request);
            if (response != null && "10000".equals(response.getCode())) {
                log.info("\u652f\u4ed8\u5b9d\u9884\u4e0b\u5355\u6210\u529f");
                this.dumpResponse((AlipayResponse)response);
                String codeStr = response.getQrCode();
                byte[] qrCode = this.createScanPayQrcodeMode2(codeStr, null, null);
                String codeUrl = OSSUitl.uploadQrcode((byte[])qrCode, (String)(response.getOutTradeNo() + ".jpg"), (long)1800000L);
                map.put("codeUrl", codeUrl);
                map.put("errCode", 10000);
            } else if (response == null || "20000".equals(response.getCode())) {
                log.error("\u7cfb\u7edf\u5f02\u5e38\uff0c\u9884\u4e0b\u5355\u72b6\u6001\u672a\u77e5!!!");
                map.put("errCode", 20000);
                map.put("errMsg", "\u7cfb\u7edf\u5f02\u5e38\uff0c\u9884\u4e0b\u5355\u72b6\u6001\u672a\u77e5!!!");
            } else {
                log.error("\u652f\u4ed8\u5b9d\u9884\u4e0b\u5355\u5931\u8d25!!!");
                map.put("errCode", 40004);
                map.put("errMsg", "\u652f\u4ed8\u5b9d\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\u5931\u8d25!!!");
            }
        }
        catch (AlipayApiException e) {
            map.put("errCode", 500);
            map.put("errMsg", "\u652f\u4ed8\u5b9d\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\u9519\u8bef");
            log.error("\u652f\u4ed8\u5b9d\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\u9519\u8bef", (Throwable)e);
        }
        catch (IOException e) {
            map.put("errCode", 500);
            map.put("errMsg", "\u4e8c\u7ef4\u7801\u4e0a\u4f20\u5931\u8d25");
            e.printStackTrace();
        }
        return map;
    }

    @ApiIgnore
    private void dumpResponse(AlipayResponse response) {
        if (response != null) {
            log.info(String.format("code:%s, msg:%s", response.getCode(), response.getMsg()));
            if (StringUtils.isNotEmpty((CharSequence)response.getSubCode())) {
                log.info(String.format("subCode:%s, subMsg:%s", response.getSubCode(), response.getSubMsg()));
            }
            log.info("body:" + response.getBody());
        }
    }

    @RequestMapping(value={"queryAlipayRechargeSig"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryAlipayRecharge(String tradeNo, CashTransactionRecord record) throws AlipayApiException {
        HashMap<String, Object> map;
        block9: {
            map = new HashMap<String, Object>();
            CashTransactionRecord casTranion = this.userHome.quyerCashTransactionRecordOrde(tradeNo);
            if (casTranion == null) {
                if (record.getCashTransactionRecordSig() == 2) {
                    DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", alipayRecharge.getAPP_ID(), alipayRecharge.getAPP_PRIVATE_KEY(), "json", alipayRecharge.getCHARSET(), alipayRecharge.getALIPAY_PUBLIC_KEY1(), "RSA2");
                    AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
                    request.setBizContent("{\"trade_no\":\"" + tradeNo + "\"}");
                    AlipayTradeQueryResponse response = (AlipayTradeQueryResponse)alipayClient.execute((AlipayRequest)request);
                    System.out.print(response.getBody());
                    String result = response.getBody();
                    JSONObject jsonObject = JSONObject.parseObject((String)result);
                    String msg = jsonObject.getJSONObject("alipay_trade_query_response").getString("msg");
                    String amountPay = response.getTotalAmount();
                    double amoutPayZFB = Double.parseDouble(amountPay);
                    if (msg != null) {
                        Integer userId = record.getUserId();
                        Amount amount = this.userHomeService.queryAmount(userId);
                        Amount am = new Amount();
                        am.setAmountCount(amount.getAmountCount() + amoutPayZFB);
                        am.setAmountId(amount.getAmountId());
                        am.setUserId(amount.getUserId());
                        this.userHomeService.updAmount(am);
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        record.setCashTransactionRecordDate(df.format(new Date()));
                        record.setCashTransactionRecordType("\u652f\u4ed8\u5b9d\u5145\u503c");
                        record.setCashTransactionRecordCount(Integer.valueOf(1));
                        record.setCashTransactionRecordAmount(amoutPayZFB);
                        record.setCashTransactionRecordOrde(tradeNo);
                        this.userHomeService.addCashTransactionRecord(record);
                        map.put("errCode", 200);
                    } else {
                        map.put("msg", "\u5145\u503c\u5931\u8d25");
                    }
                } else {
                    WxPayConfig config = new WxPayConfig();
                    WxPayServiceApacheHttpImpl payService = new WxPayServiceApacheHttpImpl();
                    config.setAppId("wx93c9f1e2cccfcb48");
                    config.setMchId("1512983831");
                    config.setMchKey("woShizsL332623QuanziZaixian75041");
                    payService.setConfig(config);
                    try {
                        WxPayOrderQueryResult wxPayOrderQueryResult = payService.queryOrder(null, tradeNo);
                        if (wxPayOrderQueryResult.getTradeState().equals("SUCCESS")) {
                            Integer totalFee = wxPayOrderQueryResult.getTotalFee() / 100;
                            Integer userId = record.getUserId();
                            Amount amount = this.userHomeService.queryAmount(userId);
                            Amount am = new Amount();
                            am.setAmountCount(amount.getAmountCount() + (double)totalFee.intValue());
                            am.setAmountId(amount.getAmountId());
                            am.setUserId(amount.getUserId());
                            this.userHomeService.updAmount(am);
                            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            record.setCashTransactionRecordDate(df.format(new Date()));
                            record.setCashTransactionRecordType("\u5fae\u4fe1\u5145\u503c");
                            record.setCashTransactionRecordCount(Integer.valueOf(1));
                            record.setCashTransactionRecordAmount((double)totalFee.intValue());
                            record.setCashTransactionRecordOrde(tradeNo);
                            this.userHomeService.addCashTransactionRecord(record);
                            map.put("errCode", 200);
                            System.out.println(totalFee);
                            System.out.println(wxPayOrderQueryResult);
                            break block9;
                        }
                        map.put("msg", "\u5145\u503c\u5931\u8d25");
                    }
                    catch (WxPayException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                map.put("msg", "\u8bb0\u5f55\u5df2\u7ecf\u5b58\u5728");
            }
        }
        return map;
    }

    @RequestMapping(value={"queryWebAlipayRechargeSig"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryWebAlipayRechargeSig(String tradeNo, CashTransactionRecord record) throws AlipayApiException {
        HashMap<String, Object> map;
        block9: {
            map = new HashMap<String, Object>();
            CashTransactionRecord casTranion = this.userHome.quyerCashTransactionRecordOrde(tradeNo);
            if (casTranion == null) {
                if (record.getCashTransactionRecordSig() == 2) {
                    DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", alipayRecharge.getAPP_ID(), alipayRecharge.getAPP_PRIVATE_KEY(), "json", alipayRecharge.getCHARSET(), alipayRecharge.getALIPAY_PUBLIC_KEY1(), "RSA2");
                    AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
                    request.setBizContent("{\"trade_no\":\"" + tradeNo + "\"}");
                    AlipayTradeQueryResponse response = (AlipayTradeQueryResponse)alipayClient.execute((AlipayRequest)request);
                    System.out.print(response.getBody());
                    String result = response.getBody();
                    JSONObject jsonObject = JSONObject.parseObject((String)result);
                    String msg = jsonObject.getJSONObject("alipay_trade_query_response").getString("msg");
                    String amountPay = response.getTotalAmount();
                    double amoutPayZFB = Double.parseDouble(amountPay);
                    if (msg != null) {
                        Integer userId = record.getUserId();
                        Amount amount = this.userHomeService.queryAmount(userId);
                        Amount am = new Amount();
                        am.setAmountCount(amount.getAmountCount() + amoutPayZFB);
                        am.setAmountId(amount.getAmountId());
                        am.setUserId(amount.getUserId());
                        this.userHomeService.updAmount(am);
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        record.setCashTransactionRecordDate(df.format(new Date()));
                        record.setCashTransactionRecordType("\u652f\u4ed8\u5b9d\u5145\u503c");
                        record.setCashTransactionRecordCount(Integer.valueOf(1));
                        record.setCashTransactionRecordAmount(amoutPayZFB);
                        record.setCashTransactionRecordOrde(tradeNo);
                        this.userHomeService.addCashTransactionRecord(record);
                        map.put("errCode", 200);
                    } else {
                        map.put("msg", "\u5145\u503c\u5931\u8d25");
                    }
                } else {
                    WxPayConfig config = new WxPayConfig();
                    WxPayServiceApacheHttpImpl payService = new WxPayServiceApacheHttpImpl();
                    config.setAppId("wx93c9f1e2cccfcb48");
                    config.setMchId("1512983831");
                    config.setMchKey("woShizsL332623QuanziZaixian75041");
                    payService.setConfig(config);
                    try {
                        WxPayOrderQueryResult wxPayOrderQueryResult = payService.queryOrder(null, tradeNo);
                        if (wxPayOrderQueryResult.getTradeState().equals("SUCCESS")) {
                            Integer totalFee = wxPayOrderQueryResult.getTotalFee() / 100;
                            Integer userId = record.getUserId();
                            Amount amount = this.userHomeService.queryAmount(userId);
                            Amount am = new Amount();
                            am.setAmountCount(amount.getAmountCount() + (double)totalFee.intValue());
                            am.setAmountId(amount.getAmountId());
                            am.setUserId(amount.getUserId());
                            this.userHomeService.updAmount(am);
                            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            record.setCashTransactionRecordDate(df.format(new Date()));
                            record.setCashTransactionRecordType("\u5fae\u4fe1\u5145\u503c");
                            record.setCashTransactionRecordCount(Integer.valueOf(1));
                            record.setCashTransactionRecordAmount((double)totalFee.intValue());
                            record.setCashTransactionRecordOrde(tradeNo);
                            this.userHomeService.addCashTransactionRecord(record);
                            map.put("errCode", 200);
                            System.out.println(totalFee);
                            System.out.println(wxPayOrderQueryResult);
                            break block9;
                        }
                        map.put("msg", "\u5145\u503c\u5931\u8d25");
                    }
                    catch (WxPayException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                map.put("msg", "\u8bb0\u5f55\u5df2\u7ecf\u5b58\u5728");
            }
        }
        return map;
    }

    @RequestMapping(value={"queryWebRechargeAmount"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryWebRechargeAmount(double userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int uId = new Double(userId).intValue();
        List CashTransaList = this.userHome.queryUserIdListCount(Integer.valueOf(uId));
        if (CashTransaList.size() > 0) {
            double RechargeAmount = this.userHome.queryRechargeAmount(userId);
            map.put("RechargeAmount", RechargeAmount);
        } else {
            map.put("RechargeAmount", 0);
        }
        List CashTList = this.userHome.queryUserIdListCountTwo(Integer.valueOf(uId));
        if (CashTList.size() > 0) {
            double ExpenditureAmount = this.userHome.queryExpenditureAmount(userId);
            map.put("ExpenditureAmount", ExpenditureAmount);
        } else {
            map.put("ExpenditureAmount", 0);
        }
        List CashTransactionRecordList = this.userHome.queryByCashTransactionRecordUserId(userId);
        map.put("CashTransactionRecordList", CashTransactionRecordList);
        return map;
    }

    @RequestMapping(value={"queryRechargeAmount"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryRechargeAmount(double userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int uId = new Double(userId).intValue();
        List CashTransaList = this.userHome.queryUserIdListCount(Integer.valueOf(uId));
        if (CashTransaList.size() > 0) {
            double RechargeAmount = this.userHome.queryRechargeAmount(userId);
            map.put("RechargeAmount", RechargeAmount);
        } else {
            map.put("RechargeAmount", 0);
        }
        List CashTList = this.userHome.queryUserIdListCountTwo(Integer.valueOf(uId));
        if (CashTList.size() > 0) {
            double ExpenditureAmount = this.userHome.queryExpenditureAmount(userId);
            map.put("ExpenditureAmount", ExpenditureAmount);
        } else {
            map.put("ExpenditureAmount", 0);
        }
        List CashTransactionRecordList = this.userHome.queryByCashTransactionRecordUserId(userId);
        map.put("CashTransactionRecordList", CashTransactionRecordList);
        return map;
    }

    @RequestMapping(value={"RedEnvelopeAppAmount"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> RedEnvelopeAppAmount(String tradeNo, CashTransactionRecord record) throws AlipayApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", alipayRecharge.getAPP_ID(), alipayRecharge.getAPP_PRIVATE_KEY(), "json", alipayRecharge.getCHARSET(), alipayRecharge.getALIPAY_PUBLIC_KEY1(), "RSA2");
        AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
        request.setBizContent("{\"trade_no\":\"" + tradeNo + "\"}");
        AlipayTradeQueryResponse response = (AlipayTradeQueryResponse)alipayClient.execute((AlipayRequest)request);
        System.out.print(response.getBody());
        String result = response.getBody();
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        String msg = jsonObject.getJSONObject("alipay_trade_query_response").getString("msg");
        if (msg != null) {
            Integer userId = record.getUserId();
            if (record.getCashTransactionRecordSig() == 1) {
                Amount amount = this.userHomeService.queryAmount(userId);
                Amount am = new Amount();
                am.setAmountCount(amount.getAmountCount() - record.getCashTransactionRecordAmount());
                am.setAmountId(amount.getAmountId());
                am.setUserId(amount.getUserId());
                this.userHomeService.updAmount(am);
                record.setCashTransactionRecordType("\u4f59\u989d\u7ea2\u5305\u5145\u503c\u5145\u503c");
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            record.setCashTransactionRecordDate(df.format(new Date()));
            if (record.getCashTransactionRecordSig() == 3) {
                record.setCashTransactionRecordType("\u5fae\u4fe1\u5145\u503c");
            } else {
                record.setCashTransactionRecordType("\u652f\u4ed8\u5b9d\u7ea2\u5305\u5145\u503c\u5145\u503c");
            }
            record.setCashTransactionRecordCount(Integer.valueOf(2));
            this.userHomeService.addCashTransactionRecord(record);
            map.put("errCode", 200);
        } else {
            map.put("msg", "\u5145\u503c\u5931\u8d25");
        }
        return map;
    }

    @RequestMapping(value={"queryByGiftRecordSig"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryByGiftRecordSig(Integer ReceiveGiftsId, CashTransactionRecord record) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String total_amount = String.valueOf(record.getCashTransactionRecordAmount());
        if (record.getCashTransactionRecordSig() == 1) {
            Amount amount = this.userHomeService.queryAmount(ReceiveGiftsId);
            Amount am = new Amount();
            am.setAmountCount(amount.getAmountCount() + record.getCashTransactionRecordAmount());
            am.setAmountId(amount.getAmountId());
            am.setUserId(amount.getUserId());
            this.userHomeService.updAmount(am);
        }
        this.userHomeService.updByGiftRecordId(ReceiveGiftsId);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        record.setCashTransactionRecordDate(df.format(new Date()));
        record.setCashTransactionRecordType("\u793c\u7269\u4f59\u989d\u63d0\u73b0");
        record.setCashTransactionRecordCount(Integer.valueOf(1));
        record.setCashTransactionRecordSig(record.getCashTransactionRecordSig());
        record.setUserId(ReceiveGiftsId);
        record.setCashTransactionRecordOrde(" ");
        this.userHomeService.addCashTransactionRecord(record);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"queryGifRecord"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryGifRecord(String ReceiveGifts) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int ReceiveGiftsId = Integer.parseInt(ReceiveGifts);
        List GiftRecordList = this.userHome.queryGifRecord(Integer.valueOf(ReceiveGiftsId));
        map.put("GiftRecordList", GiftRecordList);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"addGifRecord"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> addGifRecord(GiftRecord giftRecord) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CircleCoin circleCoin = this.userHomeService.queryCircleCoin(giftRecord.getUserId());
        int circleCoinCount = Integer.parseInt(giftRecord.getGiftRecordThePrice());
        System.out.println(circleCoinCount + " ---------------------------------------");
        if (circleCoin.getCircleCoinCount() >= circleCoinCount) {
            CircleCoin coin = new CircleCoin();
            int ThePriceAmount = Integer.parseInt(giftRecord.getGiftRecordThePrice());
            coin.setCircleCoinCount(Integer.valueOf(circleCoin.getCircleCoinCount() - ThePriceAmount));
            coin.setUserId(circleCoin.getUserId());
            coin.setCircleCoinId(circleCoin.getCircleCoinId());
            this.userHomeService.updCircleCoin(coin);
            CircleCoinTransaction transaction = new CircleCoinTransaction();
            transaction.setUserId(giftRecord.getUserId());
            transaction.setCircleCoinTransactionAmount(Integer.valueOf(ThePriceAmount));
            transaction.setCircleCoinTransactionCount("1");
            transaction.setCircleCoinTransactionSig(Integer.valueOf(1));
            transaction.setCircleCoinTransactionType("\u5708\u5e01\u8d60\u9001\u793c\u7269");
            transaction.setCircleCoinTransactionDate(df.format(new Date()));
            this.userHomeService.addCircleCoinTransaction(transaction);
            giftRecord.setGiftRecordDate(df.format(new Date()));
            giftRecord.setGiftRecordSig("0");
            this.userHome.addGifRecord(giftRecord);
            map.put("errCode", 200);
        } else {
            map.put("errCode", 1000);
        }
        return map;
    }

    @RequestMapping(value={"queryAmountGift"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryAmountGift(String ReceiveGifts) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int ReceiveGiftsId = Integer.parseInt(ReceiveGifts);
        List giftRecordList = this.userHomeService.queryGiftTheachAmount(Integer.valueOf(ReceiveGiftsId));
        if (giftRecordList.size() > 0) {
            Integer record = this.userHomeService.queryByGiftRecordThePrice(Integer.valueOf(ReceiveGiftsId));
            if (record == null) {
                map.put("record", 0);
            } else {
                map.put("record", record / 10);
            }
            Integer giftCountAmount = this.userHomeService.queryAmountRecThe(Integer.valueOf(ReceiveGiftsId));
            if (giftCountAmount == null) {
                map.put("giftCountAmount", 0);
            } else {
                map.put("giftCountAmount", giftCountAmount / 10);
            }
            if (record != null || giftCountAmount != null) {
                Integer TaxAmount = giftCountAmount - record;
                map.put("TaxAmount", TaxAmount / 10);
            } else {
                map.put("TaxAmount", 0);
            }
            List giftRecord = this.userHomeService.queryListType(Integer.valueOf(ReceiveGiftsId));
            if (giftRecord.size() > 0) {
                Integer withdrawAmount = this.userHomeService.queryAmountCount(Integer.valueOf(ReceiveGiftsId));
                map.put("withdrawAmount", withdrawAmount / 10);
            } else {
                map.put("withdrawAmount", 0);
            }
        } else {
            map.put("withdrawAmount", 0);
            map.put("record", 0);
            map.put("giftCountAmount", 0);
            map.put("TaxAmount", 0);
        }
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"addDoNotDisturb"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> addDoNotDisturb(String doNotDisturbBeUserId, String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int doNotDisturbBy = Integer.parseInt(doNotDisturbBeUserId);
        int uId = Integer.parseInt(userId);
        DoNotDisturb disturb = new DoNotDisturb();
        disturb.setDoNotDisturbBeUserId(Integer.valueOf(doNotDisturbBy));
        disturb.setUserId(Integer.valueOf(uId));
        this.userHomeService.addDoNotDisturb(disturb);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"delByDoNotDisturbId"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> delByDoNotDisturbId(String doNotDisturbBeUserId, String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DoNotDisturb doNotDisturbId = new DoNotDisturb();
        int doNotDisturbById = Integer.parseInt(doNotDisturbBeUserId);
        int uId = Integer.parseInt(userId);
        doNotDisturbId.setDoNotDisturbBeUserId(Integer.valueOf(doNotDisturbById));
        doNotDisturbId.setUserId(Integer.valueOf(uId));
        this.userHomeService.delDoNotDisturbId(doNotDisturbId);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"delBySupperId"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> delBySupperId(DataVisitor dataVisitor) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.userHomeService.delBySupperId(dataVisitor);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"queryByUserNameBar"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryByUserNameBar(String userName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        User user = this.userService.queryByUserName(userName);
        if (user != null) {
            user.setRoleid(Integer.valueOf(this.userService.queryRoleId(user.getUserId().intValue())));
        }
        map.put("errCode", 200);
        map.put("user", user);
        return map;
    }

    @RequestMapping(value={"WayPayQuanYou"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="app\u652f\u4ed8\u9884\u4e0b\u5355", notes="\u5fae\u4fe1app\u652f\u4ed8\u9884\u4e0b\u5355")
    public Map<String, Object> WayPayQuanYou(Integer totalFee) throws WxPayException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String orType = FileNameUtils.getFileName();
        WxPayAppOrderResult result = (WxPayAppOrderResult)this.payService.createOrder(WxPayUnifiedOrderRequest.newBuilder().body("\u5728\u7ebf\u5708\u5b50-\u652f\u4ed8\u6d4b\u8bd5").totalFee(Integer.valueOf(totalFee * 100)).spbillCreateIp("11.1.11.1").notifyUrl("http://www.linequan.com:8080/app-manage-web/app/notify/order").tradeType("APP").outTradeNo(orType).build());
        System.out.println(result.toString());
        map.put("wayPay", result);
        map.put("orType", orType);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"queryWayPayQuanYou"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> queryWayPayQuanYou(String outTradeNo) throws WxPayException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        WxPayOrderQueryResult wxPayOrderQueryResult = this.payService.queryOrder(null, outTradeNo);
        Integer totalFee = wxPayOrderQueryResult.getTotalFee();
        System.out.println(totalFee);
        System.out.println(wxPayOrderQueryResult);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"notify/order"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="app\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u5904\u7406")
    public String parseOrderNotifyResult(@RequestBody String xmlData) throws WxPayException {
        WxPayOrderNotifyResult notifyResult = this.payService.parseOrderNotifyResult(xmlData);
        return WxPayNotifyResponse.success((String)"\u6210\u529f");
    }

    @RequestMapping(value={"createOrder"}, method={RequestMethod.POST})
    public <T> T createOrder(WxPayUnifiedOrderRequest request) throws WxPayException {
        return (T)this.payService.createOrder(request);
    }

    @RequestMapping(value={"createNative"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355", notes="\u5fae\u4fe1\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355")
    public Map<String, Object> createNative(Integer totalFee) {
        WxPayNativeOrderResult result = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            String outTradeNo = FileNameUtils.getFileName();
            result = (WxPayNativeOrderResult)this.payService.createOrder(WxPayUnifiedOrderRequest.newBuilder().body("\u5728\u7ebf\u5708\u5b50-\u626b\u63cf\u652f\u4ed8").totalFee(totalFee).productId("zxqz000001").spbillCreateIp("1.1.1.1").tradeType("NATIVE").outTradeNo(outTradeNo).sceneInfo("{'store_info':{'id': '\u5728\u7ebf\u5708\u5b50','name': '\u5728\u7ebf\u5708\u5b50-\u5408\u80a5\u5206\u90e8','area_code': '10010','address': '\u4e2d\u56fd\u4e0a\u6d77' }}").build());
            log.info("\u3010\u5fae\u4fe1\u652f\u4ed8\u3011\u5fae\u4fe1\u626b\u7801\u652f\u4ed8\u9884\u4e0b\u5355\uff1a{}", (Object)JSONObject.toJSONString((Object)result));
            byte[] qrCode = this.createScanPayQrcodeMode2(result.getCodeUrl(), null, null);
            String codeUrl = OSSUitl.uploadQrcode((byte[])qrCode, (String)(outTradeNo + ".jpg"), (long)0x6DDD00L);
            map.put("codeUrl", codeUrl);
            map.put("errCode", 200);
        }
        catch (WxPayException e) {
            log.error(e.getReturnMsg());
            log.error(e.getCustomErrorMsg());
            map.put("errMsg", e.getCustomErrorMsg());
            map.put("errCode", 500);
            log.error("\u5fae\u4fe1\u652f\u4ed8\u9884\u4e0b\u5355\u9519\u8bef", (Throwable)e);
        }
        catch (IOException e) {
            map.put("errCode", 500);
            map.put("errMsg", "\u4e8c\u7ef4\u7801\u4e0a\u4f20\u5931\u8d25");
            log.error("\u5fae\u4fe1\u652f\u4ed8\u9884\u4e0b\u5355\u4e8c\u7ef4\u7801\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
        }
        return map;
    }

    @ApiIgnore
    public byte[] createScanPayQrcodeMode2(String codeUrl, File logoFile, Integer sideLength) {
        return this.payService.createScanPayQrcodeMode2(codeUrl, logoFile, sideLength);
    }

    @RequestMapping(value={"/getQrcodeMode2"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u626b\u7801\u652f\u4ed8\u6a21\u5f0f\u4e8c\u751f\u6210\u4e8c\u7ef4\u7801")
    public byte[] getQrcodeMode2(String codeUrl, Integer sideLength, HttpServletResponse response) {
        return this.createScanPayQrcodeMode2(codeUrl, null, sideLength);
    }

    @RequestMapping(value={"notify/scanpay"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u626b\u7801\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u5904\u7406", response=String.class)
    public String parseScanPayNotifyResult(@RequestBody String xmlData) throws WxPayException {
        WxScanPayNotifyResult result = this.payService.parseScanPayNotifyResult(xmlData);
        log.info("\u3010\u5fae\u4fe1\u652f\u4ed8\u3011\u5f02\u6b65\u901a\u77e5,\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)result));
        return WxPayNotifyResponse.success((String)"OK");
    }
}

