/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.utils;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RSAUtil {
    static Logger LOG = LoggerFactory.getLogger(RSAUtil.class);
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private static final String KEY_ALGORITHM = "RSA";

    public static boolean verify(String text, String sign, String publicKey) {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            PublicKey key = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64.decodeBase64((String)publicKey)));
            signature.initVerify(key);
            signature.update(text.getBytes());
            return signature.verify(Base64.decodeBase64((String)sign));
        }
        catch (Exception e) {
            LOG.error("\u9a8c\u7b7e\u5931\u8d25:text={},sign={}", (Object)text, (Object)sign);
            LOG.error("\u9a8c\u7b7e\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public static String sign(String text, String privateKey) {
        byte[] keyBytes = Base64.decodeBase64((String)privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(privateK);
            signature.update(text.getBytes());
            byte[] result = signature.sign();
            return Base64.encodeBase64String((byte[])result);
        }
        catch (Exception e) {
            LOG.error("\u7b7e\u540d\u5931\u8d25,text={}", (Object)text, (Object)e);
            return null;
        }
    }

    public static String encrypt(String publicKey, String plainTextData) {
        if (publicKey == null) {
            LOG.error("\u52a0\u5bc6\u516c\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
            return null;
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("RSA");
            cipher.init(1, RSAUtil.getPublicKey((String)publicKey));
            byte[] output = cipher.doFinal(plainTextData.getBytes());
            return Base64.encodeBase64String((byte[])output);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("\u65e0\u6b64\u52a0\u5bc6\u7b97\u6cd5", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            LOG.error("NoSuchPadding\u9519\u8bef,\u8bf7\u68c0\u67e5", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            LOG.error("\u52a0\u5bc6\u516c\u94a5\u975e\u6cd5,\u8bf7\u68c0\u67e5", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            LOG.error("\u660e\u6587\u957f\u5ea6\u975e\u6cd5", (Throwable)e);
        }
        catch (BadPaddingException e) {
            LOG.error("\u660e\u6587\u6570\u636e\u5df2\u635f\u574f", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("\u5176\u4ed6\u9519\u8bef,\u8bf7\u68c0\u67e5", (Throwable)e);
        }
        return null;
    }

    public static String decrypt(String privateKey, String cipherData) {
        if (privateKey == null) {
            LOG.error("\u89e3\u5bc6\u79c1\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
            return null;
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("RSA");
            cipher.init(2, RSAUtil.getPrivateKey((String)privateKey));
            byte[] output = cipher.doFinal(Base64.decodeBase64((String)cipherData));
            return new String(output);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("\u65e0\u6b64\u89e3\u5bc6\u7b97\u6cd5", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            LOG.error("NoSuchPadding\u9519\u8bef,\u8bf7\u68c0\u67e5", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            LOG.error("\u89e3\u5bc6\u79c1\u94a5\u975e\u6cd5,\u8bf7\u68c0\u67e5", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            LOG.error("\u5bc6\u6587\u957f\u5ea6\u975e\u6cd5", (Throwable)e);
        }
        catch (BadPaddingException e) {
            LOG.error("\u5bc6\u6587\u6570\u636e\u5df2\u635f\u574f", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("\u5176\u4ed6\u9519\u8bef,\u8bf7\u68c0\u67e5", (Throwable)e);
        }
        return null;
    }

    public static PrivateKey getPrivateKey(String privateKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        byte[] decodedKey = Base64.decodeBase64((String)privateKey);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(decodedKey);
        return keyFactory.generatePrivate(keySpec);
    }

    public static PublicKey getPublicKey(String publicKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        byte[] decodedKey = Base64.decodeBase64((String)publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(decodedKey);
        return keyFactory.generatePublic(keySpec);
    }
}

