/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.utils;

import com.bizvane.appletserviceimpl.utils.JSONException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.text.DateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JsonUtil.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static void setDateFormat(DateFormat dateFormat) {
        mapper.setDateFormat(dateFormat);
    }

    public static String toJson(Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            LOG.error("to json exception.", (Throwable)e);
            throw new JSONException("\u628a\u5bf9\u8c61\u8f6c\u6362\u4e3aJSON\u65f6\u51fa\u9519\u4e86", (Throwable)e);
        }
    }

    static {
        mapper.enable(SerializationFeature.WRITE_NULL_MAP_VALUES);
        mapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
    }
}

