/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.system;

import com.alibaba.fastjson.JSON;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@ServerEndpoint(value="/websocket/{sid}")
@Component
public class WebSocketServer {
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    private static int onlineCount;
    static Logger logger;
    private static CopyOnWriteArraySet<WebSocketServer> webSocketSet;
    private Session session;
    private String sid = "";

    @OnOpen
    public void onOpen(Session session, @PathParam(value="sid") String sid) {
        this.session = session;
        webSocketSet.add(this);
        logger.info("\u6709\u65b0\u7a97\u53e3\u5f00\u59cb\u76d1\u542c:" + sid);
        this.sid = sid;
        try {
            WebSocketServer.addOnlineCount();
            this.sendMessage("\u8fde\u63a5\u6210\u529f");
        }
        catch (IOException e) {
            logger.error("websocket IO\u5f02\u5e38");
        }
    }

    @OnClose
    public void onClose() {
        webSocketSet.remove(this);
        WebSocketServer.subOnlineCount();
        logger.info("\u6709\u4e00\u8fde\u63a5\u5173\u95ed!  \u5f53\u524d\u5728\u7ebf\u4f1a\u8bdd\u6570===" + WebSocketServer.getOnlineCount());
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        logger.info("\u6536\u5230\u6765\u81ea\u7a97\u53e3" + this.sid + "\u7684\u4fe1\u606f:" + message);
        for (WebSocketServer item : webSocketSet) {
            try {
                item.sendMessage(message);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        logger.error("\u53d1\u751f\u9519\u8bef={}", (Object)JSON.toJSONString((Object)session));
        error.printStackTrace();
    }

    public void sendMessage(String message) throws IOException {
        logger.info("sendMessage={}", (Object)JSON.toJSONString((Object)message));
        try {
            this.session.getBasicRemote().sendText(message);
        }
        catch (Exception e) {
            e.getMessage();
            logger.info("\u63a8\u9001\u6d88\u606f\u5f02\u5e38\u9519\u8bef={}", (Object)JSON.toJSONString((Object)e.getMessage()));
        }
    }

    public static void sendInfo(String message, @PathParam(value="sid") String sid) {
        logger.info("\u63a8\u9001\u6d88\u606f\u5230\u7a97\u53e3\uff0c\u63a8\u9001\u5185\u5bb9:" + message + sid);
        for (WebSocketServer item : webSocketSet) {
            try {
                if (sid == null) {
                    item.sendMessage(message);
                    logger.info("socket\u8fdb\u5165 if");
                    continue;
                }
                if (!item.sid.equals(sid)) continue;
                logger.info("socket\u8fdb\u5165 else");
                item.sendMessage(message);
            }
            catch (IOException e) {}
        }
    }

    public static synchronized int getOnlineCount() {
        return onlineCount;
    }

    public static synchronized void addOnlineCount() {
        ++onlineCount;
    }

    public static synchronized void subOnlineCount() {
        --onlineCount;
    }

    static {
        logger = LoggerFactory.getLogger(WebSocketServer.class);
        webSocketSet = new CopyOnWriteArraySet();
    }
}

