/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.bizvane.appletservice.interfaces.UserService;
import com.bizvane.appletservice.interfaces.UserTeamService;
import com.bizvane.appletservice.models.User;
import com.bizvane.appletservice.models.UserTeam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserTeamController {
    @Autowired
    private UserTeamService userTeamService;
    @Autowired
    private UserService userService;

    @RequestMapping(value={"addTeam"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> addTeam(Integer id, String name) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int count = this.userTeamService.queryTeamNameById(id, name);
        if (count > 0) {
            map.put("errCode", 400);
            return map;
        }
        UUID randomUUID = UUID.randomUUID();
        UserTeam ut = new UserTeam();
        ut.setId(randomUUID.toString());
        ut.setUserId(id);
        ut.setName(name);
        this.userTeamService.addTeam(ut);
        map.put("errCode", 200);
        map.put("teamId", randomUUID.toString());
        return map;
    }

    @RequestMapping(value={"updateTeam"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> updateTeam(String teamId, String name, Integer id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int count = this.userTeamService.queryTeamNameById(id, name);
        if (count > 0) {
            map.put("errCode", 400);
            return map;
        }
        this.userTeamService.updateTeam(teamId, name);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"getTeam"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> getTeam(Integer id, double lng, double lat) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = this.userTeamService.getTeam(id);
        if (list.size() > 0) {
            for (UserTeam ut : list) {
                if (ut.getList().size() <= 0) continue;
                for (User one : ut.getList()) {
                    User um = this.userService.queryByUserTestOne(one.getUserId());
                    if (um.getUserJuli() == 3) continue;
                    if (um.getLatttud() != lat) {
                        User ur = this.userService.queryByUserId(one.getUserId(), Double.valueOf(lat), Double.valueOf(lng));
                        double dic = ur.getDic();
                        one.setDistance(String.valueOf(dic) + "km");
                        continue;
                    }
                    one.setDistance("0.00km");
                }
            }
        }
        map.put("list", list);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"deleteTeam"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> deleteTeam(Integer id, String teamId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.userTeamService.deleteTeamAndFriends(id, teamId);
        map.put("errCode", 200);
        return map;
    }

    @RequestMapping(value={"moveTeam"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> moveTeam(Integer id, String friendId, String teamId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] split = friendId.split(",");
        int[] friends = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            friends[i] = Integer.parseInt(split[i]);
            this.userTeamService.moveTeam(id, Integer.valueOf(friends[i]), teamId);
        }
        map.put("errCode", 200);
        return map;
    }

    private static double dis(double centerLon, double centerLat, double targetLon, double targetLat) {
        double jl_jd = 102834.74258026089;
        double jl_wd = 111712.69150641056;
        double b = Math.abs((centerLat - targetLat) * jl_jd);
        double a = Math.abs((centerLon - targetLon) * jl_wd);
        return Math.sqrt(a * a + b * b);
    }
}

