package com.bizvane.appletservice.models.vo;

import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * @ClassName CreateRechargeVO
 * @DescriptTion :充值请求
 * @Auther: wd
 * @Date :2018/12/10 10:52
 */
public class CreateRechargeVO {
	/**
	 * 充值金额
	 */
	@NotNull
	// @Min(value = 1)
	private String money;
	/**
	 * 充值原因
	 */
	private String remake;
	/**
	 * 用户登录凭证
	 */
	private String code;

	/**
	 * openid
	 */
	private String openid;

	private String memberCode;

	private Long sysBrandId;
	private String appId;
	private String giveMoney;

	private String activityId;

	private String userId;

	/**
	 * 会员充值说明表id
	 */
	private Long mbrRechargeExplainId;

	@ApiModelProperty(value = "ur储蓄卡卡面code")
	private String cardStyleCode;

	@ApiModelProperty(value = "ur储蓄名称")
	private String name;

	@ApiModelProperty(value = "依文卡类型")
	private Long cardType;

	@ApiModelProperty(value = "依文多储值卡卡号")
	private String storedCardCode;

	/**
	 * 验签 防止恶意充值
	 */
	private String sign;

	@ApiModelProperty(value = "储值卡卡号Id")
	private Long petCardId;

	@ApiModelProperty(value = "储值卡卡号")
	private String petCardNo;

	@ApiModelProperty(value = "储值卡归属类型 1.品牌 2.运营组织")
	private Integer petCardSourceType;

	@ApiModelProperty(value = "储值卡归属组织code")
	private String petCardOrgCode;


	public String getSign() {
		return sign;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCardStyleCode() {
		return cardStyleCode;
	}

	public void setCardStyleCode(String cardStyleCode) {
		this.cardStyleCode = cardStyleCode;
	}

	public String getMoney() {
		return money;
	}

	public void setMoney(String money) {
		this.money = money;
	}

	public String getRemake() {
		return remake;
	}

	public void setRemake(String remake) {
		this.remake = remake;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getOpenid() {
		return openid;
	}

	public void setOpenid(String openid) {
		this.openid = openid;
	}

	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	public Long getSysBrandId() {
		return sysBrandId;
	}

	public void setSysBrandId(Long sysBrandId) {
		this.sysBrandId = sysBrandId;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public String getGiveMoney() {
		return giveMoney;
	}

	public void setGiveMoney(String giveMoney) {
		this.giveMoney = giveMoney;
	}

	@Override
	public String toString() {
		return "CreateRechargeVO{" +
				"money='" + money + '\'' +
				", remake='" + remake + '\'' +
				", code='" + code + '\'' +
				", openid='" + openid + '\'' +
				", memberCode='" + memberCode + '\'' +
				", sysBrandId=" + sysBrandId +
				", appId='" + appId + '\'' +
				", giveMoney='" + giveMoney + '\'' +
				", activityId='" + activityId + '\'' +
				", cardStyleCode='" + cardStyleCode + '\'' +
				", name='" + name + '\'' +
				'}';
	}

	public String getActivityId() {
		return activityId;
	}

	public Long getCardType() {
		return cardType;
	}

	public void setCardType(Long cardType) {
		this.cardType = cardType;
	}

	public void setActivityId(String activityId) {
		this.activityId = activityId;
	}

    public String getStoredCardCode() {
        return storedCardCode;
    }

    public void setStoredCardCode(String storedCardCode) {
        this.storedCardCode = storedCardCode;
    }

	public Long getMbrRechargeExplainId() {
		return mbrRechargeExplainId;
	}

	public void setMbrRechargeExplainId(Long mbrRechargeExplainId) {
		this.mbrRechargeExplainId = mbrRechargeExplainId;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public Long getPetCardId() {
		return petCardId;
	}

	public void setPetCardId(Long petCardId) {
		this.petCardId = petCardId;
	}

	public String getPetCardNo() {
		return petCardNo;
	}

	public void setPetCardNo(String petCardNo) {
		this.petCardNo = petCardNo;
	}

	public Integer getPetCardSourceType() {
		return petCardSourceType;
	}

	public void setPetCardSourceType(Integer petCardSourceType) {
		this.petCardSourceType = petCardSourceType;
	}

	public String getPetCardOrgCode() {
		return petCardOrgCode;
	}

	public void setPetCardOrgCode(String petCardOrgCode) {
		this.petCardOrgCode = petCardOrgCode;
	}

}
