package com.bizvane.appletservice.models.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;

/**
 * 支付回调 VO
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年04月30日 13:54:00
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class UnionPayCallBackVO {
    /**
     * 支付服务商户号
     */
    @NotNull
    private String bizvaneMid;

    /**
     * 加密数据
     */
    @NotNull
    private String cryptData;

    /**
     * 支付平台流水号(alipay wechatpay)
     */
    @NotNull
    private String transactionid;

    /**
     * 总金额
     */
    @NotNull
    private String totalFee;

    /**
     * 支付服务流水号
     */
    @NotNull
    private String bizvaneTradeNo;

    /**
     * 业务生成的流水号
     */
    @NotNull
    private String outTradeNo;

    /**
     * 支付状态 包含unknown 暂时未处理
     */
    @NotNull
    private String payStatus;

    /**
     * openid
     */
    @NotNull
    private String buyerUserId;

    /**
     * 支付类型
     */
    @NotNull
    private String payType;

    /**
     * 附加信息
     */
    private String attach;

    /**
     * 实际支付金额
     */
    @NotNull
    private String cashFee;

    @NotNull
    private String timeEnd;

    /**
     * 支付业务类型,枚举PayBusinessTypeEnum.class
     */
    private Integer payBusinessType;

}
