package com.bizvane.appletservice.interfaces;

import com.bizvane.appletservice.models.bo.*;
import com.bizvane.appletservice.models.vo.ParamProcessingVo;
import com.bizvane.appletservice.models.vo.WxMbrRegisteRequestVo;
import com.bizvane.utils.responseinfo.ResponseData;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * 会员信息
 *
 * @author gs
 */
public interface LoginService {

    /**
     * 根据BizsessionId获取memberCode
     * @param request
     * @return
     */
    String getMemberCode(HttpServletRequest request);

    /**
     * 根据BizsessionId获取memberCode
     * @return
     */
    String getMemberCode();

    /**
     * 获取登陆者的相关
     * @return
     */
    MemberResoucreBO getMemberResourceBO();

    /**
     * 登陆
     *
     * @param bo
     * @return
     */
    ResponseData<Map<String, Object>> login(AppletLoginBo bo);

    /**
     * 发送验证码
     *
     * @param phone
     * @return
     */
    ResponseData<Integer> sendVerificationCode(String sign,String usign,String phone, String sysBrandId,String areaCode);

    /**
     * 登录token 验证
     *
     * @param token
     * @return
     */
    ResponseData<Integer> loginToken(String token);

    /**
     * 中转接口
     *
     * @param
     * @return
     */
    ResponseData<AppletRefreshtoInterfaceBo> refreshtoInterface(String appId);

    /**
     * 解析code获取用户注册结果
     * @param code
     * @param appid
     * @return
     */
    ResponseData<AppletBrandMenberBo> getUserInfobyCode(String code, String appid);

    /**
     * 更新获取会员信息及注册开卡
     * @param request
     * @param wxMbrRegisteRequestVo
     * @return
     */
    ResponseData<AppletBrandMenberBo> getMbrAndOpenCard(HttpServletRequest request, WxMbrRegisteRequestVo wxMbrRegisteRequestVo);

    /**
     * 更新获取会员信息及注册开卡
     * @param request
     * @param wxMbrRegisteRequestVo
     * @return
     */
    ResponseData<AppletBrandMenberBo> getMbrNoOpenCardByUnionId(HttpServletRequest request, WxMbrRegisteRequestVo wxMbrRegisteRequestVo);

    /**
     * 电子会员卡开卡前,解析授权信息以及记录链路
     * @param request
     * @param wxMbrRegisteRequestVo
     * @return
     */
    ResponseData<AppletBrandMenberBo> resolveAndRecord(HttpServletRequest request, WxMbrRegisteRequestVo wxMbrRegisteRequestVo);

    /**
     * 电子会员卡开卡完成,剩余业务处理
     * @param request
     * @param wxMbrRegisteRequestVo
     * @return
     */
    ResponseData<AppletBrandMenberBo> businessAfterOpenCard(HttpServletRequest request, WxMbrRegisteRequestVo wxMbrRegisteRequestVo);

    /**
     * 电子会员卡开卡完成,剩余业务处理
     * @param request
     * @return
     */
    ResponseData standardMemberCardStatusModify( HttpServletRequest request);

    ResponseData paramProcessingAfterOpenCard(HttpServletRequest request , ParamProcessingVo paramProcessingVo);
}
