package com.bizvane.appletservice.interfaces;

import com.bizvane.appletservice.models.bo.AppletBrandMenberBo;
import com.bizvane.appletservice.models.bo.AppletBtfBo;
import com.bizvane.appletservice.models.bo.MemberResoucreBO;
import com.bizvane.appletservice.models.po.AppletResourcesPO;
import com.bizvane.appletservice.models.vo.*;
import com.bizvane.mktcenterservice.models.bo.TaskDetailBO;
import com.bizvane.utils.responseinfo.ResponseData;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 会员中心
 *
 * @author gs
 */
public interface MemberCenterService {
    /**
     * 首页
     *
     * @param
     * @return
     */
    ResponseData<AppletBtfBo> getBtfRel(AppletBrandMenberBo appletBrandMenberBo, HttpServletRequest request);

    /**
     * 首页轮播图
     * @param sysBrandId
     * @return
     */

    ResponseData<List<AppletResourcesPO>> getSlideImg(Long sysBrandId,HttpServletRequest request, HttpServletResponse response);

    /**
     * 首页模板样式
     * @param sysBrandId
     * @return
     */
    ResponseData<AppletBtfBo> getTemplateInfo(Long sysBrandId,HttpServletRequest request);

    ResponseData<AppletBtfBo> getHomePage(AppletBrandMenberBo appletBrandMenberBo, HttpServletRequest request, HttpServletResponse response);

    /**
     * 获取会员基本信息
     * @param memberBaseInfoVo
     * @param request
     * @return
     */
    ResponseData<MemberBaseInfoVo> getMemberInfo(MemberBaseInfoVo memberBaseInfoVo, HttpServletRequest request);

    ResponseData processTraceForStore(String traceId, String memberCode, HttpServletRequest request);

    ResponseData<MemberConsumptionInfoVo> getConsumptionInfo(MemberResoucreBO memberResoucreBO);

    /**
     * 获取品牌小程序装修首页
     * @param brandId
     * @return
     */
    ResponseData<AppletHomeFitmentVo> getHomeByBrandId(Long brandId);

    /**
     * 获取品牌小程序首页会员信息
     * @param memberResoucreBO
     * @return
     */
    ResponseData<AppletHomeMemberVo> getMbrHomeInfo(Byte roundingMode,MemberResoucreBO memberResoucreBO);

    /**
     * 获取品牌小程序导航生活,服务详情页
     * @param brandId
     * @param navigationType
     * @return
     */
    ResponseData<List<AppletFitmentVo>> getNaviDetail(Long brandId, Integer navigationType);

    ResponseData<MemberConsumptionInfoVo> getConsumptionInfoDb(MemberResoucreBO memberResoucreBO);

    /**
     * 查询会员符合最近完善资料的任务
     * @param memberResoucreBO
     * @return
     */
    ResponseData<List<TaskDetailBO>> getAccordWithProfileTask(MemberResoucreBO memberResoucreBO);
}
