package com.bizvane.appletservice.interfaces.alipay;

import com.bizvane.appletservice.models.bo.AppletBrandMenberBo;
import com.bizvane.appletservice.models.vo.AlipayMbrRegisterRequestVo;
import com.bizvane.appletservice.models.vo.ElectCardConfigVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;

/**
 * 会员信息
 *
 * @author gs
 */
public interface AlipayLoginService {


    /**
     * 解析code获取用户注册结果
     * @param code
     * @param appid
     * @return
     */
    ResponseData<AppletBrandMenberBo> getUserInfobyCode(String code, String appid);

    /**
     * 更新获取会员信息及注册开卡
     * @param request
     * @param wxMbrRegisteRequestVo
     * @return
     */
    ResponseData getMbrAndOpenCard(HttpServletRequest request, AlipayMbrRegisterRequestVo wxMbrRegisteRequestVo);

    ResponseData<ElectCardConfigVo> getElectCardConfig(String appId);

    ResponseData<AppletBrandMenberBo> businessAfterOpenCard(HttpServletRequest request, @RequestBody AlipayMbrRegisterRequestVo alipayMbrRegisterRequestVo);
}
