package com.bizvane.appletservice.models.po;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;

/**
    * 活动表-线下报名
    */
@ApiModel(value="com-bizvane-appletservice-models-po-TMktActivityRegistration")
@Data
public class TMktActivityRegistration {
    /**
    * pkid
    */
    @ApiModelProperty(value="pkid")
    private Long mktActivityRegistrationId;

    /**
    * 企业id
    */
    @ApiModelProperty(value="企业id")
    private Long sysCompanyId;

    /**
    * 品牌id
    */
    @ApiModelProperty(value="品牌id")
    private Long sysBrandId;

    /**
    * 关联活动id
    */
    @ApiModelProperty(value="关联活动id")
    private Long mktActivityId;

    /**
    * 非会员是否可以报名 1=可以 0=不可以
    */
    @ApiModelProperty(value="非会员是否可以报名 1=可以 0=不可以")
    private Boolean isSignupNoMember;

    /**
    * 报名费用类型：0=无需，1=积分
    */
    @ApiModelProperty(value="报名费用类型：0=无需，1=积分")
    private Integer registrationFeeType;

    /**
    * 报名费用
    */
    @ApiModelProperty(value="报名费用")
    private Integer registrationFee;

    /**
    * 报名人数限制
    */
    @ApiModelProperty(value="报名人数限制")
    private Integer registrationNumberLimit;

    /**
    * 自定义属性
    */
    @ApiModelProperty(value="自定义属性")
    private String customProperties;

    /**
    * 备注
    */
    @ApiModelProperty(value="备注")
    private String remark;

    /**
    * 创建人id
    */
    @ApiModelProperty(value="创建人id")
    private Long createUserId;

    /**
    * 创建人姓名
    */
    @ApiModelProperty(value="创建人姓名")
    private String createUserName;

    /**
    * 创建时间
    */
    @ApiModelProperty(value="创建时间")
    private Date createDate;

    /**
    * 修改人id
    */
    @ApiModelProperty(value="修改人id")
    private Long modifiedUserId;

    /**
    * 修改人姓名
    */
    @ApiModelProperty(value="修改人姓名")
    private String modifiedUserName;

    /**
    * 修改时间
    */
    @ApiModelProperty(value="修改时间")
    private Date modifiedDate;

    /**
    * 数据有效性：1=有效；0=无效
    */
    @ApiModelProperty(value="数据有效性：1=有效；0=无效")
    private Boolean valid;
}