package com.bizvane.appletservice.interfaces;

import com.bizvane.mktcenterservice.models.po.MktActivityPrizePO;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizeRecordPO;
import com.bizvane.mktcenterservice.models.vo.ActivityPrizeBO;
import com.bizvane.utils.responseinfo.ResponseData;

import java.text.ParseException;

/**
 * 抽奖
 *
 * @author gs
 */
public interface MemberLotteryService {
    /**
     * 抽奖活动记录
     *
     * @param
     * @return
     */
    ResponseData<MktActivityPrizeRecordPO> winningRecord(MktActivityPrizeRecordPO mktActivityPrizeRecordPO);

    /**
     * 抽奖活动规则
     *
     * @param
     * @return
     */
    ResponseData<ActivityPrizeBO> activityRules(String activePriceCode);

    /**
     * 抽奖动作
     *
     * @param
     * @return
     */
    ResponseData lotteryDoIng(String activePriceCode, String memberCode);

    /**
     * 积分获取途径说明
     *
     * @param
     * @return
     */
    ResponseData<ActivityPrizeBO> theWayToAcquireIntegral(String activePriceCode);

    /**
     * 抽奖首页
     *
     * @param
     * @return
     */
    ResponseData<ActivityPrizeBO> luckDraw(String activePriceCode, String memberCode) throws ParseException;

    /**
     * 轮播图
     *
     * @param
     * @return
     */
    ResponseData<MktActivityPrizeRecordPO> rotation(MktActivityPrizeRecordPO mktActivityPrizeRecordPO);

    /**
     * 我的积分
     *
     * @param
     * @return
     */
    ResponseData countIntegral(String memberCode);

    /**
     * 公共判断活动范围
     *
     * @param
     * @return
     */
    ResponseData scanningLottery(String memberCode, String activityCode);

    /**
     * 实物中奖新增收货地址
     *
     * @param
     * @return
     */
    void addressLotteryRecord(MktActivityPrizeRecordPO mktActivityPrizeRecordPO);

}
