package com.bizvane.appletservice.interfaces;

import com.bizvane.appletservice.models.bo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @ClassName CreateMembersCardService
 * @DescriptTion :
 * @Auther: wd
 * @Date :2019/1/16 15:41
 */
public interface CreateMembersCardService {
    /**
     * 创建会员卡
     * @param createMembersCardBO
     * @return
     */
    @ApiOperation(value = "创建会员卡")
    ResponseData<String> createMembersCard(CreateMembersCardBO createMembersCardBO);

    /**
     * 接口激活
     * @param wxInterfaceActivateBO
     * @return
     */
    @ApiOperation(value = "激活会员卡")
    ResponseData<String> interfaceActivate(WxInterfaceActivateBO wxInterfaceActivateBO);

    /**
     * 更新会员卡
     * @param updateMembersCardBO
     * @return
     */
    @ApiOperation(value = "更新会员卡")
    ResponseData<String> updateMembersCard(UpdateMembersCardBO updateMembersCardBO);

    /**
     * 生成二维码
     * @param generateQrCode
     * @return
     */
    @ApiOperation(value = "生成二维码")
    ResponseData<String> generateQrCode(GenerateQrCode generateQrCode);

    /**
     * 更新会员积分
     * @param updateMemberInfo
     * @return
     */
    @ApiOperation(value = "更新会员积分")
    ResponseData<String> updateMemberIntegral(UpdateMemberInfo updateMemberInfo);

    /**
     * 更新注册信息
     * @param cardId
     * @param sysBrandId
     * @return
     */
    ResponseData<String> updateMemberRegInfo(String cardId, Long sysBrandId);


    /**
     * 创建电子会员卡url
     * @param sysCompanyId
     * @param sysBrandId
     * @param cardId
     * @param outStr
     * @return
     */
    ResponseData<String> createMemberCardUrl(Long sysCompanyId,Long sysBrandId,String cardId,String outStr);


    /**
     * 获取用户填写信息
     * @param accessToken
     * @param activateTicket
     * @return
     */
    ResponseData<List<Map<String,String>>> getActivateTempInfo(String accessToken, String activateTicket);
}
