package com.bizvane.appletservice.models.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * 银联支付to mq Vo
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年05月01日 15:41:00
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class UnionPay2MQVo {

    private String erpId;

    private String name;

    private String cardNo;

    private Long sysBrandId;

    private Double rechargeMoney;

    private Double giveMoney;

    private String payVoucherNo;

    private String outTradeNo;

    private Long state;

    private Date createDate;

    private Date paymentDate;

    private String memberCode;

    private Integer payId;

    private Long levelId;

    private Integer retryTime;

    private Integer rechargeType;

    /**
     * 商户id
     */
    private String bizvaneMerchantId;

    /**
     * 储值卡卡号Id
     */
    private Long mbrRechargeCardId;

    /**
     * 储值卡卡号
     */
    private String mbrPetCardNo;

    /**
     * 储值卡归属类型 1.品牌 2.运营组织
     */
    private Integer mbrPetCardSourceType;

    /**
     * 储值卡归属组织code
     */
    private String mbrPetCardOrgCode;

    private Long sysCompanyId;

    /**
     * 支付类型
     */
    private String payType;

}
