package com.bizvane.appletservice.interfaces;

import com.bizvane.appletservice.models.vo.vg.VGActivityRedPacketVO;
import com.bizvane.mktcenterservice.models.bo.MktActivityRedPacketRecordBO;
import com.bizvane.mktcenterservice.models.po.MktActivityRedPacketBatchPO;
import com.bizvane.mktcenterservice.models.vg.ActivityRedPacketInvitedRewardVo;
import com.bizvane.mktcenterservice.models.vg.VGActivityRedPacketDetailVO;
import com.bizvane.mktcenterservice.models.vo.ActivityRedPacketVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 红包膨胀活动
 *
 * @author gs
 * @date 2019 01 17
 */
public interface RedEnvelopesExpandService {
    /**
     * 活动详情
     *
     * @param
     * @param
     * @param
     * @return
     */
    ResponseData selectActivityRedPacketDetail(ActivityRedPacketVO activityRedPacketVO);

    /**
     * 首页-活动详情
     * @param activityRedPacketVO
     * @return
     */
    ResponseData<VGActivityRedPacketVO> selectActivityRedPacketIndexV2(ActivityRedPacketVO activityRedPacketVO, HttpServletRequest request);

    /**
     * 发起
     *
     * @param
     * @param
     * @param
     * @return
     */
    ResponseData andActivityRedPacketCreateRecord(ActivityRedPacketVO activityRedPacketVO);

    /**
     * 助力
     *
     * @param
     * @param
     * @param
     * @return
     */
    ResponseData<Integer> andActivityRedPacketZhuliRecord(ActivityRedPacketVO activityRedPacketVO);

    /**
     * 拆红包
     *
     * @param
     * @param
     * @param
     * @return
     */
    ResponseData andActivityRedPacketSendCouponRecord(ActivityRedPacketVO activityRedPacketVO);

    /**
     * 助力记录
     *
     * @param
     * @param
     * @param
     * @return
     */
    ResponseData getRedPacketZhuLiRecord(ActivityRedPacketVO activityRedPacketVO);

    /**
     * 领劵记录
     *
     * @param
     * @param
     * @param
     * @return
     */
    ResponseData<List<MktActivityRedPacketRecordBO>> getRedPacketCoponAppRecord(ActivityRedPacketVO activityRedPacketVO);

    /**
     * 批次-活动详情
     * @param activityRedPacketVO
     * @return
     */
    ResponseData<VGActivityRedPacketDetailVO> selectActivityRedPacketDetailV2(ActivityRedPacketVO activityRedPacketVO, HttpServletRequest request);



    /**
     * 发起
     *
     * @param
     * @param
     * @param
     * @return
     */
    ResponseData<MktActivityRedPacketBatchPO> andActivityRedPacketCreateRecordV2(ActivityRedPacketVO activityRedPacketVO, HttpServletRequest request);

    /**
     * 助力
     * @param activityRedPacketVO
     * @return
     */
    ResponseData<ActivityRedPacketInvitedRewardVo> andActivityRedPacketZhuliRecordV2(ActivityRedPacketVO activityRedPacketVO, HttpServletRequest request);

    /**
     * 助力
     * @param activityRedPacketVO
     * @return
     */
    ResponseData<Boolean> checkActivityRedPacketSendCouponMax(ActivityRedPacketVO activityRedPacketVO);

    /**
     * 助力记录
     *
     * @param
     * @param
     * @param
     * @return
     */
    ResponseData getRedPacketZhuLiRecordV2(ActivityRedPacketVO activityRedPacketVO);

    /**
     * 拆红包
     *
     * @param
     * @param
     * @param
     * @return
     */
    ResponseData andActivityRedPacketSendCouponRecordV2(ActivityRedPacketVO activityRedPacketVO);

    /**
     * 查看中奖记录
     * @param vo
     * @return
     */
    ResponseData getActivityRedPacketPriceRecord(@RequestBody ActivityRedPacketVO vo);

}
