package com.bizvane.appletservice.rpc.vg;

import com.bizvane.appletservice.models.po.AppletResourcesPO;
import com.bizvane.appletservice.models.vo.MemberOpenCardStoreVo;
import com.bizvane.appletservice.models.vo.vg.VGAlipaySlideImgRequestVo;
import com.bizvane.appletservice.models.vo.vg.VGAlipaySlideImgResponseVo;
import com.bizvane.appletservice.models.vo.vg.VGSubscribeMsgAuthRequestVo;
import com.bizvane.appletservice.models.vo.vg.VGSubscribeMsgAuthResponseVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.applet.name}", path = "${feign.client.applet.path}/memberCenterServiceRpc")
public interface MemberCenterServiceRpc {

    @PostMapping("/getSlideImg")
    ResponseData<List<VGAlipaySlideImgResponseVo>> getSlideImg(@RequestBody VGAlipaySlideImgRequestVo vgAlipaySlideImgRequestVo);

    @PostMapping("/queryBrandWechatAppletSubscribeDataRedis")
    VGSubscribeMsgAuthResponseVo queryBrandWechatAppletSubscribeDataRedis(@RequestBody VGSubscribeMsgAuthRequestVo subscribeMsgAuthRequestVo);

    @RequestMapping(value = "/searchStoresByRecordId", method = RequestMethod.POST)
    ResponseData searchStoresByRecordId(@RequestBody MemberOpenCardStoreVo memberOpenCardStoreVo);
}
