package com.bizvane.appletservice.rpc.vg;

import com.bizvane.appletservice.models.bo.BlindBoxOrderUpdateBO;
import com.bizvane.appletservice.models.vo.BlindBoxOrderVO;
import com.bizvane.messagebase.common.constants.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "${feign.client.applet.name}", path = "${feign.client.applet.path}/channel")
public interface BlindBoxVendingServiceRpc {


    /**
     * 查询盲盒订单详情
     * @param outTradeNo 盲盒订单号
     * @return
     */
    @GetMapping("/blindBox/selectByOutTradeNo")
    BlindBoxOrderVO selectByOutTradeNo(@RequestParam("outTradeNo") String outTradeNo);

    /**
     *
     * @param blindBoxOrderUpdateBO 盲盒订单号\小程序订单号
     * @return boolean
     */
    @PostMapping("/blindBox/updateByOutTradeNo")
    Boolean updateByOutTradeNo(@RequestBody BlindBoxOrderUpdateBO blindBoxOrderUpdateBO );


}
