package com.bizvane.appletservice.models.vo.seckill;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author yifei
 * @since 2022/7/15
 */
@Setter
@Getter
@ToString
public class SeckillActivityCreateOrderRequestVO implements Serializable {
    private static final long serialVersionUID = -3793283885994862082L;

    /**
     * 活动编码
     */
    @NotBlank(message = "活动编码不能为空")
    private String activityCode;

    /**
     * 商品id
     */
    private String goodsId;

    /**
     * 品牌id
     */
    private String sysBrandId;

    /**
     * 公司id
     */
    private Long sysCompanyId;

    /**
     * 会员编码
     */
    private String memberCode;

    private String memberCardNo;
    private String memberName;
    private String memberPhone;
    private String goodId;
    private String goodNo;
    private String openId;
    private String shippingName;
    private String shippingMobile;
    private String shippingProvince;
    private String shippingCity;
    private String shippingDistrict;
    private String shippingAddress;
    private String userComments;
    private String goodSkuId;
    private String goodSkuNo;
    private String goodSkuSpecNames;
    private String saleIntegral;
    private String saleQuantity;
    private String orderType;
    private String storeCode;
    private String storeName;
    private String storeId;
    private String exchangeStatus;
    private String exchangeCount;
    private String templateId;
    private String selfPickTime;
    /**
     * 支付方式
     * "0","积分价",
     * "1","现金价",
     * "2","积分+现金价"
     */
    private String priceType;

    // 订单备注
    private String orderRemark;

    private String secondPrice;

    @ApiModelProperty(value = "商品类型：0普通商品1电子卡卷", name = "goodsType")
    private Integer goodsType;

    /**
     * 渠道来源id
     */
    private Long sourceId;

}
