package com.bizvane.appletservice.models.vo.seckill;

import com.bizvane.appletservice.models.vo.ConfirmGoodsVo;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;


/**
 * @author yifei
 * @since 2022/7/5
 */
@Setter
@Getter
@ToString
public class SeckillActivityBaseRequestVO {
    /**
     * 活动编码
     */
    @NotBlank(message = "活动编码不能为空")
    private String activityCode;

    /**
     * 商品id
     */
    private String goodsId;

    /**
     * 兑换券Id
     */
    private Long exchangeId;

    /**
     * 品牌id
     */
    private Long sysBrandId;

    /**
     * 公司id
     */
    private Long sysCompanyId;

    /**
     * 分页参数
     */
    private Integer pageSize;

    /**
     * 分页参数
     */
    private Integer pageIndex;

    /**
     * 会员编码
     */
    private String memberCode;

    /**
     * 订单信息
     */
    private ConfirmGoodsVo confirmGoodsVo;

    /**
     * 支付方式
     * "0","积分价",
     * "1","现金价",
     * "2","积分+现金价"
     */
    private String priceType;

    /**
     * 订单备注
     */
    private String orderRemark;

    /**
     * 渠道来源id
     */
    private Long sourceId;

}
