package com.bizvane.appletservice.interfaces;

import com.bizvane.mktcenterservice.models.bo.MktActivityPrizeRecordBO;
import com.bizvane.mktcenterservice.models.po.MktActivityPOWithBLOBs;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizeRecordPO;
import com.bizvane.mktcenterservice.models.vo.ActivityPrizeBO;
import com.bizvane.mktcenterservice.models.vo.ActivityPrizeRecordDetailBO;
import com.bizvane.utils.responseinfo.ResponseData;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;

/**
 * 抽奖
 *
 * @author gs
 */
public interface MemberLotteryService {
    /**
     * 抽奖活动记录
     *
     * @param
     * @return
     */
    @Deprecated
    ResponseData<MktActivityPrizeRecordPO> winningRecord(MktActivityPrizeRecordPO mktActivityPrizeRecordPO);

    /**
     * 抽奖活动记录,返回奖项图片
     * @param mktActivityPrizeRecordPO
     * @return
     */
    ResponseData<MktActivityPrizeRecordBO> winningRecordNew(MktActivityPrizeRecordPO mktActivityPrizeRecordPO);
    /**
     * 抽奖活动规则
     *
     * @param
     * @return
     */
    ResponseData<ActivityPrizeBO> activityRules(String activePriceCode);

    /**
     * 抽奖活动规则
     *
     * @param
     * @return
     */
    ResponseData<MktActivityPOWithBLOBs> activityRulesNew(String activePriceCode);

    /**
     * 抽奖动作
     *
     * @param
     * @return
     */
    ResponseData lotteryDoIng(String activePriceCode, String memberCode, Long sourceId);

    /**
     * 积分获取途径说明
     *
     * @param
     * @return
     */
    ResponseData<ActivityPrizeBO> theWayToAcquireIntegral(String activePriceCode);

    /**
     * 抽奖首页
     *
     * @param
     * @return
     */
    ResponseData<ActivityPrizeBO> luckDraw(String activePriceCode, String memberCode) throws ParseException;

    /**
     * 轮播图
     *
     * @param
     * @return
     */
    ResponseData<MktActivityPrizeRecordPO> rotation(MktActivityPrizeRecordPO mktActivityPrizeRecordPO);

    /**
     * 我的积分
     *
     * @param
     * @return
     */
    ResponseData countIntegral(String memberCode);

    /**
     * 公共判断活动范围
     *
     * @param
     * @return
     */
    ResponseData scanningLottery(String memberCode, String activityCode);

    /**
     * 实物中奖新增收货地址
     *
     * @param
     * @return
     */
    void addressLotteryRecord(MktActivityPrizeRecordPO mktActivityPrizeRecordPO);

    /**
     * 实物配置物流地址或者自提门店code
     *
     * @param
     * @return
     */
    ResponseData addressLotteryRecordNew(MktActivityPrizeRecordPO mktActivityPrizeRecordPO);

    /**
     * 根据中奖ID获取详情
     * @param mktActivityPrizeRecordPo
     * @return
     */
    ResponseData<ActivityPrizeRecordDetailBO> winningRecordDetail(MktActivityPrizeRecordPO mktActivityPrizeRecordPo);
}
