package com.bizvane.appletservice.models.vo;

import com.bizvane.members.facade.models.MbrLevelModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.List;

/**
 * 商品
 *
 * @author gs
 * @date 2019/3/18
 */
@Data
@ToString
public class ShopStoreVo {
    private String ShopId;
    //商品名称
    private String goodsNo;
    //积分
    private String price;
    private String goodsName;
    //上架时间
    private String upperShelfTime;
    //商品图片
    private String coverImg;
    private List<String> bannerImgPaths;
    private String classifyId;
    //兑换数量
    private String actualSales;
    //限对数量
    private String restrictedNum;
    private String shelf;
    private String hot;
    private String distributionMode;
    private String goodsDetails;
    private List<ShopStoreSkuVo> shopStoreSkuVos;
    private List<ShopClassifyMapVo> classifyMapVos;
    private ShopVo shopVo;
    private String exchangeInstructions;
    private Integer exchangeStatus;
    private Integer exchangeCount;
    private Integer isWholeStore;
    //商品总库存
    private Integer totalStock;
    //积分商城商品类型
    private Integer goodsType;

    private String priceType;

    private String cashPrice;

    private Integer templateId;

    private Integer freightType;

    private BigDecimal defaultFreight;

    private String exchangeClubId;
    private String exchangeClubName;
    private List<MbrLevelModel> mbrLevelModelList;
    private Boolean mbrLevelStatus;





    //yufeng  Design
    @ApiModelProperty("定时售卖周期类型  0-否 1-是")
    private Integer  regularSale;

    @ApiModelProperty("定时售卖周期类型  0-每天 1-每周 2-每月 3-自定义日期")
    private Integer  saleScheduled;

    @ApiModelProperty("售卖周期若为每天 则为NULL,每周为星期数逗号拼接如:1,3,4..，每月为日期拼接,如:1,20,22，自定义则该字段为日期")
    private String   saleTimeCycle;

    @ApiModelProperty("天维度开始时间,当天00:00:00到开始时间的毫秒数")
    private Long     dayStartTime;

    @ApiModelProperty("天维度结束时间,当天00:00:00到结束时间的毫秒数")
    private Long     dayEndTime;

    @ApiModelProperty("当前时间是够可售卖 0-不可售 1-可售")
    private Integer isSaleFlag;

    @ApiModelProperty(value = "积分+现金-现金价格")
    private  String secondCashPrice;

    @ApiModelProperty(value = "积分+现金-积分价格")
    private  String  secondPrice;

    @ApiModelProperty("视频地址URL")
    private String videoUrl;

    @ApiModelProperty("主视频第一帧")
    private String videoPictureUrl;

    @ApiModelProperty("自提门店类型")
    private Integer storeType;

    @ApiModelProperty("自提门店Id列表")
    private String storeLimitList ;

    @ApiModelProperty("门店信息")
    private List<SysStoreInfoVO> storeInfoList;

    @ApiModelProperty("消耗总积分")
    private String  allIntegralNumber;

    @ApiModelProperty("兑换总人数")
    private  String totalExchangeNumber;

    @ApiModelProperty("已售数量")
    private  String totalSaleQuantity;



}
