package com.bizvane.appletservice.interfaces;

import com.bizvane.appletservice.models.vo.vg.VGSubscribeMessageCloseRequestVo;
import com.bizvane.appletservice.models.vo.vg.VGSubscribeMessageRequestVo;
import com.bizvane.appletservice.models.vo.vg.VGSubscribeMsgAuthRequestVo;
import com.bizvane.appletservice.models.vo.vg.VGSubscribeMsgAuthResponseVo;
import com.bizvane.messagefacade.models.vo.vg.WechatAppletSubscribeResponseVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

public interface WechatAppletSubscribeMsgService {

    /**
     * 查询小程序授权权限
     * @param subscribeMsgAuthRequestVo
     * @return
     */
    ResponseData<? extends WechatAppletSubscribeResponseVo> queryBrandWechatAppletSubscribe(VGSubscribeMsgAuthRequestVo subscribeMsgAuthRequestVo) ;

    /**
     * 查询小程序授权权限
     * @param subscribeMsgAuthRequestVo
     * @return
     */
    VGSubscribeMsgAuthResponseVo queryBrandWechatAppletSubscribeData(VGSubscribeMsgAuthRequestVo subscribeMsgAuthRequestVo);

    /**
     * 查询小程序授权权限redis
     * @param subscribeMsgAuthRequestVo
     * @return
     */
    VGSubscribeMsgAuthResponseVo queryBrandWechatAppletSubscribeDataRedis(VGSubscribeMsgAuthRequestVo subscribeMsgAuthRequestVo);

    /**
     * 清除缓存
     * @param subscribeMsgAuthRequestVo
     */
    void clearBrandWechatAppletSubscribeDataRedis(VGSubscribeMsgAuthRequestVo subscribeMsgAuthRequestVo);

    /**
     * 保存小程序点击授权记录
     * @param vgSubscribeMessageRequestVo
     * @return
     */
    ResponseData subscribeMessageRequest(@RequestBody @Valid VGSubscribeMessageRequestVo vgSubscribeMessageRequestVo);

    /**
     * 关闭小程序授权
     * @param vgSubscribeMessageCloseRequestVo
     * @return
     */
    ResponseData closeSubscribeMessage(@RequestBody @Valid VGSubscribeMessageCloseRequestVo vgSubscribeMessageCloseRequestVo);
}
